<?php
// Veritabanı bağlantı bilgilerini buraya ekleyin
// Örnek:
$servername = "localhost";
$username = "fazmzhdg_main"; // Kendi kullanıcı adınız
$password = "76150Dima29326!@#";     // Kendi şifreniz
$dbname = "fazmzhdg_main";           // Kendi veritabanı adınız

// Veritabanı bağlantısı oluşturma
$conn = new mysqli($servername, $username, $password, $dbname);

// Bağlantıyı kontrol etme
if ($conn->connect_error) {
    die("Veritabanı bağlantısı başarısız: " . $conn->connect_error);
}

$arama_terimi = "";
$sonuclar = [];

// Arama terimi URL'den geliyorsa al
if (isset($_GET['q'])) {
    $arama_terimi = $conn->real_escape_string($_GET['q']);

    // Arama sorgusu (hizmet, blog, ürün, proje tablolarını birleştirerek arama yapabilirsiniz)
    // Bu, örnek bir sorgudur. Kendi veritabanı yapınıza göre uyarlamanız gerekecektir.
    $sql = "
    SELECT 'xidmet' AS tur, adi, seo, resim FROM xidmetler WHERE adi LIKE '%$arama_terimi%'
    UNION ALL
    SELECT 'blog' AS tur, adi, seo, resim FROM xeberler WHERE adi LIKE '%$arama_terimi%'
    UNION ALL
    SELECT 'mehsul' AS tur, adi, seo, resim FROM mehsullar WHERE adi LIKE '%$arama_terimi%'
    UNION ALL
    SELECT 'layihe' AS tur, adi, seo, resim FROM layiheler WHERE adi LIKE '%$arama_terimi%'
    ";

    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $sonuclar[] = $row;
        }
    }
}
?>

<div class="section section-padding">
    <div class="container">
        <div class="product-section-wrapper">
            <div class="row flex-row-reverse">
                <div class="col-lg-9">
                    <div class="shop-top-bar">
                        <?php if ($arama_terimi): ?>
                            <h3 class="title">"<?= $arama_terimi ?>" Axtarış nəticəsi</h3>
                        <?php else: ?>
                            <h3 class="title">Axtarış etmək üçün mətin yazın.</h3>
                        <?php endif; ?>
                    </div>
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="grid">
                            <div class="shop-product-wrapper">
                                <div class="row">
                                    <?php if (!empty($sonuclar)): ?>
                                        <?php foreach ($sonuclar as $goster): ?>
                                            <div class="col-lg-4 col-sm-6">
                                                <div class="single-product">
                                                    <a href="<?= $goster["seo"] ?>">
                                                        <img src="sekiller/<?= $goster["resim"] ?>" width="270" height="303" alt="<?= $goster["adi"] ?>" />
                                                    </a>
                                                    <div class="product-content">
                                                        <h4 class="title">
                                                            <a href="<?= $goster["seo"] ?>"><?= $goster["adi"] ?></a>
                                                        </h4>
                                                    </div>
                                                    <ul class="product-meta">
                                                        <li>
                                                            <a class="action" data-bs-toggle="modal" data-bs-target="#quickView" href="#"><i class="pe-7s-search"></i></a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <div class="col-12">
                                            <p>Axtardığınız ad və ya mətinə aid bir nəticə tapılmadı.</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
// Veritabanı bağlantısını kapat
$conn->close();
?>