<?php
// Hata raporlama ayarları
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', 'error.log');

// Güvenlik fonksiyonları
function guvenliGiris($data)
{
    return htmlspecialchars(strip_tags(trim($data)));
}

function guvenliSorgu($db, $sql, $params = [])
{
    try {
        $stmt = $db->prepare($sql);
        $stmt->execute($params);
        return $stmt;
    } catch (PDOException $e) {
        error_log("Veritabanı hatası: " . $e->getMessage());
        return false;
    }
}

// Önbellek fonksiyonu
function getCachedData($key, $ttl, $callback)
{
    $cacheDir = __DIR__ . '/cache';
    if (!file_exists($cacheDir)) {
        mkdir($cacheDir, 0755, true);
    }

    $cacheFile = $cacheDir . '/' . md5($key) . '.cache';

    if (file_exists($cacheFile) && (time() - filemtime($cacheFile) < $ttl)) {
        return unserialize(file_get_contents($cacheFile));
    }

    $data = $callback();
    if ($data !== false) {
        file_put_contents($cacheFile, serialize($data));
    }
    return $data;
}

include "baglan.php";
function oturumkontrolana()
{
    if (empty($_SESSION["eposta"])) {
        echo '<script language="javascript">window.location="daxil-ol.php";</script>';
        die();
    }
}
function oturumkontrolana1()
{
    if (empty($_SESSION["email"])) {
        echo '<script language="javascript">window.location="daxil-ol";</script>';
        die();
    }
}
date_default_timezone_set('Asia/Baku'); // Azerbaycan saat dilimini ayarla
$saat = date("H:i"); // Şu anki saati al (örneğin 15:30)
$tarih = date("d.m.Y"); // Şu anki tarihi al (örneğin 30.05.2025)


$kur = simplexml_load_file("https://www.tcmb.gov.tr/kurlar/today.xml");
foreach ($kur->Currency as $cur) {
    if ($cur["Kod"] == "USD") {
        $usdAlis  = $cur->ForexBuying;
        $usd = $cur->ForexSelling;
    }

    if ($cur["Kod"] == "EUR") {
        $eurAlis  = $cur->ForexBuying;
        $euro = $cur->ForexSelling;
    }
}

function seflink($string)
    {
        $find = array(
        // Türkçe karakterler
            'Ç', 'Ş', 'Ğ', 'Ü', 'İ', 'Ö', 'ç', 'ş', 'ğ', 'ü', 'ö', 'ı',

        // Azerice karakterler
            'Ə', 'ə', 'X', 'x', 'Q', 'q', 'Ü', 'ü', 'Ö', 'ö', 'Ç', 'ç', 'Ş', 'ş', 'Ğ', 'ğ', 'İ', 'i',

        // Rusça karakterler
            'А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ё', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я',
            'а', 'б', 'в', 'г', 'д', 'е', 'ё', 'ж', 'з', 'и', 'й', 'к', 'л', 'м', 'н', 'о', 'п', 'р', 'с', 'т', 'у', 'ф', 'х', 'ц', 'ч', 'ш', 'щ', 'ъ', 'ы', 'ь', 'э', 'ю', 'я',

        // Diğer özel karakterler (isteğe bağlı olarak ekleyebilirsiniz)
            '+', '#', '.', '@', '&',
        );
        $replace = array(
        // Türkçe karşılıklar
            'C', 'S', 'G', 'U', 'I', 'O', 'c', 's', 'g', 'u', 'o', 'i',

        // Azerice karşılıklar (benzer Latin harflerine dönüştürülmüştür)
            'E', 'e', 'X', 'x', 'Q', 'q', 'U', 'u', 'O', 'o', 'C', 'c', 'S', 's', 'G', 'g', 'I', 'i',

        // Rusça karşılıklar (yaygın transliterasyon)
            'a', 'b', 'v', 'g', 'd', 'ye', 'yo', 'zh', 'z', 'i', 'y', 'k', 'l', 'm', 'n', 'o', 'p', 'r', 's', 't', 'u', 'f', 'kh', 'ts', 'ch', 'sh', 'shch', '', 'y', '', 'e', 'yu', 'ya',
            'a', 'b', 'v', 'g', 'd', 'ye', 'yo', 'zh', 'z', 'i', 'y', 'k', 'l', 'm', 'n', 'o', 'p', 'r', 's', 't', 'u', 'f', 'kh', 'ts', 'ch', 'sh', 'shch', '', 'y', '', 'e', 'yu', 'ya',

        // Diğer özel karakterler
            'plus', 'sharp', 'dot', 'at', 'and',
        );
        $string = strtolower(str_replace($find, $replace, $string));
    $string = preg_replace("@[^A-Za-z0-9\-_\+]@i", ' ', $string); // Noktayı da koruduk
    $string = trim(preg_replace('/\s+/', ' ', $string));
    $string = str_replace(' ', '-', $string);
    return $string;
}

// $apiUrl = "https://v6.exchangerate-api.com/v6/9fd4c704a35b6a5bcf3cd85c/latest/AZN"; // API anahtarınız burada doğru

// $aznToUsd = 'N/A';
// $aznToEur = 'N/A';

// // cURL oturumu başlat
// $ch = curl_init();

// // cURL seçeneklerini ayarla
// curl_setopt($ch, CURLOPT_URL, $apiUrl);
// curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Yanıtı string olarak döndür
// curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true); // SSL sertifikalarını doğrula (güvenlik için önerilir)

// // cURL isteğini çalıştır
// $response = curl_exec($ch);

// // Hata kontrolü
// if (curl_errno($ch)) {
//     // cURL hatası varsa, hata mesajını logla veya ekrana yaz
//     error_log("cURL Hatası: " . curl_error($ch));
//     echo "Döviz kurları alınamadı: cURL hatası (" . curl_error($ch) . ")"; // Kullanıcıya da bir mesaj göster
// } else {
//     // Yanıtı JSON'dan PHP nesnesine dönüştür
//     $data = json_decode($response);

//     // API yanıtını ve kurları kontrol et
//     if ($data && isset($data->result) && $data->result === 'success' && isset($data->conversion_rates)) {
//         if (isset($data->conversion_rates->USD)) {
//             $aznToUsd = round($data->conversion_rates->USD, 4);
//         }
//         if (isset($data->conversion_rates->EUR)) {
//             $aznToEur = round($data->conversion_rates->EUR, 4);
//         }
//     } else {
//         // API yanıtı geçersizse veya eksikse
//         error_log("Döviz kurları API'si geçersiz yanıt döndürdü veya kurlar eksik: " . print_r($data, true));
//         echo "Döviz kurları alınamadı: Geçersiz API yanıtı."; // Kullanıcıya mesaj
//     }
// }


// OpenWeatherMap API anahtarınızı buraya girin
$weatherApiKey = "efbeabee28d0426f2286d4b3a89dc5e9"; // Burayı kendi API anahtarınızla değiştirin!
$city = "Baku,AZ"; // Azerbaycan'ın başkenti Bakü için

$weatherUrl = "http://api.openweathermap.org/data/2.5/weather?q={$city}&appid={$weatherApiKey}&units=metric&lang=az"; // units=metric ile sıcaklığı Celcius olarak alın, lang=az ile Azerice açıklama alın

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $weatherUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 5); // 5 saniye zaman aşımı ekleyelim
$weatherResponse = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // HTTP durum kodunu alalım
curl_close($ch);

$havadurumu = null; // Varsayılan olarak null yapalım

if ($weatherResponse && $httpCode == 200) {
    $weatherData = json_decode($weatherResponse, true);

    if (json_last_error() === JSON_ERROR_NONE && $weatherData && $weatherData['cod'] == 200) {
        $sicaklik = $weatherData['main']['temp'];
        $aciklama = $weatherData['weather'][0]['description'];
        $simge = $weatherData['weather'][0]['icon'];

        $havadurumu = [
            'sicaklik' => round($sicaklik), // Tam sayıya yuvarlayalım
            'aciklama' => ucfirst($aciklama), // İlk harfi büyük yapalım
            'simge_url' => "http://openweathermap.org/img/wn/{$simge}@2x.png" // @2x daha büyük simge için
        ];
    } else {
        // JSON çözümlenemedi veya API hata döndürdü
        error_log("Hava durumu API yanıtı hatası: " . $weatherResponse);
    }
} else {
    // cURL hatası veya HTTP kodu 200 değil
    error_log("Hava durumu API'sine bağlantı hatası veya geçersiz HTTP kodu ({$httpCode}). Yanıt: " . ($weatherResponse ?: "Boş"));
}


$haqqimizda = $db->query("SELECT * FROM haqqimizda Where id='1'")->fetch(PDO::FETCH_ASSOC);

$panel = $db->query("SELECT * FROM panel Where id='1'")->fetch(PDO::FETCH_ASSOC);
$ayar = $db->query("SELECT * FROM tenzimlemeler Where id='1'")->fetch(PDO::FETCH_ASSOC);
$paytr = $db->query("SELECT * FROM paytr Where id='1'")->fetch(PDO::FETCH_ASSOC);
$paymax = $db->query("SELECT * FROM paymax Where id='1'")->fetch(PDO::FETCH_ASSOC);
$odeme_tur = $db->query("SELECT * FROM odeme_secenek Where id='1'")->fetch(PDO::FETCH_ASSOC);
$netgsm = $db->query("SELECT * FROM netgsm Where id='1'")->fetch(PDO::FETCH_ASSOC);
$shopier = $db->query("SELECT * FROM shopier Where id='1'")->fetch(PDO::FETCH_ASSOC);


$icazeler = $db->query("SELECT * FROM icazeler Where id='1'")->fetch(PDO::FETCH_ASSOC);

$sayfa = $db->query("SELECT * FROM sehifeler Where seo='haqqimizda'")->fetch(PDO::FETCH_ASSOC);

$alt = $db->query("SELECT * FROM sehifeler Where id='19'")->fetch(PDO::FETCH_ASSOC);

$elaqe = $db->query("SELECT * FROM elaqemelumatlari Where id='1'")->fetch(PDO::FETCH_ASSOC);

$sosyal = $db->query("SELECT * FROM sosialmedia Where id='1'")->fetch(PDO::FETCH_ASSOC);
$bead = $db->query("SELECT * FROM beadcrumb Where id='1'")->fetch(PDO::FETCH_ASSOC);
$reyindex = $db->query("SELECT * FROM beadcrumb Where id='1'")->fetch(PDO::FETCH_ASSOC);
$modal = $db->query("SELECT * FROM modal Where id='1'")->fetch(PDO::FETCH_ASSOC);


$idd = $_SESSION['id'];
$hesabim = $db->query("select * from admin where id='$idd'")->fetch(PDO::FETCH_ASSOC);

$smtp = $db->query("select * from mail where id='1'")->fetch(PDO::FETCH_ASSOC);


$adi = $haqqimizda['adi'];
$footer_h = $haqqimizda['footer'];
$video = $haqqimizda['video'];
$hresim = $haqqimizda['resim'];
$hresim2 = $haqqimizda['resim2'];
$aciklama = $haqqimizda['aciklama'];
$title = $ayar['site_title'];
$des = $ayar['site_description'];
$logo = $ayar['logo'];
$footerlogo = $ayar['footer_logo'];
$favicon  = $ayar['favicon'];
$author  = $ayar['site_author'];
$keyword  = $ayar['site_keyword'];
$copyright = $ayar['footer_copyright'];
$renk  = $ayar['renk'];
$header  = $ayar['header'];
$footer  = $ayar['footer'];
$renk2  = $ayar['renk2'];
$telefon1 = $elaqe['telefon1'];
$telefon2 = $elaqe['telefon2'];
$adres1 = $elaqe['adres1'];
$adres2 = $elaqe['adres2'];
$email1 = $elaqe['email1'];
$email2 = $elaqe['email2'];
$googlemaps = $elaqe['google_maps'];
$whatsapp = $elaqe['whatsapp'];
$wptext = $elaqe['wp_text'];
$wprenk = $elaqe['wp_renk'];

$onecikan = $db->query("SELECT * FROM onecikan Where id='1'")->fetch(PDO::FETCH_ASSOC);

// $slidercek = $db->query("SELECT * FROM slider Where veziyyeti='0' order by sira asc")->fetchAll(PDO::FETCH_ASSOC);
// $projekatcek = $db->query("SELECT * FROM layihe_kateqoriya Where veziyyeti='0' and kategori='0' order by sira asc")->fetchAll(PDO::FETCH_ASSOC);
// $projecek = $db->query("SELECT * FROM leyiheler Where veziyyeti='0' order by sira asc")->fetchAll(PDO::FETCH_ASSOC);
// $videocek = $db->query("SELECT * FROM video Where veziyyeti='0' order by sira asc")->fetchAll(PDO::FETCH_ASSOC);
// $bankacek = $db->query("SELECT * FROM banka Where veziyyeti='0' order by sira asc")->fetchAll(PDO::FETCH_ASSOC);

// $hizmetcek = $db->query("SELECT * FROM xidmetler Where veziyyeti='0' order by sira asc")->fetchAll(PDO::FETCH_ASSOC);
// $ekipcek = $db->query("SELECT * FROM komandamiz Where veziyyeti='0' order by sira asc")->fetchAll(PDO::FETCH_ASSOC);
$yorumcek = $db->query("SELECT * FROM reyler Where veziyyeti='0' order by sira asc")->fetchAll(PDO::FETCH_ASSOC);
// $refcek = $db->query("SELECT * FROM referanslar Where veziyyeti='0' order by sira asc")->fetchAll(PDO::FETCH_ASSOC);
// $blogcek = $db->query("SELECT * FROM xeberler Where veziyyeti='0' order by sira asc")->fetchAll(PDO::FETCH_ASSOC);
// $sayfacek = $db->query("SELECT * FROM sehifeler Where veziyyeti='0' order by sira asc")->fetchAll(PDO::FETCH_ASSOC);
$cvscek = $db->query("SELECT * FROM cvs Where veziyyeti='0' order by sira asc")->fetchAll(PDO::FETCH_ASSOC);
// $uruncek = $db->query("SELECT * FROM mehsullar Where veziyyeti='0' order by sira asc")->fetchAll(PDO::FETCH_ASSOC);
// $galericek = $db->query("SELECT * FROM galeri Where veziyyeti='0' order by sira asc")->fetchAll(PDO::FETCH_ASSOC);
// $istatikcek = $db->query("SELECT * FROM istatik Where veziyyeti='0' order by sira asc")->fetchAll(PDO::FETCH_ASSOC);
$yenille1 = $db->query("select * from icazeler where id='1'")->fetch(PDO::FETCH_ASSOC);
// $urunkatcek = $db->query("SELECT * FROM mehsul_kateqoriya Where veziyyeti='0' order by sira asc")->fetchAll(PDO::FETCH_ASSOC);


$facebook = $sosyal['facebook'];
$twitter = $sosyal['twitter'];
$instagram = $sosyal['instagram'];
$telegram = $sosyal['telegram'];
$youtube = $sosyal['youtube'];
$pinterest = $sosyal['pinterest'];
$linkedin = $sosyal['linkedin'];
$whatsappp = $sosyal['whatsappp'];



if (isset($_POST['hesabim-yenille'])) {
    $email = guvenliGiris($_POST["email"]);
    $telefon = guvenliGiris($_POST["telefon"]);
    $adsoyad = guvenliGiris($_POST["adsoyad"]);
    $uye = (int)$_POST["uye"];

    if (!empty($_POST["sifre"])) {
        $sifre = password_hash($_POST["sifre"], PASSWORD_DEFAULT);
        $elaveet = guvenliSorgu(
            $db,
            "UPDATE uyeler SET email = :email, telefon = :telefon, adsoyad = :adsoyad, sifre = :sifre WHERE id = :id",
            ["email" => $email, "telefon" => $telefon, "adsoyad" => $adsoyad, "sifre" => $sifre, "id" => $uye]
        );
    } else {
        $elaveet = guvenliSorgu(
            $db,
            "UPDATE uyeler SET email = :email, telefon = :telefon, adsoyad = :adsoyad WHERE id = :id",
            ["email" => $email, "telefon" => $telefon, "adsoyad" => $adsoyad, "id" => $uye]
        );
    }

    if ($elaveet) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
        exit;
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
        exit;
    }
}

if (isset($_POST['admin-elavesi'])) {
    $ad_soyad = guvenliGiris($_POST["ad_soyad"]);
    $eposta = guvenliGiris($_POST["eposta"]);
    // Şifre boşsa hata ver
    if (empty($_POST["sifre"])) {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta=Şifre-boş-ola-bilməz');
        exit;
    }

    $elaveet = guvenliSorgu(
        $db,
        "INSERT INTO admin SET 
        ad_soyad = :ad_soyad,
        eposta = :eposta,
        sifre = :sifre,
        modul = :modul,
        ilk_giris = :ilk_giris,
        ref = :ref,
        xidmet = :xidmet,
        statistika = :statistika,
        sualcavab = :sualcavab,
        sifaris = :sifaris,
        foto = :foto,
        video = :video,
        teklif = :teklif,
        elaqe = :elaqe,
        layihe = :layihe,
        rey = :rey,
        sehife = :sehife,
        kom = :kom,
        slider = :slider,
        menyu = :menyu,
        lan = :lan,
        admin = :admin,
        blog = :blog,
        sayt = :sayt,
        mehsul = :mehsul",
        [
            "ad_soyad" => $ad_soyad,
            "eposta" => $eposta,
            "sifre" => $sifre,
            "modul" => $_POST["modul"],
            "ilk_giris" => $tarih,
            "ref" => $_POST["ref"],
            "xidmet" => $_POST["xidmet"],
            "statistika" => $_POST["statistika"],
            "sualcavab" => $_POST["sualcavab"],
            "sifaris" => $_POST["sifaris"],
            "foto" => $_POST["foto"],
            "video" => $_POST["video"],
            "teklif" => $_POST["teklif"],
            "elaqe" => $_POST["elaqe"],
            "layihe" => $_POST["layihe"],
            "rey" => $_POST["rey"],
            "sehife" => $_POST["sehife"],
            "kom" => $_POST["kom"],
            "slider" => $_POST["slider"],
            "menyu" => $_POST["menyu"],
            "lan" => $_POST["lan"],
            "admin" => $_POST["admin"],
            "blog" => $_POST["blog"],
            "sayt" => $_POST["sayt"],
            "mehsul" => $_POST["mehsul"]
        ]
    );

    if ($elaveet) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
        exit;
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
        exit;
    }
}

if (isset($_POST["menyu-elavesi"])) {

    $elaveet = $db->prepare("insert into  menu set footer=:footer,sira=:sira,adi=:adi,url=:url,kategori=:kategori,acilir=:acilir,veziyyeti=:veziyyeti,sekme=:sekme,lan=:lan");
    $indi = $elaveet->execute(array("footer" => $_POST["footer"], "sekme" => $_POST["sekme"], "sira" => $sira_degeri, "adi" => $_POST["adi"], "url" => $_POST["url"], "acilir" => $_POST["acilir"], "veziyyeti" => $_POST["veziyyeti"], "kategori" => $_POST["kategori"], "lan" => $_POST["lan"]));
    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST["menu-yenille"])) {

    $elaveet = $db->prepare("update   menu set lan=:lan,footer=:footer,sekme=:sekme,sira=:sira,adi=:adi,url=:url,kategori=:kategori,acilir=:acilir,veziyyeti=:veziyyeti where id=:id");
    $indi = $elaveet->execute(array("lan" => $_POST["lan"], "footer" => $_POST["footer"], "sekme" => $_POST["sekme"], "sira" => $_POST["sira"], "adi" => $_POST["adi"], "url" => $_POST["url"], "acilir" => $_POST["acilir"], "veziyyeti" => $_POST["veziyyeti"], "kategori" => $_POST["kategori"], "id" => $_POST["id"]));
    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST['sube-ekle'])) {

    $elaveet = $db->prepare("insert into filallar set veziyyeti=:veziyyeti,lan=:lan,adi=:adi,telefon1=:telefon1,telefon2=:telefon2,adres=:adres,maps=:maps,email1=:email1,email2=:email2");
    $indi = $elaveet->execute(array("adi" => $_POST["adi"], "veziyyeti" => $_POST["veziyyeti"], "lan" => $_POST["lan"], "telefon1" => $_POST["telefon1"], "telefon2" => $_POST["telefon2"], "adres" => $_POST["adres"], "maps" => $_POST["maps"], "email1" => $_POST["email1"], "email2" => $_POST["email2"]));
    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST['sube-yenille'])) {

    $elaveet = $db->prepare("update filallar set veziyyeti=:veziyyeti,lan=:lan,adi=:adi,telefon1=:telefon1,telefon2=:telefon2,adres=:adres,maps=:maps,email1=:email1,email2=:email2 where id=:id");
    $indi = $elaveet->execute(array("adi" => $_POST["adi"], "veziyyeti" => $_POST["veziyyeti"], "lan" => $_POST["lan"], "telefon1" => $_POST["telefon1"], "telefon2" => $_POST["telefon2"], "adres" => $_POST["adres"], "maps" => $_POST["maps"], "email1" => $_POST["email1"], "email2" => $_POST["email2"], "id" => $_POST["id"]));
    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}




if (isset($_POST['shopier-ayar'])) {



    $elaveet = $db->prepare("update shopier set kullanici=:kullanici,sifre=:sifre where id=:id");

    $indi = $elaveet->execute(array("kullanici" => $_POST["kullanici"], "sifre" => $_POST["sifre"], "id" => 1));
    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['paymax-ayar'])) {



    $elaveet = $db->prepare("update paymax set api_user=:api_user,api_key=:api_key,api_magaza=:api_magaza,api_hash=:api_hash where id=:id");

    $indi = $elaveet->execute(array("api_user" => $_POST["api_user"], "api_key" => $_POST["api_key"], "api_magaza" => $_POST["api_magaza"], "api_hash" => $_POST["api_hash"], "id" => 1));
    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['netgsm-ayar'])) {



    $elaveet = $db->prepare("update netgsm set no=:no,gonderici=:gonderici,sifre=:sifre,mesaj=:mesaj,veziyyeti=:veziyyeti where id=:id");

    $indi = $elaveet->execute(array("no" => $_POST["no"], "gonderici" => $_POST["gonderici"], "sifre" => $_POST["sifre"], "veziyyeti" => $_POST["veziyyeti"], "mesaj" => $_POST["mesaj"], "id" => 1));
    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST["odeme-turu-sec"])) {

    $elaveet = $db->prepare("update odeme_secenek set tur=:tur where id=:id");
    $indi = $elaveet->execute(array("tur" => $_POST["tur"], "id" => 1));
    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST['modul-yenille'])) {

    $elaveet = $db->prepare("update icazeler set iyzico_durum=:iyzico_durum,netgsm_durum=:netgsm_durum,shopier_durum=:shopier_durum,paymax_durum=:paymax_durum,abone_durum=:abone_durum,modal_durum=:modal_durum,paket_veziyyeti=:paket_veziyyeti,banka_durum=:banka_durum,sube_durum=:sube_durum,katalog_durum=:katalog_durum,layihe_veziyyeti=:layihe_veziyyeti,layihe_kateqoriya_veziyyeti=:layihe_kateqoriya_veziyyeti,paytr_durum=:paytr_durum,banner_durum=:banner_durum,onecikan_durum=:onecikan_durum,destek_durum=:destek_durum,addim_veziyyeti=:addim_veziyyeti,musteri_durum=:musteri_durum,siparis_durum=:siparis_durum,en=:en,mehsul_veziyyeti=:mehsul_veziyyeti,kateqoriya_veziyyeti=:kateqoriya_veziyyeti,statistika_veziyyeti=:statistika_veziyyeti,referans_veziyyeti=:referans_veziyyeti,xidmet_veziyyeti=:xidmet_veziyyeti,sertifikat_veziyyeti=:sertifikat_veziyyeti,xeber_veziyyeti=:xeber_veziyyeti,sehife_veziyyeti=:sehife_veziyyeti,slayder_veziyyeti=:slayder_veziyyeti,sualcavab_veziyyeti=:sualcavab_veziyyeti,qalareya_veziyyeti=:qalareya_veziyyeti,video_durum=:video_durum,komanda_veziyyeti=:komanda_veziyyeti,rey_veziyyeti=:rey_veziyyeti,iletisim_durum=:iletisim_durum where id=:id");
    $indi = $elaveet->execute(array("iyzico_durum" => $_POST["iyzico_durum"], "netgsm_durum" => $_POST["netgsm_durum"], "shopier_durum" => $_POST["shopier_durum"], "paymax_durum" => $_POST["paymax_durum"], "abone_durum" => $_POST["abone_durum"], "modal_durum" => $_POST["modal_durum"], "paket_veziyyeti" => $_POST["paket_veziyyeti"], "banka_durum" => $_POST["banka_durum"], "sube_durum" => $_POST["sube_durum"], "katalog_durum" => $_POST["katalog_durum"], "layihe_veziyyeti" => $_POST["layihe_veziyyeti"], "layihe_kateqoriya_veziyyeti" => $_POST["layihe_kateqoriya_veziyyeti"], "paytr_durum" => $_POST["paytr_durum"], "banner_durum" => $_POST["banner_durum"], "onecikan_durum" => $_POST["onecikan_durum"], "addim_veziyyeti" => $_POST["addim_veziyyeti"], "destek_durum" => $_POST["destek_durum"], "musteri_durum" => $_POST["musteri_durum"], "siparis_durum" => $_POST["siparis_durum"], "en" => $_POST['en'], "mehsul_veziyyeti" => $_POST['mehsul_veziyyeti'], "kateqoriya_veziyyeti" => $_POST['kateqoriya_veziyyeti'], "statistika_veziyyeti" => $_POST['statistika_veziyyeti'], "referans_veziyyeti" => $_POST['referans_veziyyeti'], "xidmet_veziyyeti" => $_POST['xidmet_veziyyeti'], "sertifikat_veziyyeti" => $_POST['sertifikat_veziyyeti'], "xeber_veziyyeti" => $_POST['xeber_veziyyeti'], "sehife_veziyyeti" => $_POST['sehife_veziyyeti'], "slayder_veziyyeti" => $_POST['slayder_veziyyeti'], "sualcavab_veziyyeti" => $_POST['sualcavab_veziyyeti'], "qalareya_veziyyeti" => $_POST['qalareya_veziyyeti'], "video_durum" => $_POST['video_durum'], "komanda_veziyyeti" => $_POST['komanda_veziyyeti'], "rey_veziyyeti" => $_POST['rey_veziyyeti'], "iletisim_durum" => $_POST['iletisim_durum'], "id" => "1"));
    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST["destek-olustur"])) {

    $elaveet = $db->prepare("insert into destek set uye=:uye,konu=:konu,mesaj=:mesaj,tarih=:tarih");
    $hemen  = $elaveet->execute(array("uye" => $_POST["uye"], "konu" => $_POST["konu"], "mesaj" => $_POST["mesaj"], "tarih" => $tarih));
    if ($hemen) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST["destek-cevapla"])) {

    $elaveet = $db->prepare("update destek set cevap=:cevap,ctarih=:ctarih where id=:id");
    $hemen = $elaveet->execute(array("cevap" => $_POST["cevap"], "ctarih" => $tarih, "id" => $_POST["id"]));
    if ($hemen) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST["urun-yorum-yenille"])) {

    $elaveet = $db->prepare("update mehsul_rey set veziyyeti=:veziyyeti where id=:id");
    $indi = $elaveet->execute(array("veziyyeti" => $_POST["veziyyeti"], "id" => $_POST["id"]));
    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST["blog-yorum-yenille"])) {
    $yenille = $db->prepare("update blog_rey set yorum=:yorum, uye=:uye, email=:email, veziyyeti=:veziyyeti where id=:id");
    $indi = $yenille->execute(array(
        "yorum" => $_POST["yorum"],
        "uye" => $_POST["uye"],
        "email" => $_POST["email"],
        "veziyyeti" => $_POST["veziyyeti"],
        "id" => $_POST["id"]
    ));

    if ($indi) {
        header('location:../serh-listele.php?veziyyeti=Ugurlu');
    } else {
        header('location:../serh-listele.php?veziyyeti=Xeta');
    }
}



if (isset($_POST['abone-ol'])) {


    if ($_POST["email"] == '') {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    } else {
        $elaveet = $db->prepare("insert into abone set adi=:adi,email=:email,tarih=:tarih");
        $indi = $elaveet->execute(array("email" => $_POST['email'], "adi" => $_POST["adi"], "tarih" => $tarih));
        if ($indi) {
            header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
        } else {
            header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
        }
    }
}
if (isset($_POST["one-cikan"])) {

    $mehsullar = $_POST['mehsullar'];
    $mehsullar = implode(',', $mehsullar);
    $elaveet = $db->prepare("update onecikan set mehsullar=:mehsullar where id=:id");
    $indi = $elaveet->execute(array("mehsullar" => $mehsullar, "id" => 1));
    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST["sepet-sil"])) {

    $elaveet = $db->prepare("delete from sepet where id=:id");
    $indi = $elaveet->execute(array("id" => $_POST["id"]));

    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST["sepet-ekle"])) {

    $elaveet = $db->prepare("insert into sepet set urun_id=:urun_id,uye=:uye,fiyat=:fiyat,ip=:ip,adet=:adet");
    $indi = $elaveet->execute(array("urun_id" => $_POST["urun_id"], "uye" => $_POST["uye"], "fiyat" => $_POST["fiyat"], "ip" => $_POST["ip"], "adet" => $_POST["adet"]));

    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST["urun-yorum-ekle"])) {
    $elaveet = $db->prepare("insert into mehsul_rey set yorum=:yorum,uye=:uye,urun_id=:urun_id,tarih=:tarih,veziyyeti=:veziyyeti");
    $indi = $elaveet->execute(array("yorum" => $_POST["yorum"], "uye" => $_POST["uye"], "urun_id" => $_POST["urun_id"], "tarih" => $_POST["tarih"], "veziyyeti" => 1));

    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}






if (isset($_POST["blog-yorum-ekle"])) {
    $elaveet = $db->prepare("insert into blog_rey set yorum=:yorum, uye=:uye, urun_id=:urun_id, tarih=:tarih, veziyyeti=:veziyyeti, email=:email");
    $indi = $elaveet->execute(array(
        "yorum" => $_POST["yorum"],
        "uye" => $_POST["uye"],
        "urun_id" => $_POST["urun_id"],
        "tarih" => $tarih,
        "email" => $_POST["email"],
        "veziyyeti" => 1 // Yorum eklenirken varsayılan olarak pasif (1) yapılır
    ));

    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}



if (isset($_POST["daxil-ol"])) {


    ob_start();
    session_start();
    if ($sec = $db->query("select * from uyeler where email='{$_POST["email"]}' and sifre='{$_POST["sifre"]}'")->fetch(PDO::FETCH_ASSOC)) {

        $_SESSION["adsoyad"] = $sec["adsoyad"];
        $_SESSION["email"] = $sec["email"];
        $_SESSION["id"] = $sec["id"];
        $_SESSION["tarih"] = $sec["tarih"];
        $_SESSION["telefon"] = $sec["telefon"];

        header('location:../../hesabim?veziyyeti=Ugurlu');
    } else {

        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST["panel-giris"])) {
    ob_start();
    session_start();

    // Google reCAPTCHA doğrulamasını kontrol et
    if (isset($_POST['g-recaptcha-response']) && !empty($_POST['g-recaptcha-response'])) {
        $secret = '6Lcv7JArAAAAACKf5Z21CBy4tDhmUf3wZjF6gjH-';
        $url = 'https://www.google.com/recaptcha/api/siteverify';
        $data = [
            'secret' => $secret,
            'response' => $_POST['g-recaptcha-response']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $verifyResponse = curl_exec($ch);
        curl_close($ch);

        $responseData = json_decode($verifyResponse);

        if ($responseData->success) {
            // Kullanıcıyı eposta ile al
            $sorgu = $db->prepare("SELECT * FROM admin WHERE eposta = :eposta");
            $sorgu->execute(array("eposta" => $_POST["email"]));
            $sec = $sorgu->fetch(PDO::FETCH_ASSOC);

            if ($sec && password_verify($_POST["sifre"], $sec["sifre"])) {
                $_SESSION["ad_soyad"] = $sec["ad_soyad"];
                $_SESSION["eposta"] = $sec["eposta"];
                $_SESSION["id"] = $sec["id"];
                $_SESSION["tarih"] = $sec["tarih"];
                $_SESSION["telefon"] = $sec["telefon"];

                $yenille = $db->prepare("UPDATE admin SET son_giris=:son_giris, ip=:ip WHERE id=:id");
                $hemen = $yenille->execute([
                    "son_giris" => $tarih,
                    "ip" => $_SERVER["REMOTE_ADDR"],
                    "id" => $sec["id"]
                ]);

                header('location:../index.php?veziyyeti=Ugurlu');
                exit;
            } else {
                header('location:' . $_POST['link'] . '?veziyyeti=Xeta=İstfadeciadi-şifre-sehfdir');
                exit;
            }
        } else {
            header('location:' . $_POST['link'] . '?veziyyeti=Xeta=reCAPTCHA-doğrulamasını-kecmelisen');
            exit;
        }
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta=reCAPTCHAni-dogrula');
        exit;
    }
}

if (isset($_POST["kayit-ol"])) {

    if ($_POST['sifre'] == $_POST['sifre_dogrula']) {

        if ($esle = $db->query("select * from uyeler where email='{$_POST['email']}'")->fetch(PDO::FETCH_ASSOC)) {
            header('location:' . $_POST['link'] . '?veziyyeti=MailKayitli');
        } else {

            $elaveet = $db->prepare("insert into uyeler set adsoyad=:adsoyad,telefon=:telefon,email=:email,tarih=:tarih,sifre=:sifre");
            $indi = $elaveet->execute(array("adsoyad" => $_POST["adsoyad"], "telefon" => $_POST["telefon"], "email" => $_POST["email"], "tarih" => $tarih, "sifre" => $_POST["sifre"]));
            if ($indi) {
                header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
            }
        }
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['elaqe-formu'])) {
    // IP adresini al
    $ip = $_SERVER["REMOTE_ADDR"];

    // Mevcut tarih ve saati belirli bir formatta al
    // 'Y-m-d H:i:s' formatı 'YYYY-AA-GG SS:DD:SN' şeklinde çıktı verir
    $tarih = date('Y-m-d H:i:s'); 

    // `sahe1`, `sahe2`, `sahe3`, `sahe4` alanlarını `INSERT` sorgusuna ekledik
    $elaveet = $db->prepare("INSERT INTO elaqegelen SET adsoyad=:adsoyad, konu=:konu, telefon=:telefon, hizmet=:hizmet, mesaj=:mesaj, sahebir=:sahebir, saheiki=:saheiki, saheuc=:saheuc, sahedort=:sahedort, email=:email, tarih=:tarih, ip=:ip");
    
    // `execute` fonksiyonundaki diziyi güncelleyerek yeni alanları ekledik
    $hemen = $elaveet->execute(array(
        "adsoyad" => $_POST['adsoyad'],
        "konu" => $_POST['konu'],
        "telefon" => $_POST['telefon'],
        "hizmet" => $_POST['hizmet'],
        "mesaj" => $_POST['mesaj'],
        "sahebir" => $_POST['sahebir'],
        "saheiki" => $_POST['saheiki'],
        "saheuc" => $_POST['saheuc'],
        "sahedort" => $_POST['sahedort'],
        "tarih" => $tarih,
        "email" => $_POST['email'],
        "ip" => $ip // IP adresini buraya ekliyoruz
    ));

    if ($hemen) {
        include '../../class.phpmailer.php';
        $mail = new PHPMailer();
        $mail->IsSMTP();
        $mail->Host = $smtp['site_mail_host'];
        $mail->Port = $smtp['site_mail_port'];
        $mail->SMTPAuth = true;
        $mail->SMTPSecure = 'ssl';
        $mail->Username = $smtp['site_mail'];
        $mail->Password = $smtp['site_mail_sifre'];
        $mail->SetFrom($mail->Username, "Saytdan gələn forum gmailı");
        $mail->AddAddress($smtp['gonderen_mail'], "Saytdan gələn forum gmailı");
        $mail->CharSet = 'UTF-8';
        $mail->Subject = "Saytdan gələn forum gmailı";
        
        // E-posta içeriğini güncelleyerek yeni alanları ekledik
        $mail->MsgHTML('Adı:' . $_POST["adsoyad"] . '<br/>
            Gmailı:' . $_POST["email"] . '<br/>
            Telefonu:' . $_POST["telefon"] . '<br/>
            Xidməti:' . $_POST["hizmet"] . '<br/>
            Mövzusu:' . $_POST["konu"] . '<br/>
            Mesajı:' . $_POST["mesaj"] . '<br/>
            Sahə Bir:' . $_POST["sahebir"] . '<br/>
            Sahə iki:' . $_POST["saheiki"] . '<br/>
            Sahə üç:' . $_POST["saheuc"] . '<br/>
            Sahə dört:' . $_POST["sahedort"] . '<br/>
            IP Adresi:' . $ip . '<br/>');
            
        if ($mail->Send()) {
            $db =
                ' <br>   &nbsp;      &nbsp;    &nbsp;
            <font style="color:#24b802; font-size:16px;">  Mesajınız başarıyla gönderildi.    </font>
            <br><br>';
        } else {
            $db = '<br> &nbsp; &nbsp;

            <font style="color:#FF0004; font-size:16px;">  Mesaj gönderirken bir Xeta oluştu ve girmiş olduğunuz bilgiler alınamadı. </font>

            <br><br>' . $mail->ErrorInfo;
        }

        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
        exit;
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
        exit;
    }
}



if (isset($_POST["randevu-olustur"])) {

    $elaveet = $db->prepare("insert into sifarisler set fiyat=:fiyat,urun=:urun,tarih=:tarih,telefon=:telefon,adsoyad=:adsoyad,eposta=:eposta,adres=:adres,etarih=:etarih");
    $indi = $elaveet->execute(array("fiyat" => $_POST["fiyat"], "urun" => $_POST["urun"], "tarih" => $_POST["dates"], "telefon" => $_POST["telefon"], "adsoyad" => $_POST["adsoyad"], "eposta" => $_POST["eposta"], "adres" => $_POST["adres"], "etarih" => $tarih));

    if ($indi) {

        $urun = $db->query("select * from mehsullar where id='{$_POST["urun"]}'")->fetch(PDO::FETCH_ASSOC);
        include '../../class.phpmailer.php';
        $mail = new PHPMailer();
        $mail->IsSMTP();
        $mail->Host = $site_mail_host;
        $mail->Port = $site_mail_port;
        $mail->SMTPAuth = true;
        $mail->SMTPSecure = 'ssl';
        $mail->Username = $site_mail;
        $mail->Password = $site_mail_sifre;
        $mail->SetFrom($mail->Username, "Yeni Randevu Bildirimi");
        $mail->AddAddress($gonderen_mail, "Yeni Randevu Bildirimi");
        $mail->CharSet = 'UTF-8';
        $mail->Subject = "Yeni Form Bildirimi";
        $mail->MsgHTML('İsim:' . $_POST["adsoyad"] . '<br/>
			E-mail:' . $_POST["email"] . '<br/>
			Telefon:' . $_POST["telefon"] . '<br/>
			Fiyat:' . $_POST["fiyat"] . '<br/>
			Ürün:' . $urun["adi"] . '<br/>
			Tarih:' . $_POST["tarih"] . '<br/>
			Adres:' . $_POST["adres"] . '<br/>');
        if ($mail->Send()) {
            $db =

                ' <br>  &nbsp;  &nbsp;&nbsp;  
			<font style="color:#24b802; font-size:16px;">  Mesajınız başarıyla gönderildi.   </font>
			<br><br>';
        } else {

            $db = '<br> &nbsp; &nbsp; 

			<font style="color:#FF0004; font-size:16px;">  Mesaj gönderirken bir Xeta oluştu ve girmiş olduğunuz bilgiler alınamadı. </font> 

			<br><br>' . $mail->ErrorInfo;
        }

        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['genel-ayarlar'])) {

    $seo = seflink($_POST['site_title']);

    $tur = "tenzimlemeler";

    $id = $_POST['id'];

    $klasor = "../../imgupload/";

    // resim alanı için
    $resim_tmp = $_FILES['logo']['tmp_name'];

    if (empty($resim_tmp)) {
        // Eğer yeni resim yüklenmediyse, mevcut resim adını veritabanından çek
        $tenzimleme_qeydi = $db->query("SELECT * FROM tenzimlemeler WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
        $logo = $tenzimleme_qeydi['logo'];
    } else {
        $file_type = $_FILES["logo"]["type"];
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM tenzimlemeler WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
            // Eski resmi silmeden önce var olup olmadığını kontrol et
            if ($tenzimleme_qeydi['logo'] != "no-img" && file_exists($klasor . $tenzimleme_qeydi['logo'])) {
                unlink($klasor . $tenzimleme_qeydi['logo']);
            }

            $random = rand(0, 999);
            $file_extension = pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION);
            // Geçici dosya adı oluşturma, $seo değişkenini kullanabiliriz
            $temp_file_name = $random . "-" . $seo . "." . $file_extension;

            // Yüklenen dosyayı geçici olarak kaydet
            if (move_uploaded_file($_FILES['logo']['tmp_name'], $klasor . "/" . $temp_file_name)) {
                $source_file = $klasor . "/" . $temp_file_name;

                // Resim tipine göre farklı fonksiyonlar kullanarak resmi yükle
                $image = false; // Başlangıçta false olarak ayarla
                if ($file_type == "image/jpeg" || $file_type == "image/jpg") {
                    $image = imagecreatefromjpeg($source_file);
                } elseif ($file_type == "image/png") {
                    $image = imagecreatefrompng($source_file);
                    // PNG transparanlığını korumak için
                    imagepalettetotruecolor($image);
                    imagealphablending($image, true);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($source_file);
                }

                if ($image) {
                    $output_file = $klasor . $random . '-' . $seo . '.webp';
                    $logo = $random . '-' . $seo . '.webp'; // Veritabanına kaydedilecek dosya adı

                    // Resmi WebP formatına dönüştür ve kaydet
                    imagewebp($image, $output_file, 80); // Kaliteyi 80 olarak ayarladım

                    imagedestroy($image); // Orjinal image objesini temizle

                    // Geçici orijinal dosyayı sil
                    unlink($source_file);
                } else {
                    $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Desteklenmeyen resim formatı veya resim yüklenemedi.
                    </div>';
                    $logo = $tenzimleme_qeydi['logo']; // Hata veziyyetinda eski resmi koru
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya sunucuya taşınamadı.
                    </div>';
                $logo = $tenzimleme_qeydi['logo']; // Hata durumunda eski resmi koru
            }
        } else {
            $bilgi = '<div class="alert alert-error">
            <button class="close" data-dismiss="alert">×</button>
            <strong>Hata !</strong> Lütfen uygun formatta bir resim dosyası seçiniz ( .jpg - .gif - .png ).
            </div>';
            $logo = $tenzimleme_qeydi['logo']; // Hata durumunda eski resmi koru
        }
    }


    // resim2 alanı için
    $resim_tmp2 = $_FILES['footer_logo']['tmp_name'];

    if (empty($resim_tmp2)) {
        $tenzimleme_qeydi = $db->query("SELECT * FROM tenzimlemeler WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
        $footer_logo = $tenzimleme_qeydi['footer_logo'];
    } else {
        $file_type2 = $_FILES["footer_logo"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM tenzimlemeler WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['footer_logo'] != "no-img" && file_exists($klasor . $tenzimleme_qeydi['footer_logo'])) {
                unlink($klasor . $tenzimleme_qeydi['footer_logo']);
            }

            $random = rand(0, 999);
            $file_extension2 = pathinfo($_FILES['footer_logo']['name'], PATHINFO_EXTENSION);
            $temp_file_name2 = $random . "-" . $seo . "_2." . $file_extension2;

            if (move_uploaded_file($_FILES['footer_logo']['tmp_name'], $klasor . "/" . $temp_file_name2)) {
                $source_file2 = $klasor . "/" . $temp_file_name2;

                $image2 = false;
                if ($file_type2 == "image/jpeg" || $file_type2 == "image/jpg") {
                    $image2 = imagecreatefromjpeg($source_file2);
                } elseif ($file_type2 == "image/png") {
                    $image2 = imagecreatefrompng($source_file2);
                    imagepalettetotruecolor($image2);
                    imagealphablending($image2, true);
                    imagesavealpha($image2, true);
                } elseif ($file_type2 == "image/gif") {
                    $image2 = imagecreatefromgif($source_file2);
                }

                if ($image2) {
                    $output_file2 = $klasor . $random . '-' . $seo . '_2.webp';
                    $footer_logo = $random . '-' . $seo . '_2.webp';
                    imagewebp($image2, $output_file2, 80);
                    imagedestroy($image2);
                    unlink($source_file2);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Desteklenmeyen resim formatı veya resim yüklenemedi.
                        </div>';
                    $footer_logo = $tenzimleme_qeydi['footer_logo'];
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya sunucuya taşınamadı.
                    </div>';
                $footer_logo = $tenzimleme_qeydi['footer_logo'];
            }
        } else {
            $bilgi = '<div class="alert alert-error">
            <button class="close" data-dismiss="alert">×</button>
            <strong>Hata !</strong> Lütfen uygun formatta bir resim dosyası seçiniz ( .jpg - .gif - .png ).
            </div>';
            $footer_logo = $tenzimleme_qeydi['footer_logo'];
        }
    }


    // resim3 alanı için
    $resim_tmp3 = $_FILES['favicon']['tmp_name'];

    if (empty($resim_tmp3)) {
        $tenzimleme_qeydi = $db->query("SELECT * FROM tenzimlemeler WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
        $favicon = $tenzimleme_qeydi['favicon'];
    } else {
        $file_type3 = $_FILES["favicon"]["type"];
        if ($file_type3 == "image/gif" || $file_type3 == "image/png" || $file_type3 == "image/jpg" || $file_type3 == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM tenzimlemeler WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['favicon'] != "no-img" && file_exists($klasor . $tenzimleme_qeydi['favicon'])) {
                unlink($klasor . $tenzimleme_qeydi['favicon']);
            }

            $random = rand(0, 999);
            $file_extension3 = pathinfo($_FILES['favicon']['name'], PATHINFO_EXTENSION);
            $temp_file_name3 = $random . "-" . $seo . "_3." . $file_extension3;

            if (move_uploaded_file($_FILES['favicon']['tmp_name'], $klasor . "/" . $temp_file_name3)) {
                $source_file3 = $klasor . "/" . $temp_file_name3;

                $image3 = false;
                if ($file_type3 == "image/jpeg" || $file_type3 == "image/jpg") {
                    $image3 = imagecreatefromjpeg($source_file3);
                } elseif ($file_type3 == "image/png") {
                    $image3 = imagecreatefrompng($source_file3);
                    imagepalettetotruecolor($image3);
                    imagealphablending($image3, true);
                    imagesavealpha($image3, true);
                } elseif ($file_type3 == "image/gif") {
                    $image3 = imagecreatefromgif($source_file3);
                }

                if ($image3) {
                    $output_file3 = $klasor . $random . '-' . $seo . '_3.webp';
                    $favicon = $random . '-' . $seo . '_3.webp';
                    imagewebp($image3, $output_file3, 80);
                    imagedestroy($image3);
                    unlink($source_file3);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Desteklenmeyen resim formatı veya resim yüklenemedi.
                        </div>';
                    $favicon = $tenzimleme_qeydi['favicon'];
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya sunucuya taşınamadı.
                    </div>';
                $favicon = $tenzimleme_qeydi['favicon'];
            }
        } else {
            $bilgi = '<div class="alert alert-error">
            <button class="close" data-dismiss="alert">×</button>
            <strong>Hata !</strong> Lütfen uygun formatta bir resim dosyası seçiniz ( .jpg - .gif - .png ).
            </div>';
            $favicon = $tenzimleme_qeydi['favicon'];
        }
    }


    $elaveet  = $db->prepare("update tenzimlemeler set p_renk1=:p_renk1,p_renk2=:p_renk2,header=:header,footer=:footer,renk2=:renk2,renk=:renk,footer_copyright=:footer_copyright,site_title=:site_title,site_description=:site_description,site_author=:site_author,site_meta=:site_meta,site_keyword=:site_keyword,logo=:logo,favicon=:favicon,footer_logo=:footer_logo where id=:id");

    $indi = $elaveet->execute(array("p_renk2" => $_POST["p_renk2"], "p_renk1" => $_POST["p_renk1"], "footer" => $_POST["footer"], "header" => $_POST["header"], "renk2" => $_POST['renk2'], "renk" => $_POST['renk'], "footer_copyright" => $_POST['footer_copyright'], "site_title" => $_POST['site_title'], "site_meta" => $_POST['site_meta'], "site_description" => $_POST['site_description'], "site_author" => $_POST['site_author'], "site_keyword" => $_POST['site_keyword'], "logo" => $logo, "footer_logo" => $footer_logo, "favicon" => $favicon, "id" => 1));

    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST["genel-ayarlar1"])) {
    $elaveet  = $db->prepare("update panel set p_renk1=:p_renk1,p_renk2=:p_renk2 where id=:id");

    $indi = $elaveet->execute(array("p_renk2" => $_POST["p_renk2"], "p_renk1" => $_POST["p_renk1"], "id" => 1));

    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['kateqoriya-elavesi'])) {

    $seo = seflink($_POST['adi']);

    $tur = "mehsul_kateqoriya";

    $klasorbanka = "../../imgupload/";
    $tarih = date('Y-m-d H:i:s');
    
    $sira_degeri = 1;
    if (isset($_POST['sira']) && $_POST['sira'] !== '') {
        $sira_degeri = intval($_POST['sira']);
    } else {
        // Formdan sıra gelmediyse, veritabanındaki en yüksek değeri bul
        $son_sira_sorgu = $db->query("SELECT MAX(sira) AS max_sira FROM mehsullar");
        $sonuc = $son_sira_sorgu->fetch(PDO::FETCH_ASSOC);
        if ($sonuc && isset($sonuc['max_sira'])) {
            $sira_degeri = $sonuc['max_sira'] + 1;
        }
    }

    $resim_tmpbanka = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpbanka)) {
        $resim = "no-img";
    } else {

        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {
            $random = rand(0, 9999999);

            $resim1 = $random . "-" . $seo . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasorbanka . "/" . $resim1);

            $file = "../../imgupload/" . $resim1;
            $image = imagecreatefromstring(file_get_contents($file));
            ob_start();
            imagejpeg($image, NULL, 100);
            $cont = ob_get_contents();
            ob_end_clean();
            $randomm = rand(0, 965465465465456);
            imagedestroy($image);
            $content = imagecreatefromstring($cont);
            $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
            $resim = $random . '-' . $seo . '.webp';
            imagewebp($content, $output);
            imagedestroy($content);
            unlink('../../imgupload/' . $resim1);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }


    $indi = $db->prepare("insert into mehsul_kateqoriya set title=:title,description=:description,etiket=:etiket,lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,aciklama=:aciklama,seo=:seo,tur=:tur,eklenme_tarihi=:eklenme_tarihi");
    $elaveet = $indi->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "adi" => $_POST['adi'], "lan" => $_POST["lan"], "sira" => $sira_degeri, "resim" => $resim, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "veziyyeti" => $_POST['veziyyeti'], "eklenme_tarihi" => $tarih));
    if ($elaveet) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['kategori-yenille'])) {

    $seo = seflink($_POST['adi']);

    $tur = "mehsul_kateqoriya";

    $id = $_POST['id'];
    $klasord = "../../imgupload/";
    $resim_tmpd = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpd)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM mehsul_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {

        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM mehsul_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img") {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 999);

            $resim1 = $random . "-" . $seo . $_FILES['resim'];

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $resim1);
            $file = "../../imgupload/" . $resim1;
            $image = imagecreatefromstring(file_get_contents($file));
            ob_start();
            imagejpeg($image, NULL, 100);
            $cont = ob_get_contents();
            ob_end_clean();

            imagedestroy($image);
            $content = imagecreatefromstring($cont);
            $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
            $resim = $random . '-' . $seo . '.webp';
            imagewebp($content, $output);
            imagedestroy($content);
            unlink('../../imgupload/' . $resim1);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }







    $indi1 = $db->prepare("update mehsul_kateqoriya set title=:title,description=:description,etiket=:etiket,lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,guncelleme_tarihi=:guncelleme_tarihi where id=:id");
    $elaveet1 = $indi1->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "adi" => $_POST['adi'], "lan" => $_POST["lan"], "sira" => $_POST['sira'], "resim" => $resim, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "onaciklama" => $onaciklama, "veziyyeti" => $_POST['veziyyeti'], "guncelleme_tarihi" => $tarih, "id" => $id));
    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['komanda-kateqoriya-elavesi'])) {

    $seo = seflink($_POST['adi']);


    $tur = "ekip_kategori";


    $klasorbanka = "../../sekiler/";
    $resim_tmpbanka = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpbanka)) {
        $resim = "no-img";
    } else {

        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {
            $random = rand(0, 9999999);

            $resim1 = $random . "-" . $seo . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasorbanka . "/" . $resim1);

            $file = "../../sekiler/" . $resim1;
            $image = imagecreatefromstring(file_get_contents($file));
            ob_start();
            imagejpeg($image, NULL, 100);
            $cont = ob_get_contents();
            ob_end_clean();
            $randomm = rand(0, 965465465465456);
            imagedestroy($image);
            $content = imagecreatefromstring($cont);
            $output = '../../sekiler/' . $random . '-' . $seo . '.webp';
            $resim = $random . '-' . $seo . '.webp';
            imagewebp($content, $output);
            imagedestroy($content);
            unlink('../../sekiler/' . $resim1);
        } else {
            $bilgi = '<div class="alert alert-error">
										<button class="close" data-dismiss="alert">×</button>
										<strong>Xəta !</strong> Zəhmət olmasa  uyğun formatda bir şəkil faylı seçin ( .jpg - .gif - .png ).
			</div>';
        }
    }


    $indi = $db->prepare("insert into ekip_kategori set title=:title,description=:description,etiket=:etiket,lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,aciklama=:aciklama,seo=:seo,tur=:tur,eklenme_tarihi=:eklenme_tarihi");
    $elaveet = $indi->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "adi" => $_POST['adi'], "lan" => $_POST["lan"], "sira" => $_POST['sira'], "resim" => $resim, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "veziyyeti" => $_POST['veziyyeti'], "eklenme_tarihi" => $tarih));
    if ($elaveet) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['ekip-kategori-yenille'])) {


    $seo = seflink($_POST['adi']);

    $tur = "ekip_kategori";



    $id = $_POST['id'];
    $klasord = "../../sekiler/";
    $resim_tmpd = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpd)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM mehsul_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {

        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM mehsul_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img") {
                unlink("../../sekiler/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 999);

            $resim1 = $random . "-" . $seo . $_FILES['resim'];

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $resim1);
            $file = "../../sekiler/" . $resim1;
            $image = imagecreatefromstring(file_get_contents($file));
            ob_start();
            imagejpeg($image, NULL, 100);
            $cont = ob_get_contents();
            ob_end_clean();

            imagedestroy($image);
            $content = imagecreatefromstring($cont);
            $output = '../../sekiler/' . $random . '-' . $seo . '.webp';
            $resim = $random . '-' . $seo . '.webp';
            imagewebp($content, $output);
            imagedestroy($content);
            unlink('../../sekiler/' . $resim1);
        } else {
            $bilgi = '<div class="alert alert-error">
										<button class="close" data-dismiss="alert">×</button>
										<strong>Xəta !</strong> Zəhmət olmasa  uyğun formatda bir şəkil faylı seçin ( .jpg - .gif - .png ).
			</div>';
        }
    }







    $indi1 = $db->prepare("update ekip_kategori set title=:title,description=:description,etiket=:etiket,lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,guncelleme_tarihi=:guncelleme_tarihi where id=:id");
    $elaveet1 = $indi1->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "adi" => $_POST['adi'], "lan" => $_POST["lan"], "sira" => $_POST['sira'], "resim" => $resim, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "onaciklama" => $onaciklama, "veziyyeti" => $_POST['veziyyeti'], "guncelleme_tarihi" => $tarih, "id" => $id));
    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['layihe-kateqoriya-elavesi'])) {

    $seo = seflink($_POST['adi']);


    $tur = "layihe_kateqoriya";


    $klasorbanka = "../../imgupload/"; // Resimlerin yükleneceği klasör

    // --- BİRİNCİ RESİM İŞLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        $resim = "no-img";
    } else {
        $file_type = $_FILES["resim"]["type"];
        // Desteklenen formatları kontrol edin
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            // Geçici dosyayı sunucuya taşı
            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasorbanka . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                // Resim tipine göre farklı imagecreatefrom fonksiyonunu kullanın
                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    // PNG için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    // GIF için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else { // JPG veya JPEG ise
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    // WebP dönüştürme kalitesi: 0 (en düşük) - 100 (en yüksek). Genellikle 80-90 arası iyidir.
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path); // Geçici orijinal dosyayı silin
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM İŞLEME SONU ---

    // --- İKİNCİ RESİM İŞLEME BAŞLANGICI (resim2) ---
    if (empty($_FILES['resim2']['tmp_name'])) {
        $resim2 = "no-img";
    } else {
        $file_type2 = $_FILES["resim2"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {

            $random2 = rand(0, 9999999);
            $original_file_extension2 = pathinfo($_FILES['resim2']['name'], PATHINFO_EXTENSION);
            $temp_filename2 = $random2 . "-" . $seo . "." . $original_file_extension2;

            if (move_uploaded_file($_FILES['resim2']['tmp_name'], $klasorbanka . "/" . $temp_filename2)) {
                $file_path2 = "../../imgupload/" . $temp_filename2;
                $image2 = null;

                if ($file_type2 == "image/png") {
                    $image2 = imagecreatefrompng($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } elseif ($file_type2 == "image/gif") {
                    $image2 = imagecreatefromgif($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } else {
                    $image2 = imagecreatefromjpeg($file_path2);
                }

                if ($image2) {
                    $output2 = '../../imgupload/' . $random2 . '-' . $seo . '.webp';
                    $resim2 = $random2 . '-' . $seo . '.webp';
                    imagewebp($image2, $output2, 85);
                    imagedestroy($image2);
                    unlink($file_path2);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkinci resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkinci dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKİNCİ RESİM İŞLEME SONU ---

    // --- İKON İŞLEME BAŞLANGICI (icon) ---
    // İkon yükleme alanı boşsa "no-img" ata
    if (empty($_FILES['icon']['tmp_name'])) {
        $icon = "no-img";
    } else {
        $file_type_icon = $_FILES["icon"]["type"];
        if ($file_type_icon == "image/gif" || $file_type_icon == "image/png" || $file_type_icon == "image/jpg" || $file_type_icon == "image/jpeg") {

            $random_icon = rand(0, 9999999);
            $original_file_extension_icon = pathinfo($_FILES['icon']['name'], PATHINFO_EXTENSION);
            $temp_filename_icon = $random_icon . "-" . $seo . "-icon." . $original_file_extension_icon; // İkon için farklı bir adlandırma

            if (move_uploaded_file($_FILES['icon']['tmp_name'], $klasorbanka . "/" . $temp_filename_icon)) {
                $file_path_icon = "../../imgupload/" . $temp_filename_icon;
                $image_icon = null;

                if ($file_type_icon == "image/png") {
                    $image_icon = imagecreatefrompng($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } elseif ($file_type_icon == "image/gif") {
                    $image_icon = imagecreatefromgif($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } else {
                    $image_icon = imagecreatefromjpeg($file_path_icon);
                }

                if ($image_icon) {
                    $output_icon = '../../imgupload/' . $random_icon . '-' . $seo . '-icon.webp'; // WebP formatında kaydet
                    $icon = $random_icon . '-' . $seo . '-icon.webp'; // Veritabanına kaydedilecek isim
                    imagewebp($image_icon, $output_icon, 85);
                    imagedestroy($image_icon);
                    unlink($file_path_icon); // Geçici dosyayı sil
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkon işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkon dosyası yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> İkon için lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKON İŞLEME SONU ---


    $indi = $db->prepare("insert into layihe_kateqoriya set title=:title,description=:description,etiket=:etiket,aciklama2=:aciklama2,resim2=:resim2,lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,aciklama=:aciklama,seo=:seo,tur=:tur,eklenme_tarihi=:eklenme_tarihi");
    $elaveet = $indi->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "adi" => $_POST['adi'], "lan" => $_POST["lan"], "aciklama2" => $_POST["aciklama2"], "resim2" => $resim2, "sira" => $_POST['sira'], "resim" => $resim, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "veziyyeti" => $_POST['veziyyeti'], "eklenme_tarihi" => $tarih));
    if ($elaveet) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['layihe-kateqoriya-yenile'])) {

    $seo = seflink($_POST['adi']);

    $tur = "layihe_kateqoriya";


    $id = $_POST['id'];
    $klasord = "../../imgupload/";
    // --- BİRİNCİ RESİM GÜNCELLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        // Resim yüklenmediyse mevcut resmi koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM layihe_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        $file_type = $_FILES["resim"]["type"];
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            // Eski resmi sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM layihe_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['resim'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else {
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM GÜNCELLEME SONU ---

    // --- İKİNCİ RESİM GÜNCELLEME BAŞLANGICI (resim2) ---
    if (empty($_FILES['resim2']['tmp_name'])) {
        // Resim yüklenmediyse mevcut resmi koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM layihe_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim2 = $tenzimleme_qeydi['resim2'];
    } else {
        $file_type2 = $_FILES["resim2"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {

            // Eski resmi sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM layihe_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim2'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['resim2'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim2']);
            }

            $random2 = rand(0, 9999999);
            $original_file_extension2 = pathinfo($_FILES['resim2']['name'], PATHINFO_EXTENSION);
            $temp_filename2 = $random2 . "-" . $seo . "." . $original_file_extension2;

            if (move_uploaded_file($_FILES['resim2']['tmp_name'], $klasord . "/" . $temp_filename2)) {
                $file_path2 = "../../imgupload/" . $temp_filename2;
                $image2 = null;

                if ($file_type2 == "image/png") {
                    $image2 = imagecreatefrompng($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } elseif ($file_type2 == "image/gif") {
                    $image2 = imagecreatefromgif($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } else {
                    $image2 = imagecreatefromjpeg($file_path2);
                }

                if ($image2) {
                    $output2 = '../../imgupload/' . $random2 . '-' . $seo . '.webp';
                    $resim2 = $random2 . '-' . $seo . '.webp';
                    imagewebp($image2, $output2, 85);
                    imagedestroy($image2);
                    unlink($file_path2);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkinci resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkinci dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKİNCİ RESİM GÜNCELLEME SONU ---

    // --- İKON GÜNCELLEME BAŞLANGICI (icon) ---
    // Eğer 'icon' adında bir dosya yüklemesi varsa işlem yap
    if (empty($_FILES['icon']['tmp_name'])) {
        // İkon yüklenmediyse mevcut ikonu koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM layihe_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $icon = $tenzimleme_qeydi['icon'];
    } else {
        $file_type_icon = $_FILES["icon"]["type"];
        if ($file_type_icon == "image/gif" || $file_type_icon == "image/png" || $file_type_icon == "image/jpg" || $file_type_icon == "image/jpeg") {

            // Eski ikonu sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM layihe_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['icon'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['icon'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['icon']);
            }

            $random_icon = rand(0, 9999999);
            $original_file_extension_icon = pathinfo($_FILES['icon']['name'], PATHINFO_EXTENSION);
            $temp_filename_icon = $random_icon . "-" . $seo . "-icon." . $original_file_extension_icon; // İkon için farklı bir adlandırma

            if (move_uploaded_file($_FILES['icon']['tmp_name'], $klasord . "/" . $temp_filename_icon)) {
                $file_path_icon = "../../imgupload/" . $temp_filename_icon;
                $image_icon = null;

                if ($file_type_icon == "image/png") {
                    $image_icon = imagecreatefrompng($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } elseif ($file_type_icon == "image/gif") {
                    $image_icon = imagecreatefromgif($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } else {
                    $image_icon = imagecreatefromjpeg($file_path_icon);
                }

                if ($image_icon) {
                    $output_icon = '../../imgupload/' . $random_icon . '-' . $seo . '-icon.webp'; // WebP formatında kaydet
                    $icon = $random_icon . '-' . $seo . '-icon.webp'; // Veritabanına kaydedilecek isim
                    imagewebp($image_icon, $output_icon, 85);
                    imagedestroy($image_icon);
                    unlink($file_path_icon); // Geçici dosyayı sil
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkon işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkon dosyası yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> İkon için lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKON GÜNCELLEME SONU ---







    $indi1 = $db->prepare("update layihe_kateqoriya set title=:title,description=:description,etiket=:etiket,aciklama2=:aciklama2,resim2=:resim2,lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,guncelleme_tarihi=:guncelleme_tarihi where id=:id");
    $elaveet1 = $indi1->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "adi" => $_POST['adi'], "lan" => $_POST["lan"], "resim2" => $resim2, "aciklama2" => $_POST["aciklama2"], "sira" => $_POST['sira'], "resim" => $resim, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "onaciklama" => $onaciklama, "veziyyeti" => $_POST['veziyyeti'], "guncelleme_tarihi" => $tarih, "id" => $id));
    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['xidmet-kateqoriya-elavesi'])) {

    $seo = seflink($_POST['adi']);


    $tur = "xidmet_kateqoriya";


    $klasorbanka = "../../imgupload/";
    $resim_tmpbanka = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpbanka)) {
        $resim = "no-img";
    } else {

        $random = rand(0, 9999999);

        $resim = $random . "-" . $seo . "." . substr($_FILES['resim']['name'], -3);

        move_uploaded_file($_FILES['resim']['tmp_name'], $klasorbanka . "/" . $resim);
    }


    $klasorbanka = "../../imgupload/";
    $resim_tmpbanka2 = $_FILES['resim2']['tmp_name'];
    if (empty($resim_tmpbanka2)) {
        $resim2 = "no-img";
    } else {

        $random = rand(0, 9999999);

        $resim2 = $random . "-" . $seo . "." . substr($_FILES['resim2']['name'], -3);

        move_uploaded_file($_FILES['resim']['tmp_name'], $klasorbanka . "/" . $resim);
    }


    $indi = $db->prepare("insert into xidmet_kateqoriya set title=:title,description=:description,etiket=:etiket,aciklama2=:aciklama2,resim2=:resim2,lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,aciklama=:aciklama,seo=:seo,tur=:tur,eklenme_tarihi=:eklenme_tarihi");
    $elaveet = $indi->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "adi" => $_POST['adi'], "lan" => $_POST["lan"], "aciklama2" => $_POST["aciklama2"], "resim2" => $resim2, "sira" => $_POST['sira'], "resim" => $resim, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "veziyyeti" => $_POST['veziyyeti'], "eklenme_tarihi" => $tarih));
    if ($elaveet) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['xidmet-kateqoriya-yenile'])) {

    $seo = seflink($_POST['adi']);

    $tur = "xidmet_kateqoriya";



    $id = $_POST['id'];
    $klasord = "../../imgupload/";
    $resim_tmpd = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpd)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM xidmet_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {



        $tenzimleme_qeydi = $db->query("SELECT * FROM xidmet_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        if ($tenzimleme_qeydi['resim'] != "no-img") {
            unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
        }

        $random = rand(0, 999);

        $resim = $random . "-" . $seo . "." . substr($_FILES['resim']['name'], -3);
        move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $resim);
    }

    $klasord = "../../imgupload/";
    $resim_tmpd2 = $_FILES['resim2']['tmp_name'];
    if (empty($resim_tmpd2)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM xidmet_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim2 = $tenzimleme_qeydi['resim2'];
    } else {



        $tenzimleme_qeydi = $db->query("SELECT * FROM xidmet_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        if ($tenzimleme_qeydi['resim2'] != "no-img") {
            unlink("../../imgupload/" . $tenzimleme_qeydi['resim2']);
        }

        $random = rand(0, 999);

        $resim2 = $random . "-" . $seo . "." . substr($_FILES['resim2']['name'], -3);
        move_uploaded_file($_FILES['resim2']['tmp_name'], $klasord . "/" . $resim2);
    }







    $indi1 = $db->prepare("update xidmet_kateqoriya set title=:title,description=:description,etiket=:etiket,aciklama2=:aciklama2,resim2=:resim2,lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,guncelleme_tarihi=:guncelleme_tarihi where id=:id");
    $elaveet1 = $indi1->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "adi" => $_POST['adi'], "lan" => $_POST["lan"], "resim2" => $resim2, "aciklama2" => $_POST["aciklama2"], "sira" => $_POST['sira'], "resim" => $resim, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "onaciklama" => $onaciklama, "veziyyeti" => $_POST['veziyyeti'], "guncelleme_tarihi" => $tarih, "id" => $id));
    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['layihe-kateqoriya-elavesi'])) {


    $seo = seflink($_POST['adi']);


    $tur = "layihe_kateqoriya";


    $klasorbanka = "../../sekiler/";
    $resim_tmpbanka = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpbanka)) {
        $resim = "no-img";
    } else {

        $random = rand(0, 9999999);

        $resim = $random . "-" . $seo . "." . substr($_FILES['resim']['name'], -3);

        move_uploaded_file($_FILES['resim']['tmp_name'], $klasorbanka . "/" . $resim);
    }


    $klasorbanka = "../../sekiler/";
    $resim_tmpbanka2 = $_FILES['resim2']['tmp_name'];
    if (empty($resim_tmpbanka2)) {
        $resim2 = "no-img";
    } else {

        $random = rand(0, 9999999);

        $resim2 = $random . "-" . $seo . "." . substr($_FILES['resim2']['name'], -3);

        move_uploaded_file($_FILES['resim']['tmp_name'], $klasorbanka . "/" . $resim);
    }


    $indi = $db->prepare("insert into layihe_kateqoriya set title=:title,description=:description,etiket=:etiket,aciklama2=:aciklama2,resim2=:resim2,lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,aciklama=:aciklama,seo=:seo,tur=:tur,eklenme_tarihi=:eklenme_tarihi");
    $elaveet = $indi->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "adi" => $_POST['adi'], "lan" => $_POST["lan"], "aciklama2" => $_POST["aciklama2"], "resim2" => $resim2, "sira" => $_POST['sira'], "resim" => $resim, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "veziyyeti" => $_POST['veziyyeti'], "eklenme_tarihi" => $tarih));
    if ($elaveet) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['layihe-kateqoriya-yenile'])) {


    $seo = seflink($_POST['adi']);

    $tur = "layihe_kateqoriya";



    $id = $_POST['id'];
    $klasord = "../../sekiler/";
    $resim_tmpd = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpd)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM layihe_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {



        $tenzimleme_qeydi = $db->query("SELECT * FROM layihe_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        if ($tenzimleme_qeydi['resim'] != "no-img") {
            unlink("../../sekiler/" . $tenzimleme_qeydi['resim']);
        }

        $random = rand(0, 999);

        $resim = $random . "-" . $seo . "." . substr($_FILES['resim']['name'], -3);
        move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $resim);
    }

    $klasord = "../../sekiler/";
    $resim_tmpd2 = $_FILES['resim2']['tmp_name'];
    if (empty($resim_tmpd2)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM layihe_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim2 = $tenzimleme_qeydi['resim2'];
    } else {



        $tenzimleme_qeydi = $db->query("SELECT * FROM layihe_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        if ($tenzimleme_qeydi['resim2'] != "no-img") {
            unlink("../../sekiler/" . $tenzimleme_qeydi['resim2']);
        }

        $random = rand(0, 999);

        $resim2 = $random . "-" . $seo . "." . substr($_FILES['resim2']['name'], -3);
        move_uploaded_file($_FILES['resim2']['tmp_name'], $klasord . "/" . $resim2);
    }







    $indi1 = $db->prepare("update layihe_kateqoriya set title=:title,description=:description,etiket=:etiket,aciklama2=:aciklama2,resim2=:resim2,lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,guncelleme_tarihi=:guncelleme_tarihi where id=:id");
    $elaveet1 = $indi1->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "adi" => $_POST['adi'], "lan" => $_POST["lan"], "resim2" => $resim2, "aciklama2" => $_POST["aciklama2"], "sira" => $_POST['sira'], "resim" => $resim, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "onaciklama" => $onaciklama, "veziyyeti" => $_POST['veziyyeti'], "guncelleme_tarihi" => $tarih, "id" => $id));
    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['mehsul-elavesi'])) {


    $seo = seflink($_POST['adi']);
    $tur = "mehsullar";
    $klasorbanka = "../../imgupload/"; // Resimlerin yükleneceği klasör
    $tarih = date('Y-m-d H:i:s');
    
    $sira_degeri = 1;
    if (isset($_POST['sira']) && $_POST['sira'] !== '') {
        $sira_degeri = intval($_POST['sira']);
    } else {
        // Formdan sıra gelmediyse, veritabanındaki en yüksek değeri bul
        $son_sira_sorgu = $db->query("SELECT MAX(sira) AS max_sira FROM mehsullar");
        $sonuc = $son_sira_sorgu->fetch(PDO::FETCH_ASSOC);
        if ($sonuc && isset($sonuc['max_sira'])) {
            $sira_degeri = $sonuc['max_sira'] + 1;
        }
    }

    // --- BİRİNCİ RESİM İŞLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        $resim = "no-img";
    } else {
        $file_type = $_FILES["resim"]["type"];
        // Desteklenen formatları kontrol edin
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            // Geçici dosyayı sunucuya taşı
            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasorbanka . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                // Resim tipine göre farklı imagecreatefrom fonksiyonunu kullanın
                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    // PNG için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    // GIF için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else { // JPG veya JPEG ise
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    // WebP dönüştürme kalitesi: 0 (en düşük) - 100 (en yüksek). Genellikle 80-90 arası iyidir.
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path); // Geçici orijinal dosyayı silin
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM İŞLEME SONU ---

    // --- İKİNCİ RESİM İŞLEME BAŞLANGICI (resim2) ---
    if (empty($_FILES['resim2']['tmp_name'])) {
        $resim2 = "no-img";
    } else {
        $file_type2 = $_FILES["resim2"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {

            $random2 = rand(0, 9999999);
            $original_file_extension2 = pathinfo($_FILES['resim2']['name'], PATHINFO_EXTENSION);
            $temp_filename2 = $random2 . "-" . $seo . "." . $original_file_extension2;

            if (move_uploaded_file($_FILES['resim2']['tmp_name'], $klasorbanka . "/" . $temp_filename2)) {
                $file_path2 = "../../imgupload/" . $temp_filename2;
                $image2 = null;

                if ($file_type2 == "image/png") {
                    $image2 = imagecreatefrompng($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } elseif ($file_type2 == "image/gif") {
                    $image2 = imagecreatefromgif($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } else {
                    $image2 = imagecreatefromjpeg($file_path2);
                }

                if ($image2) {
                    $output2 = '../../imgupload/' . $random2 . '-' . $seo . '.webp';
                    $resim2 = $random2 . '-' . $seo . '.webp';
                    imagewebp($image2, $output2, 85);
                    imagedestroy($image2);
                    unlink($file_path2);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkinci resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkinci dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKİNCİ RESİM İŞLEME SONU ---

    // --- İKON İŞLEME BAŞLANGICI (icon) ---
    // İkon yükleme alanı boşsa "no-img" ata
    if (empty($_FILES['icon']['tmp_name'])) {
        $icon = "no-img";
    } else {
        $file_type_icon = $_FILES["icon"]["type"];
        if ($file_type_icon == "image/gif" || $file_type_icon == "image/png" || $file_type_icon == "image/jpg" || $file_type_icon == "image/jpeg") {

            $random_icon = rand(0, 9999999);
            $original_file_extension_icon = pathinfo($_FILES['icon']['name'], PATHINFO_EXTENSION);
            $temp_filename_icon = $random_icon . "-" . $seo . "-icon." . $original_file_extension_icon; // İkon için farklı bir adlandırma

            if (move_uploaded_file($_FILES['icon']['tmp_name'], $klasorbanka . "/" . $temp_filename_icon)) {
                $file_path_icon = "../../imgupload/" . $temp_filename_icon;
                $image_icon = null;

                if ($file_type_icon == "image/png") {
                    $image_icon = imagecreatefrompng($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } elseif ($file_type_icon == "image/gif") {
                    $image_icon = imagecreatefromgif($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } else {
                    $image_icon = imagecreatefromjpeg($file_path_icon);
                }

                if ($image_icon) {
                    $output_icon = '../../imgupload/' . $random_icon . '-' . $seo . '-icon.webp'; // WebP formatında kaydet
                    $icon = $random_icon . '-' . $seo . '-icon.webp'; // Veritabanına kaydelanecek isim
                    imagewebp($image_icon, $output_icon, 85);
                    imagedestroy($image_icon);
                    unlink($file_path_icon); // Geçici dosyayı sil
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkon işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkon dosyası yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> İkon için lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKON İŞLEME SONU ---


    $indi = $db->prepare("insert into mehsullar set stok=:stok,title=:title,etiket=:etiket,meta_title=:meta_title,meta_des=:meta_des,meta_key=:meta_key,description=:description,kur=:kur,lan=:lan,indir=:indir,panel=:panel,videolinki=:videolinki,linki=:linki,fiyat=:fiyat,adi=:adi,sira=:sira,resim=:resim,resim2=:resim2,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,eklenme_tarihi=:eklenme_tarihi");
    $elaveet = $indi->execute(array("stok" => $_POST["stok"], "title" => $_POST["title"], "etiket" => $_POST["etiket"], "meta_title" => $_POST["meta_title"], "meta_des" => $_POST["meta_des"], "meta_key" => $_POST["meta_key"], "description" => $_POST["description"], "indir" => $_POST['indir'], "kur" => $_POST["kur"], "lan" => $_POST["lan"], "panel" => $_POST['panel'], "videolinki" => $_POST['videolinki'], "fiyat" => $_POST['fiyat'], "adi" => $_POST['adi'], "linki" => $_POST['linki'], "sira" => $sira_degeri, "resim" => $resim, "resim2" => $resim2, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "onaciklama" => $_POST['onaciklama'], "veziyyeti" => $_POST['veziyyeti'], "eklenme_tarihi" => $tarih));
    if ($elaveet) {
        $sonid = $db->query("select * from mehsullar order by id desc")->fetch(PDO::FETCH_ASSOC);

        $yeni = $sonid['id'];
        if (isset($_POST['img'])) {
            foreach ($_POST['img'] as $img) {
                $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?,tur=?");
                $islem = $islem->execute(array($yeni, $img, $tur));
            }
        }

        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST['mehsul-yenile'])) {

    $id = $_POST['id'];


    $seo = seflink($_POST['adi']);

    $tur = "mehsullar";

    $klasord = "../../imgupload/";

    // --- BİRİNCİ RESİM GÜNCELLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        // Resim yüklenmediyse mevcut resmi koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM mehsullar WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        $file_type = $_FILES["resim"]["type"];
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            // Eski resmi sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM mehsullar WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['resim'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else {
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM GÜNCELLEME SONU ---

    // --- İKİNCİ RESİM GÜNCELLEME BAŞLANGICI (resim2) ---
    if (empty($_FILES['resim2']['tmp_name'])) {
        // Resim yüklenmediyse mevcut resmi koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM mehsullar WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim2 = $tenzimleme_qeydi['resim2'];
    } else {
        $file_type2 = $_FILES["resim2"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {

            // Eski resmi sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM mehsullar WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim2'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['resim2'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim2']);
            }

            $random2 = rand(0, 9999999);
            $original_file_extension2 = pathinfo($_FILES['resim2']['name'], PATHINFO_EXTENSION);
            $temp_filename2 = $random2 . "-" . $seo . "." . $original_file_extension2;

            if (move_uploaded_file($_FILES['resim2']['tmp_name'], $klasord . "/" . $temp_filename2)) {
                $file_path2 = "../../imgupload/" . $temp_filename2;
                $image2 = null;

                if ($file_type2 == "image/png") {
                    $image2 = imagecreatefrompng($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } elseif ($file_type2 == "image/gif") {
                    $image2 = imagecreatefromgif($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } else {
                    $image2 = imagecreatefromjpeg($file_path2);
                }

                if ($image2) {
                    $output2 = '../../imgupload/' . $random2 . '-' . $seo . '.webp';
                    $resim2 = $random2 . '-' . $seo . '.webp';
                    imagewebp($image2, $output2, 85);
                    imagedestroy($image2);
                    unlink($file_path2);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkinci resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkinci dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKİNCİ RESİM GÜNCELLEME SONU ---

    // --- İKON GÜNCELLEME BAŞLANGICI (icon) ---
    // Eğer 'icon' adında bir dosya yüklemesi varsa işlem yap
    if (empty($_FILES['icon']['tmp_name'])) {
        // İkon yüklenmediyse mevcut ikonu koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM mehsullar WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $icon = $tenzimleme_qeydi['icon'];
    } else {
        $file_type_icon = $_FILES["icon"]["type"];
        if ($file_type_icon == "image/gif" || $file_type_icon == "image/png" || $file_type_icon == "image/jpg" || $file_type_icon == "image/jpeg") {

            // Eski ikonu sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM mehsullar WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['icon'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['icon'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['icon']);
            }

            $random_icon = rand(0, 9999999);
            $original_file_extension_icon = pathinfo($_FILES['icon']['name'], PATHINFO_EXTENSION);
            $temp_filename_icon = $random_icon . "-" . $seo . "-icon." . $original_file_extension_icon; // İkon için farklı bir adlandırma

            if (move_uploaded_file($_FILES['icon']['tmp_name'], $klasord . "/" . $temp_filename_icon)) {
                $file_path_icon = "../../imgupload/" . $temp_filename_icon;
                $image_icon = null;

                if ($file_type_icon == "image/png") {
                    $image_icon = imagecreatefrompng($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } elseif ($file_type_icon == "image/gif") {
                    $image_icon = imagecreatefromgif($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } else {
                    $image_icon = imagecreatefromjpeg($file_path_icon);
                }

                if ($image_icon) {
                    $output_icon = '../../imgupload/' . $random_icon . '-' . $seo . '-icon.webp'; // WebP formatında kaydet
                    $icon = $random_icon . '-' . $seo . '-icon.webp'; // Veritabanına kaydedilecek isim
                    imagewebp($image_icon, $output_icon, 85);
                    imagedestroy($image_icon);
                    unlink($file_path_icon); // Geçici dosyayı sil
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkon işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkon dosyası yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> İkon için lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKON GÜNCELLEME SONU ---


    $deleteee = $db->exec("DELETE FROM urun_img WHERE urun_id = '$id' ");

    if (isset($_POST['img'])) {
        foreach ($_POST['img'] as $img) {
            $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?,tur=?");
            $islem = $islem->execute(array($id, $img, $tur));
        }
    }

    $indi1 = $db->prepare("update mehsullar set stok=:stok,title=:title,etiket=:etiket,meta_title=:meta_title,meta_des=:meta_des,meta_key=:meta_key,description=:description,kur=:kur,lan=:lan,indir=:indir,panel=:panel,videolinki=:videolinki,linki=:linki,fiyat=:fiyat,adi=:adi,sira=:sira,resim=:resim,resim2=:resim2,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,guncelleme_tarihi=:guncelleme_tarihi where id=:id");
    $elaveet1 = $indi1->execute(array("title" => $_POST["title"], "stok" => $_POST["stok"], "etiket" => $_POST["etiket"], "meta_title" => $_POST["meta_title"], "meta_des" => $_POST["meta_des"], "meta_key" => $_POST["meta_key"], "description" => $_POST["description"], "kur" => $_POST["kur"], "indir" => $_POST['indir'], "lan" => $_POST["lan"], "panel" => $_POST['panel'], "videolinki" => $_POST['videolinki'], "fiyat" => $_POST['fiyat'], "adi" => $_POST['adi'], "linki" => $_POST['linki'], "sira" => $_POST['sira'], "resim" => $resim, "resim2" => $resim2, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "onaciklama" => $_POST['onaciklama'], "veziyyeti" => $_POST['veziyyeti'], "guncelleme_tarihi" => $tarih, "id" => $id));
    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST['paket-elavesi'])) {


    $seo = seflink($_POST['adi']);
    $tur = "paketler";
    $klasorbanka = "../../imgupload/"; // Resimlerin yükleneceği klasör

    // --- BİRİNCİ RESİM İŞLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        $resim = "no-img";
    } else {
        $file_type = $_FILES["resim"]["type"];
        // Desteklenen formatları kontrol edin
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            // Geçici dosyayı sunucuya taşı
            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasorbanka . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                // Resim tipine göre farklı imagecreatefrom fonksiyonunu kullanın
                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    // PNG için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    // GIF için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else { // JPG veya JPEG ise
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    // WebP dönüştürme kalitesi: 0 (en düşük) - 100 (en yüksek). Genellikle 80-90 arası iyidir.
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path); // Geçici orijinal dosyayı silin
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM İŞLEME SONU ---

    // --- İKİNCİ RESİM İŞLEME BAŞLANGICI (resim2) ---
    if (empty($_FILES['resim2']['tmp_name'])) {
        $resim2 = "no-img";
    } else {
        $file_type2 = $_FILES["resim2"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {

            $random2 = rand(0, 9999999);
            $original_file_extension2 = pathinfo($_FILES['resim2']['name'], PATHINFO_EXTENSION);
            $temp_filename2 = $random2 . "-" . $seo . "." . $original_file_extension2;

            if (move_uploaded_file($_FILES['resim2']['tmp_name'], $klasorbanka . "/" . $temp_filename2)) {
                $file_path2 = "../../imgupload/" . $temp_filename2;
                $image2 = null;

                if ($file_type2 == "image/png") {
                    $image2 = imagecreatefrompng($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } elseif ($file_type2 == "image/gif") {
                    $image2 = imagecreatefromgif($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } else {
                    $image2 = imagecreatefromjpeg($file_path2);
                }

                if ($image2) {
                    $output2 = '../../imgupload/' . $random2 . '-' . $seo . '.webp';
                    $resim2 = $random2 . '-' . $seo . '.webp';
                    imagewebp($image2, $output2, 85);
                    imagedestroy($image2);
                    unlink($file_path2);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkinci resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkinci dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKİNCİ RESİM İŞLEME SONU ---

    // --- İKON İŞLEME BAŞLANGICI (icon) ---
    // İkon yükleme alanı boşsa "no-img" ata
    if (empty($_FILES['icon']['tmp_name'])) {
        $icon = "no-img";
    } else {
        $file_type_icon = $_FILES["icon"]["type"];
        if ($file_type_icon == "image/gif" || $file_type_icon == "image/png" || $file_type_icon == "image/jpg" || $file_type_icon == "image/jpeg") {

            $random_icon = rand(0, 9999999);
            $original_file_extension_icon = pathinfo($_FILES['icon']['name'], PATHINFO_EXTENSION);
            $temp_filename_icon = $random_icon . "-" . $seo . "-icon." . $original_file_extension_icon; // İkon için farklı bir adlandırma

            if (move_uploaded_file($_FILES['icon']['tmp_name'], $klasorbanka . "/" . $temp_filename_icon)) {
                $file_path_icon = "../../imgupload/" . $temp_filename_icon;
                $image_icon = null;

                if ($file_type_icon == "image/png") {
                    $image_icon = imagecreatefrompng($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } elseif ($file_type_icon == "image/gif") {
                    $image_icon = imagecreatefromgif($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } else {
                    $image_icon = imagecreatefromjpeg($file_path_icon);
                }

                if ($image_icon) {
                    $output_icon = '../../imgupload/' . $random_icon . '-' . $seo . '-icon.webp'; // WebP formatında kaydet
                    $icon = $random_icon . '-' . $seo . '-icon.webp'; // Veritabanına kaydelanecek isim
                    imagewebp($image_icon, $output_icon, 85);
                    imagedestroy($image_icon);
                    unlink($file_path_icon); // Geçici dosyayı sil
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkon işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkon dosyası yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> İkon için lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKON İŞLEME SONU ---


    $indi = $db->prepare("insert into paketler set stok=:stok,title=:title,etiket=:etiket,meta_title=:meta_title,meta_des=:meta_des,meta_key=:meta_key,description=:description,kur=:kur,lan=:lan,indir=:indir,panel=:panel,videolinki=:videolinki,linki=:linki,fiyat=:fiyat,adi=:adi,sira=:sira,resim=:resim,resim2=:resim2,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,eklenme_tarihi=:eklenme_tarihi");
    $elaveet = $indi->execute(array("stok" => $_POST["stok"], "title" => $_POST["title"], "etiket" => $_POST["etiket"], "meta_title" => $_POST["meta_title"], "meta_des" => $_POST["meta_des"], "meta_key" => $_POST["meta_key"], "description" => $_POST["description"], "indir" => $_POST['indir'], "kur" => $_POST["kur"], "lan" => $_POST["lan"], "panel" => $_POST['panel'], "videolinki" => $_POST['videolinki'], "fiyat" => $_POST['fiyat'], "adi" => $_POST['adi'], "linki" => $_POST['linki'], "sira" => $_POST['sira'], "resim" => $resim, "resim2" => $resim2, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "onaciklama" => $_POST['onaciklama'], "veziyyeti" => $_POST['veziyyeti'], "eklenme_tarihi" => $tarih));
    if ($elaveet) {
        $sonid = $db->query("select * from paketler order by id desc")->fetch(PDO::FETCH_ASSOC);

        $yeni = $sonid['id'];
        if (isset($_POST['img'])) {
            foreach ($_POST['img'] as $img) {
                $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?,tur=?");
                $islem = $islem->execute(array($yeni, $img, $tur));
            }
        }

        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST['paket-yenile'])) {

    $id = $_POST['id'];


    $seo = seflink($_POST['adi']);

    $tur = "paketler";

    $klasord = "../../imgupload/";

    // --- BİRİNCİ RESİM GÜNCELLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        // Resim yüklenmediyse mevcut resmi koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM paketler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        $file_type = $_FILES["resim"]["type"];
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            // Eski resmi sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM paketler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['resim'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else {
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM GÜNCELLEME SONU ---

    // --- İKİNCİ RESİM GÜNCELLEME BAŞLANGICI (resim2) ---
    if (empty($_FILES['resim2']['tmp_name'])) {
        // Resim yüklenmediyse mevcut resmi koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM paketler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim2 = $tenzimleme_qeydi['resim2'];
    } else {
        $file_type2 = $_FILES["resim2"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {

            // Eski resmi sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM paketler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim2'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['resim2'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim2']);
            }

            $random2 = rand(0, 9999999);
            $original_file_extension2 = pathinfo($_FILES['resim2']['name'], PATHINFO_EXTENSION);
            $temp_filename2 = $random2 . "-" . $seo . "." . $original_file_extension2;

            if (move_uploaded_file($_FILES['resim2']['tmp_name'], $klasord . "/" . $temp_filename2)) {
                $file_path2 = "../../imgupload/" . $temp_filename2;
                $image2 = null;

                if ($file_type2 == "image/png") {
                    $image2 = imagecreatefrompng($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } elseif ($file_type2 == "image/gif") {
                    $image2 = imagecreatefromgif($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } else {
                    $image2 = imagecreatefromjpeg($file_path2);
                }

                if ($image2) {
                    $output2 = '../../imgupload/' . $random2 . '-' . $seo . '.webp';
                    $resim2 = $random2 . '-' . $seo . '.webp';
                    imagewebp($image2, $output2, 85);
                    imagedestroy($image2);
                    unlink($file_path2);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkinci resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkinci dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKİNCİ RESİM GÜNCELLEME SONU ---

    // --- İKON GÜNCELLEME BAŞLANGICI (icon) ---
    // Eğer 'icon' adında bir dosya yüklemesi varsa işlem yap
    if (empty($_FILES['icon']['tmp_name'])) {
        // İkon yüklenmediyse mevcut ikonu koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM paketler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $icon = $tenzimleme_qeydi['icon'];
    } else {
        $file_type_icon = $_FILES["icon"]["type"];
        if ($file_type_icon == "image/gif" || $file_type_icon == "image/png" || $file_type_icon == "image/jpg" || $file_type_icon == "image/jpeg") {

            // Eski ikonu sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM paketler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['icon'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['icon'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['icon']);
            }

            $random_icon = rand(0, 9999999);
            $original_file_extension_icon = pathinfo($_FILES['icon']['name'], PATHINFO_EXTENSION);
            $temp_filename_icon = $random_icon . "-" . $seo . "-icon." . $original_file_extension_icon; // İkon için farklı bir adlandırma

            if (move_uploaded_file($_FILES['icon']['tmp_name'], $klasord . "/" . $temp_filename_icon)) {
                $file_path_icon = "../../imgupload/" . $temp_filename_icon;
                $image_icon = null;

                if ($file_type_icon == "image/png") {
                    $image_icon = imagecreatefrompng($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } elseif ($file_type_icon == "image/gif") {
                    $image_icon = imagecreatefromgif($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } else {
                    $image_icon = imagecreatefromjpeg($file_path_icon);
                }

                if ($image_icon) {
                    $output_icon = '../../imgupload/' . $random_icon . '-' . $seo . '-icon.webp'; // WebP formatında kaydet
                    $icon = $random_icon . '-' . $seo . '-icon.webp'; // Veritabanına kaydedilecek isim
                    imagewebp($image_icon, $output_icon, 85);
                    imagedestroy($image_icon);
                    unlink($file_path_icon); // Geçici dosyayı sil
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkon işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkon dosyası yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> İkon için lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKON GÜNCELLEME SONU ---


    $deleteee = $db->exec("DELETE FROM urun_img WHERE urun_id = '$id' ");

    if (isset($_POST['img'])) {
        foreach ($_POST['img'] as $img) {
            $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?,tur=?");
            $islem = $islem->execute(array($id, $img, $tur));
        }
    }

    $indi1 = $db->prepare("update paketler set stok=:stok,title=:title,etiket=:etiket,meta_title=:meta_title,meta_des=:meta_des,meta_key=:meta_key,description=:description,kur=:kur,lan=:lan,indir=:indir,panel=:panel,videolinki=:videolinki,linki=:linki,fiyat=:fiyat,adi=:adi,sira=:sira,resim=:resim,resim2=:resim2,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,guncelleme_tarihi=:guncelleme_tarihi where id=:id");
    $elaveet1 = $indi1->execute(array("title" => $_POST["title"], "stok" => $_POST["stok"], "etiket" => $_POST["etiket"], "meta_title" => $_POST["meta_title"], "meta_des" => $_POST["meta_des"], "meta_key" => $_POST["meta_key"], "description" => $_POST["description"], "kur" => $_POST["kur"], "indir" => $_POST['indir'], "lan" => $_POST["lan"], "panel" => $_POST['panel'], "videolinki" => $_POST['videolinki'], "fiyat" => $_POST['fiyat'], "adi" => $_POST['adi'], "linki" => $_POST['linki'], "sira" => $_POST['sira'], "resim" => $resim, "resim2" => $resim2, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "onaciklama" => $_POST['onaciklama'], "veziyyeti" => $_POST['veziyyeti'], "guncelleme_tarihi" => $tarih, "id" => $id));
    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['paket-kateqoriya-elavesi'])) {

    $seo = seflink($_POST['adi']);

    $tur = "paket_kateqoriya";

    $klasorbanka = "../../imgupload/";
    $resim_tmpbanka = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpbanka)) {
        $resim = "no-img";
    } else {

        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {
            $random = rand(0, 9999999);

            $resim1 = $random . "-" . $seo . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasorbanka . "/" . $resim1);

            $file = "../../imgupload/" . $resim1;
            $image = imagecreatefromstring(file_get_contents($file));
            ob_start();
            imagejpeg($image, NULL, 100);
            $cont = ob_get_contents();
            ob_end_clean();
            $randomm = rand(0, 965465465465456);
            imagedestroy($image);
            $content = imagecreatefromstring($cont);
            $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
            $resim = $random . '-' . $seo . '.webp';
            imagewebp($content, $output);
            imagedestroy($content);
            unlink('../../imgupload/' . $resim1);
        } else {
            $bilgi = '<div class="alert alert-error">
        <button class="close" data-dismiss="alert">×</button>
        <strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
        </div>';
        }
    }


    $indi = $db->prepare("insert into paket_kateqoriya set title=:title,description=:description,etiket=:etiket,lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,aciklama=:aciklama,seo=:seo,tur=:tur,eklenme_tarihi=:eklenme_tarihi");
    $elaveet = $indi->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "adi" => $_POST['adi'], "lan" => $_POST["lan"], "sira" => $_POST['sira'], "resim" => $resim, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "veziyyeti" => $_POST['veziyyeti'], "eklenme_tarihi" => $tarih));
    if ($elaveet) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['paket-kateqoriya-yenille'])) {

    $seo = seflink($_POST['adi']);

    $tur = "paket_kateqoriya";

    $id = $_POST['id'];
    $klasord = "../../imgupload/";
    $resim_tmpd = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpd)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM paket_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {

        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM paket_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img") {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 999);

            $resim1 = $random . "-" . $seo . $_FILES['resim'];

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $resim1);
            $file = "../../imgupload/" . $resim1;
            $image = imagecreatefromstring(file_get_contents($file));
            ob_start();
            imagejpeg($image, NULL, 100);
            $cont = ob_get_contents();
            ob_end_clean();

            imagedestroy($image);
            $content = imagecreatefromstring($cont);
            $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
            $resim = $random . '-' . $seo . '.webp';
            imagewebp($content, $output);
            imagedestroy($content);
            unlink('../../imgupload/' . $resim1);
        } else {
            $bilgi = '<div class="alert alert-error">
        <button class="close" data-dismiss="alert">×</button>
        <strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
        </div>';
        }
    }







    $indi1 = $db->prepare("update paket_kateqoriya set title=:title,description=:description,etiket=:etiket,lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,guncelleme_tarihi=:guncelleme_tarihi where id=:id");
    $elaveet1 = $indi1->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "adi" => $_POST['adi'], "lan" => $_POST["lan"], "sira" => $_POST['sira'], "resim" => $resim, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "onaciklama" => $onaciklama, "veziyyeti" => $_POST['veziyyeti'], "guncelleme_tarihi" => $tarih, "id" => $id));
    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

// if (isset($_POST['paket-elavesi'])) {

//     $seo = seflink($_POST['adi']);
//     $tur = "paketler";
//     $klasorbanka = "../../imgupload/";
//     $resim_tmpbanka = $_FILES['resim']['tmp_name'];
//     if (empty($resim_tmpbanka)) {
//         $resim = "no-img";
//     } else {

//         if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {
//             $random = rand(0, 9999999);

//             $resim1 = $random . "-" . $seo . "." . substr($_FILES['resim']['name'], -3);

//             move_uploaded_file($_FILES['resim']['tmp_name'], $klasorbanka . "/" . $resim1);


//             $file = "../../imgupload/" . $resim1;
//             $image = imagecreatefromstring(file_get_contents($file));
//             ob_start();
//             imagejpeg($image, NULL, 100);
//             $cont = ob_get_contents();
//             ob_end_clean();
//             $randomm = rand(0, 965465465465456);
//             imagedestroy($image);
//             $content = imagecreatefromstring($cont);
//             $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
//             $resim = $random . '-' . $seo . '.webp';
//             imagewebp($content, $output);
//             imagedestroy($content);
//             unlink('../../imgupload/' . $resim1);
//         } else {
//             $bilgi = '<div class="alert alert-error">
// 		<button class="close" data-dismiss="alert">×</button>
// 		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
// 		</div>';
//         }
//     }



//     $indi = $db->prepare("insert into paketler set kur=:kur,lan=:lan,indir=:indir,panel=:panel,videolinki=:videolinki,linki=:linki,fiyat=:fiyat,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,eklenme_tarihi=:eklenme_tarihi");
//     $elaveet = $indi->execute(array("indir" => $_POST['indir'], "kur" => $_POST["kur"], "lan" => $_POST["lan"], "panel" => $_POST['panel'], "videolinki" => $_POST['videolinki'], "fiyat" => $_POST['fiyat'], "adi" => $_POST['adi'], "linki" => $_POST['linki'], "sira" => $_POST['sira'], "resim" => $resim, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "onaciklama" => $_POST['onaciklama'], "veziyyeti" => $_POST['veziyyeti'], "eklenme_tarihi" => $tarih));
//     if ($elaveet) {



//         $sonid = $db->query("select * from paketler order by id desc")->fetch(PDO::FETCH_ASSOC);

//         $yeni = $sonid['id'];
//         if (isset($_POST['img'])) {
//             foreach ($_POST['img'] as $img) {
//                 $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?,tur=?");
//                 $islem = $islem->execute(array($yeni, $img, $tur));
//             }
//         }

//         header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
//     } else {
//         header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
//     }
// }


// if (isset($_POST['paket-yenile'])) {

//     $id = $_POST['id'];

//     $seo = seflink($_POST['adi']);

//     $tur = "paketler";

//     $klasord = "../../imgupload/";
//     $resim_tmpd = $_FILES['resim']['tmp_name'];
//     if (empty($resim_tmpd)) {
//         $duzenlenecek_id = $_GET['id'];
//         $tenzimleme_qeydi = $db->query("SELECT * FROM paketler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
//         $resim = $tenzimleme_qeydi['resim'];
//     } else {

//         if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {

//             $tenzimleme_qeydi = $db->query("SELECT * FROM paketler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
//             if ($tenzimleme_qeydi['resim'] != "no-img") {
//                 unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
//             }

//             $random = rand(0, 999);

//             $resim1 = $random . "-" . $seo . $_FILES['resim'];

//             move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $resim1);

//             $file = "../../imgupload/" . $resim1;
//             $image = imagecreatefromstring(file_get_contents($file));
//             ob_start();
//             imagejpeg($image, NULL, 100);
//             $cont = ob_get_contents();
//             ob_end_clean();
//             $randomm = rand(0, 965465465465456);
//             imagedestroy($image);
//             $content = imagecreatefromstring($cont);
//             $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
//             $resim = $random . '-' . $seo . '.webp';
//             imagewebp($content, $output);
//             imagedestroy($content);
//             unlink('../../imgupload/' . $resim1);
//         } else {
//             $bilgi = '<div class="alert alert-error">
// 		<button class="close" data-dismiss="alert">×</button>
// 		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
// 		</div>';
//         }
//     }


//     $deleteee = $db->exec("DELETE FROM urun_img WHERE urun_id = '$id' ");

//     if (isset($_POST['img'])) {
//         foreach ($_POST['img'] as $img) {


//             $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?,tur=?");
//             $islem = $islem->execute(array($id, $img, $tur));
//         }
//     }





//     $indi1 = $db->prepare("update paketler set kur=:kur,lan=:lan,indir=:indir,panel=:panel,videolinki=:videolinki,linki=:linki,fiyat=:fiyat,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,guncelleme_tarihi=:guncelleme_tarihi where id=:id");
//     $elaveet1 = $indi1->execute(array("kur" => $_POST["kur"], "indir" => $_POST['indir'], "lan" => $_POST["lan"], "panel" => $_POST['panel'], "videolinki" => $_POST['videolinki'], "fiyat" => $_POST['fiyat'], "adi" => $_POST['adi'], "linki" => $_POST['linki'], "sira" => $_POST['sira'], "resim" => $resim, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "onaciklama" => $_POST['onaciklama'], "veziyyeti" => $_POST['veziyyeti'], "guncelleme_tarihi" => $tarih, "id" => $id));
//     if ($elaveet1) {





//         header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
//     } else {
//         header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
//     }
// }


if (isset($_POST['layihe-elavesi'])) {

    $seo = seflink($_POST['adi']);
    $tur = "layiheler";
    $klasorbanka = "../../imgupload/"; // Resimlerin yükleneceği klasör
    $tarih = date('Y-m-d H:i:s');
    
    $sira_degeri = 1;
    if (isset($_POST['sira']) && $_POST['sira'] !== '') {
        $sira_degeri = intval($_POST['sira']);
    } else {
        // Formdan sıra gelmediyse, veritabanındaki en yüksek değeri bul
        $son_sira_sorgu = $db->query("SELECT MAX(sira) AS max_sira FROM mehsullar");
        $sonuc = $son_sira_sorgu->fetch(PDO::FETCH_ASSOC);
        if ($sonuc && isset($sonuc['max_sira'])) {
            $sira_degeri = $sonuc['max_sira'] + 1;
        }
    }

    // --- BİRİNCİ RESİM İŞLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        $resim = "no-img";
    } else {
        $file_type = $_FILES["resim"]["type"];
        // Desteklenen formatları kontrol edin
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            // Geçici dosyayı sunucuya taşı
            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasorbanka . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                // Resim tipine göre farklı imagecreatefrom fonksiyonunu kullanın
                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    // PNG için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    // GIF için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else { // JPG veya JPEG ise
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    // WebP dönüştürme kalitesi: 0 (en düşük) - 100 (en yüksek). Genellikle 80-90 arası iyidir.
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path); // Geçici orijinal dosyayı silin
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM İŞLEME SONU ---

    // --- İKİNCİ RESİM İŞLEME BAŞLANGICI (resim2) ---
    if (empty($_FILES['sehifesekli']['tmp_name'])) {
        $sehifesekli = "no-img";
    } else {
        $file_type2 = $_FILES["sehifesekli"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {

            $random2 = rand(0, 9999999);
            $original_file_extension2 = pathinfo($_FILES['sehifesekli']['name'], PATHINFO_EXTENSION);
            $temp_filename2 = $random2 . "-" . $seo . "." . $original_file_extension2;

            if (move_uploaded_file($_FILES['sehifesekli']['tmp_name'], $klasorbanka . "/" . $temp_filename2)) {
                $file_path2 = "../../imgupload/" . $temp_filename2;
                $image2 = null;

                if ($file_type2 == "image/png") {
                    $image2 = imagecreatefrompng($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } elseif ($file_type2 == "image/gif") {
                    $image2 = imagecreatefromgif($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } else {
                    $image2 = imagecreatefromjpeg($file_path2);
                }

                if ($image2) {
                    $output2 = '../../imgupload/' . $random2 . '-' . $seo . '.webp';
                    $sehifesekli = $random2 . '-' . $seo . '.webp';
                    imagewebp($image2, $output2, 85);
                    imagedestroy($image2);
                    unlink($file_path2);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkinci resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkinci dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }

    // --- İKON İŞLEME BAŞLANGICI (icon) ---
    // İkon yükleme alanı boşsa "no-img" ata
    if (empty($_FILES['icon']['tmp_name'])) {
        $icon = "no-img";
    } else {
        $file_type_icon = $_FILES["icon"]["type"];
        if ($file_type_icon == "image/gif" || $file_type_icon == "image/png" || $file_type_icon == "image/jpg" || $file_type_icon == "image/jpeg") {

            $random_icon = rand(0, 9999999);
            $original_file_extension_icon = pathinfo($_FILES['icon']['name'], PATHINFO_EXTENSION);
            $temp_filename_icon = $random_icon . "-" . $seo . "-icon." . $original_file_extension_icon; // İkon için farklı bir adlandırma

            if (move_uploaded_file($_FILES['icon']['tmp_name'], $klasorbanka . "/" . $temp_filename_icon)) {
                $file_path_icon = "../../imgupload/" . $temp_filename_icon;
                $image_icon = null;

                if ($file_type_icon == "image/png") {
                    $image_icon = imagecreatefrompng($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } elseif ($file_type_icon == "image/gif") {
                    $image_icon = imagecreatefromgif($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } else {
                    $image_icon = imagecreatefromjpeg($file_path_icon);
                }

                if ($image_icon) {
                    $output_icon = '../../imgupload/' . $random_icon . '-' . $seo . '-icon.webp'; // WebP formatında kaydet
                    $icon = $random_icon . '-' . $seo . '-icon.webp'; // Veritabanına kaydedilecek isim
                    imagewebp($image_icon, $output_icon, 85);
                    imagedestroy($image_icon);
                    unlink($file_path_icon); // Geçici dosyayı sil
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkon işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkon dosyası yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> İkon için lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKON İŞLEME SONU ---



    $indi = $db->prepare("insert into layiheler set title=:title,description=:description,etiket=:etiket,meta_title=:meta_title,meta_des=:meta_des,meta_key=:meta_key,lan=:lan,indir=:indir,panel=:panel,videolinki=:videolinki,linki=:linki,fiyat=:fiyat,adi=:adi,sira=:sira,resim=:resim,sehifesekli=:sehifesekli,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,baslama_tarixi=:baslama_tarixi,bitme_tarixi=:bitme_tarixi,elaveolunma_tarixi=:elaveolunma_tarixi");
    $elaveet = $indi->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "meta_title" => $_POST["meta_title"], "meta_des" => $_POST["meta_des"], "meta_key" => $_POST["meta_key"], "indir" => $_POST['indir'], "lan" => $_POST["lan"], "panel" => $_POST['panel'], "videolinki" => $_POST['videolinki'], "fiyat" => $_POST['fiyat'], "adi" => $_POST['adi'], "linki" => $_POST['linki'], "sira" => $sira_degeri, "baslama_tarixi" => $_POST['baslama_tarixi'], "bitme_tarixi" => $_POST['bitme_tarixi'], "resim" => $resim, "sehifesekli" => $sehifesekli, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "onaciklama" => $_POST['onaciklama'], "veziyyeti" => $_POST['veziyyeti'], "elaveolunma_tarixi" => $tarih));
    if ($elaveet) {



        $sonid = $db->query("select * from layiheler order by id desc")->fetch(PDO::FETCH_ASSOC);

        $yeni = $sonid['id'];
        if (isset($_POST['img'])) {
            foreach ($_POST['img'] as $img) {
                $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?,tur=?");
                $islem = $islem->execute(array($yeni, $img, $tur));
            }
        }

        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST['layihe-yenile'])) {

    $id = $_POST['id'];

    $seo = seflink($_POST['adi']);

    $tur = "layiheler";

    $klasord = "../../imgupload/";

    // --- BİRİNCİ RESİM GÜNCELLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        // Resim yüklenmediyse mevcut resmi koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM layiheler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        $file_type = $_FILES["resim"]["type"];
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            // Eski resmi sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM layiheler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['resim'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else {
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM GÜNCELLEME SONU ---

    // --- İKİNCİ RESİM GÜNCELLEME BAŞLANGICI (resim2) ---
    if (empty($_FILES['sehifesekli']['tmp_name'])) {
        // Resim yüklenmediyse mevcut resmi koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM layiheler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $sehifesekli = $tenzimleme_qeydi['sehifesekli'];
    } else {
        $file_type2 = $_FILES["sehifesekli"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {

            // Eski resmi sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM layiheler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['sehifesekli'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['sehifesekli'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['sehifesekli']);
            }

            $random2 = rand(0, 9999999);
            $original_file_extension2 = pathinfo($_FILES['sehifesekli']['name'], PATHINFO_EXTENSION);
            $temp_filename2 = $random2 . "-" . $seo . "." . $original_file_extension2;

            if (move_uploaded_file($_FILES['sehifesekli']['tmp_name'], $klasord . "/" . $temp_filename2)) {
                $file_path2 = "../../imgupload/" . $temp_filename2;
                $image2 = null;

                if ($file_type2 == "image/png") {
                    $image2 = imagecreatefrompng($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } elseif ($file_type2 == "image/gif") {
                    $image2 = imagecreatefromgif($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } else {
                    $image2 = imagecreatefromjpeg($file_path2);
                }

                if ($image2) {
                    $output2 = '../../imgupload/' . $random2 . '-' . $seo . '.webp';
                    $sehifesekli = $random2 . '-' . $seo . '.webp';
                    imagewebp($image2, $output2, 85);
                    imagedestroy($image2);
                    unlink($file_path2);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkinci resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkinci dosya yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKİNCİ RESİM GÜNCELLEME SONU ---

    // --- İKON GÜNCELLEME BAŞLANGICI (icon) ---
    // Eğer 'icon' adında bir dosya yüklemesi varsa işlem yap
    if (empty($_FILES['icon']['tmp_name'])) {
        // İkon yüklenmediyse mevcut ikonu koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM layiheler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $icon = $tenzimleme_qeydi['icon'];
    } else {
        $file_type_icon = $_FILES["icon"]["type"];
        if ($file_type_icon == "image/gif" || $file_type_icon == "image/png" || $file_type_icon == "image/jpg" || $file_type_icon == "image/jpeg") {

            // Eski ikonu sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM layiheler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['icon'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['icon'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['icon']);
            }

            $random_icon = rand(0, 9999999);
            $original_file_extension_icon = pathinfo($_FILES['icon']['name'], PATHINFO_EXTENSION);
            $temp_filename_icon = $random_icon . "-" . $seo . "-icon." . $original_file_extension_icon; // İkon için farklı bir adlandırma

            if (move_uploaded_file($_FILES['icon']['tmp_name'], $klasord . "/" . $temp_filename_icon)) {
                $file_path_icon = "../../imgupload/" . $temp_filename_icon;
                $image_icon = null;

                if ($file_type_icon == "image/png") {
                    $image_icon = imagecreatefrompng($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } elseif ($file_type_icon == "image/gif") {
                    $image_icon = imagecreatefromgif($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } else {
                    $image_icon = imagecreatefromjpeg($file_path_icon);
                }

                if ($image_icon) {
                    $output_icon = '../../imgupload/' . $random_icon . '-' . $seo . '-icon.webp'; // WebP formatında kaydet
                    $icon = $random_icon . '-' . $seo . '-icon.webp'; // Veritabanına kaydedilecek isim
                    imagewebp($image_icon, $output_icon, 85);
                    imagedestroy($image_icon);
                    unlink($file_path_icon); // Geçici dosyayı sil
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkon işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkon dosyası yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> İkon için lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKON GÜNCELLEME SONU ---


    $deleteee = $db->exec("DELETE FROM urun_img WHERE urun_id = '$id' ");

    if (isset($_POST['img'])) {
        foreach ($_POST['img'] as $img) {
            $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?,tur=?");
            $islem = $islem->execute(array($id, $img, $tur));
        }
    }




    $indi1 = $db->prepare("update layiheler set title=:title,description=:description,etiket=:etiket,meta_title=:meta_title,meta_des=:meta_des,meta_key=:meta_key,lan=:lan,indir=:indir,panel=:panel,videolinki=:videolinki,linki=:linki,fiyat=:fiyat,adi=:adi,sira=:sira,resim=:resim,sehifesekli=:sehifesekli,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,baslama_tarixi=:baslama_tarixi,bitme_tarixi=:bitme_tarixi,guncelleme_tarihi=:guncelleme_tarihi where id=:id");
    $elaveet1 = $indi1->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "meta_title" => $_POST["meta_title"], "meta_des" => $_POST["meta_des"], "meta_key" => $_POST["meta_key"], "indir" => $_POST['indir'], "lan" => $_POST["lan"], "panel" => $_POST['panel'], "videolinki" => $_POST['videolinki'], "fiyat" => $_POST['fiyat'], "adi" => $_POST['adi'], "linki" => $_POST['linki'], "baslama_tarixi" => $_POST['baslama_tarixi'], "bitme_tarixi" => $_POST['bitme_tarixi'], "sira" => $_POST['sira'], "resim" => $resim, "sehifesekli" => $sehifesekli, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "onaciklama" => $_POST['onaciklama'], "veziyyeti" => $_POST['veziyyeti'], "guncelleme_tarihi" => $tarih, "id" => $id));
    if ($elaveet1) {





        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['sertifikat-elavesi'])) {

    $seo = seflink($_POST['adi']);
    $tur = "sertifikatlar";
    $klasorbanka = "../../imgupload/"; // Resimlerin yükleneceği klasör
    $tarih = date('Y-m-d H:i:s');
    
    $sira_degeri = 1;
    if (isset($_POST['sira']) && $_POST['sira'] !== '') {
        $sira_degeri = intval($_POST['sira']);
    } else {
        // Formdan sıra gelmediyse, veritabanındaki en yüksek değeri bul
        $son_sira_sorgu = $db->query("SELECT MAX(sira) AS max_sira FROM mehsullar");
        $sonuc = $son_sira_sorgu->fetch(PDO::FETCH_ASSOC);
        if ($sonuc && isset($sonuc['max_sira'])) {
            $sira_degeri = $sonuc['max_sira'] + 1;
        }
    }

    // --- BİRİNCİ RESİM İŞLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        $resim = "no-img";
    } else {
        $file_type = $_FILES["resim"]["type"];
        // Desteklenen formatları kontrol edin
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            // Geçici dosyayı sunucuya taşı
            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasorbanka . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                // Resim tipine göre farklı imagecreatefrom fonksiyonunu kullanın
                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    // PNG için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    // GIF için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else { // JPG veya JPEG ise
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    // WebP dönüştürme kalitesi: 0 (en düşük) - 100 (en yüksek). Genellikle 80-90 arası iyidir.
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path); // Geçici orijinal dosyayı silin
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM İŞLEME SONU ---

    // --- İKİNCİ RESİM İŞLEME BAŞLANGICI (resim2) ---
    if (empty($_FILES['sehifesekli']['tmp_name'])) {
        $sehifesekli = "no-img";
    } else {
        $file_type2 = $_FILES["sehifesekli"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {

            $random2 = rand(0, 9999999);
            $original_file_extension2 = pathinfo($_FILES['sehifesekli']['name'], PATHINFO_EXTENSION);
            $temp_filename2 = $random2 . "-" . $seo . "." . $original_file_extension2;

            if (move_uploaded_file($_FILES['sehifesekli']['tmp_name'], $klasorbanka . "/" . $temp_filename2)) {
                $file_path2 = "../../imgupload/" . $temp_filename2;
                $image2 = null;

                if ($file_type2 == "image/png") {
                    $image2 = imagecreatefrompng($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } elseif ($file_type2 == "image/gif") {
                    $image2 = imagecreatefromgif($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } else {
                    $image2 = imagecreatefromjpeg($file_path2);
                }

                if ($image2) {
                    $output2 = '../../imgupload/' . $random2 . '-' . $seo . '.webp';
                    $sehifesekli = $random2 . '-' . $seo . '.webp';
                    imagewebp($image2, $output2, 85);
                    imagedestroy($image2);
                    unlink($file_path2);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkinci resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkinci dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }

    // --- İKON İŞLEME BAŞLANGICI (icon) ---
    // İkon yükleme alanı boşsa "no-img" ata
    if (empty($_FILES['icon']['tmp_name'])) {
        $icon = "no-img";
    } else {
        $file_type_icon = $_FILES["icon"]["type"];
        if ($file_type_icon == "image/gif" || $file_type_icon == "image/png" || $file_type_icon == "image/jpg" || $file_type_icon == "image/jpeg") {

            $random_icon = rand(0, 9999999);
            $original_file_extension_icon = pathinfo($_FILES['icon']['name'], PATHINFO_EXTENSION);
            $temp_filename_icon = $random_icon . "-" . $seo . "-icon." . $original_file_extension_icon; // İkon için farklı bir adlandırma

            if (move_uploaded_file($_FILES['icon']['tmp_name'], $klasorbanka . "/" . $temp_filename_icon)) {
                $file_path_icon = "../../imgupload/" . $temp_filename_icon;
                $image_icon = null;

                if ($file_type_icon == "image/png") {
                    $image_icon = imagecreatefrompng($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } elseif ($file_type_icon == "image/gif") {
                    $image_icon = imagecreatefromgif($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } else {
                    $image_icon = imagecreatefromjpeg($file_path_icon);
                }

                if ($image_icon) {
                    $output_icon = '../../imgupload/' . $random_icon . '-' . $seo . '-icon.webp'; // WebP formatında kaydet
                    $icon = $random_icon . '-' . $seo . '-icon.webp'; // Veritabanına kaydedilecek isim
                    imagewebp($image_icon, $output_icon, 85);
                    imagedestroy($image_icon);
                    unlink($file_path_icon); // Geçici dosyayı sil
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkon işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkon dosyası yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> İkon için lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKON İŞLEME SONU ---



    $indi = $db->prepare("insert into sertifikatlar set title=:title,description=:description,etiket=:etiket,meta_title=:meta_title,meta_des=:meta_des,meta_key=:meta_key,lan=:lan,indir=:indir,panel=:panel,videolinki=:videolinki,linki=:linki,fiyat=:fiyat,adi=:adi,sira=:sira,resim=:resim,sehifesekli=:sehifesekli,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,baslama_tarixi=:baslama_tarixi,bitme_tarixi=:bitme_tarixi,elaveolunma_tarixi=:elaveolunma_tarixi");
    $elaveet = $indi->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "meta_title" => $_POST["meta_title"], "meta_des" => $_POST["meta_des"], "meta_key" => $_POST["meta_key"], "indir" => $_POST['indir'], "lan" => $_POST["lan"], "panel" => $_POST['panel'], "videolinki" => $_POST['videolinki'], "fiyat" => $_POST['fiyat'], "adi" => $_POST['adi'], "linki" => $_POST['linki'], "sira" => $sira_degeri, "baslama_tarixi" => $_POST['baslama_tarixi'], "bitme_tarixi" => $_POST['bitme_tarixi'], "resim" => $resim, "sehifesekli" => $sehifesekli, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "onaciklama" => $_POST['onaciklama'], "veziyyeti" => $_POST['veziyyeti'], "elaveolunma_tarixi" => $tarih));
    if ($elaveet) {



        $sonid = $db->query("select * from sertifikatlar order by id desc")->fetch(PDO::FETCH_ASSOC);

        $yeni = $sonid['id'];
        if (isset($_POST['img'])) {
            foreach ($_POST['img'] as $img) {
                $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?,tur=?");
                $islem = $islem->execute(array($yeni, $img, $tur));
            }
        }

        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST['sertifikat-yenile'])) {

    $id = $_POST['id'];

    $seo = seflink($_POST['adi']);

    $tur = "sertifikatlar";

    $klasord = "../../imgupload/";

    // --- BİRİNCİ RESİM GÜNCELLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        // Resim yüklenmediyse mevcut resmi koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM sertifikatlar WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        $file_type = $_FILES["resim"]["type"];
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            // Eski resmi sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM sertifikatlar WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['resim'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else {
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM GÜNCELLEME SONU ---

    // --- İKİNCİ RESİM GÜNCELLEME BAŞLANGICI (resim2) ---
    if (empty($_FILES['sehifesekli']['tmp_name'])) {
        // Resim yüklenmediyse mevcut resmi koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM sertifikatlar WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $sehifesekli = $tenzimleme_qeydi['sehifesekli'];
    } else {
        $file_type2 = $_FILES["sehifesekli"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {

            // Eski resmi sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM sertifikatlar WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['sehifesekli'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['sehifesekli'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['sehifesekli']);
            }

            $random2 = rand(0, 9999999);
            $original_file_extension2 = pathinfo($_FILES['sehifesekli']['name'], PATHINFO_EXTENSION);
            $temp_filename2 = $random2 . "-" . $seo . "." . $original_file_extension2;

            if (move_uploaded_file($_FILES['sehifesekli']['tmp_name'], $klasord . "/" . $temp_filename2)) {
                $file_path2 = "../../imgupload/" . $temp_filename2;
                $image2 = null;

                if ($file_type2 == "image/png") {
                    $image2 = imagecreatefrompng($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } elseif ($file_type2 == "image/gif") {
                    $image2 = imagecreatefromgif($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } else {
                    $image2 = imagecreatefromjpeg($file_path2);
                }

                if ($image2) {
                    $output2 = '../../imgupload/' . $random2 . '-' . $seo . '.webp';
                    $sehifesekli = $random2 . '-' . $seo . '.webp';
                    imagewebp($image2, $output2, 85);
                    imagedestroy($image2);
                    unlink($file_path2);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkinci resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkinci dosya yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKİNCİ RESİM GÜNCELLEME SONU ---

    // --- İKON GÜNCELLEME BAŞLANGICI (icon) ---
    // Eğer 'icon' adında bir dosya yüklemesi varsa işlem yap
    if (empty($_FILES['icon']['tmp_name'])) {
        // İkon yüklenmediyse mevcut ikonu koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM sertifikatlar WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $icon = $tenzimleme_qeydi['icon'];
    } else {
        $file_type_icon = $_FILES["icon"]["type"];
        if ($file_type_icon == "image/gif" || $file_type_icon == "image/png" || $file_type_icon == "image/jpg" || $file_type_icon == "image/jpeg") {

            // Eski ikonu sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM sertifikatlar WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['icon'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['icon'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['icon']);
            }

            $random_icon = rand(0, 9999999);
            $original_file_extension_icon = pathinfo($_FILES['icon']['name'], PATHINFO_EXTENSION);
            $temp_filename_icon = $random_icon . "-" . $seo . "-icon." . $original_file_extension_icon; // İkon için farklı bir adlandırma

            if (move_uploaded_file($_FILES['icon']['tmp_name'], $klasord . "/" . $temp_filename_icon)) {
                $file_path_icon = "../../imgupload/" . $temp_filename_icon;
                $image_icon = null;

                if ($file_type_icon == "image/png") {
                    $image_icon = imagecreatefrompng($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } elseif ($file_type_icon == "image/gif") {
                    $image_icon = imagecreatefromgif($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } else {
                    $image_icon = imagecreatefromjpeg($file_path_icon);
                }

                if ($image_icon) {
                    $output_icon = '../../imgupload/' . $random_icon . '-' . $seo . '-icon.webp'; // WebP formatında kaydet
                    $icon = $random_icon . '-' . $seo . '-icon.webp'; // Veritabanına kaydedilecek isim
                    imagewebp($image_icon, $output_icon, 85);
                    imagedestroy($image_icon);
                    unlink($file_path_icon); // Geçici dosyayı sil
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkon işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkon dosyası yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> İkon için lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKON GÜNCELLEME SONU ---


    $deleteee = $db->exec("DELETE FROM urun_img WHERE urun_id = '$id' ");

    if (isset($_POST['img'])) {
        foreach ($_POST['img'] as $img) {
            $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?,tur=?");
            $islem = $islem->execute(array($id, $img, $tur));
        }
    }




    $indi1 = $db->prepare("update sertifikatlar set title=:title,description=:description,etiket=:etiket,meta_title=:meta_title,meta_des=:meta_des,meta_key=:meta_key,lan=:lan,indir=:indir,panel=:panel,videolinki=:videolinki,linki=:linki,fiyat=:fiyat,adi=:adi,sira=:sira,resim=:resim,sehifesekli=:sehifesekli,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,baslama_tarixi=:baslama_tarixi,bitme_tarixi=:bitme_tarixi,guncelleme_tarihi=:guncelleme_tarihi where id=:id");
    $elaveet1 = $indi1->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "meta_title" => $_POST["meta_title"], "meta_des" => $_POST["meta_des"], "meta_key" => $_POST["meta_key"], "indir" => $_POST['indir'], "lan" => $_POST["lan"], "panel" => $_POST['panel'], "videolinki" => $_POST['videolinki'], "fiyat" => $_POST['fiyat'], "adi" => $_POST['adi'], "linki" => $_POST['linki'], "baslama_tarixi" => $_POST['baslama_tarixi'], "bitme_tarixi" => $_POST['bitme_tarixi'], "sira" => $_POST['sira'], "resim" => $resim, "sehifesekli" => $sehifesekli, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "onaciklama" => $_POST['onaciklama'], "veziyyeti" => $_POST['veziyyeti'], "guncelleme_tarihi" => $tarih, "id" => $id));
    if ($elaveet1) {





        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['sertifikat-kateqoriya-elavesi'])) {

    $seo = seflink($_POST['adi']);


    $tur = "sertifikat_kateqoriya";


    $klasorbanka = "../../imgupload/"; // Resimlerin yükleneceği klasör

    // --- BİRİNCİ RESİM İŞLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        $resim = "no-img";
    } else {
        $file_type = $_FILES["resim"]["type"];
        // Desteklenen formatları kontrol edin
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            // Geçici dosyayı sunucuya taşı
            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasorbanka . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                // Resim tipine göre farklı imagecreatefrom fonksiyonunu kullanın
                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    // PNG için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    // GIF için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else { // JPG veya JPEG ise
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    // WebP dönüştürme kalitesi: 0 (en düşük) - 100 (en yüksek). Genellikle 80-90 arası iyidir.
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path); // Geçici orijinal dosyayı silin
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM İŞLEME SONU ---

    // --- İKİNCİ RESİM İŞLEME BAŞLANGICI (resim2) ---
    if (empty($_FILES['resim2']['tmp_name'])) {
        $resim2 = "no-img";
    } else {
        $file_type2 = $_FILES["resim2"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {

            $random2 = rand(0, 9999999);
            $original_file_extension2 = pathinfo($_FILES['resim2']['name'], PATHINFO_EXTENSION);
            $temp_filename2 = $random2 . "-" . $seo . "." . $original_file_extension2;

            if (move_uploaded_file($_FILES['resim2']['tmp_name'], $klasorbanka . "/" . $temp_filename2)) {
                $file_path2 = "../../imgupload/" . $temp_filename2;
                $image2 = null;

                if ($file_type2 == "image/png") {
                    $image2 = imagecreatefrompng($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } elseif ($file_type2 == "image/gif") {
                    $image2 = imagecreatefromgif($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } else {
                    $image2 = imagecreatefromjpeg($file_path2);
                }

                if ($image2) {
                    $output2 = '../../imgupload/' . $random2 . '-' . $seo . '.webp';
                    $resim2 = $random2 . '-' . $seo . '.webp';
                    imagewebp($image2, $output2, 85);
                    imagedestroy($image2);
                    unlink($file_path2);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkinci resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkinci dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKİNCİ RESİM İŞLEME SONU ---

    // --- İKON İŞLEME BAŞLANGICI (icon) ---
    // İkon yükleme alanı boşsa "no-img" ata
    if (empty($_FILES['icon']['tmp_name'])) {
        $icon = "no-img";
    } else {
        $file_type_icon = $_FILES["icon"]["type"];
        if ($file_type_icon == "image/gif" || $file_type_icon == "image/png" || $file_type_icon == "image/jpg" || $file_type_icon == "image/jpeg") {

            $random_icon = rand(0, 9999999);
            $original_file_extension_icon = pathinfo($_FILES['icon']['name'], PATHINFO_EXTENSION);
            $temp_filename_icon = $random_icon . "-" . $seo . "-icon." . $original_file_extension_icon; // İkon için farklı bir adlandırma

            if (move_uploaded_file($_FILES['icon']['tmp_name'], $klasorbanka . "/" . $temp_filename_icon)) {
                $file_path_icon = "../../imgupload/" . $temp_filename_icon;
                $image_icon = null;

                if ($file_type_icon == "image/png") {
                    $image_icon = imagecreatefrompng($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } elseif ($file_type_icon == "image/gif") {
                    $image_icon = imagecreatefromgif($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } else {
                    $image_icon = imagecreatefromjpeg($file_path_icon);
                }

                if ($image_icon) {
                    $output_icon = '../../imgupload/' . $random_icon . '-' . $seo . '-icon.webp'; // WebP formatında kaydet
                    $icon = $random_icon . '-' . $seo . '-icon.webp'; // Veritabanına kaydedilecek isim
                    imagewebp($image_icon, $output_icon, 85);
                    imagedestroy($image_icon);
                    unlink($file_path_icon); // Geçici dosyayı sil
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkon işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkon dosyası yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> İkon için lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKON İŞLEME SONU ---


    $indi = $db->prepare("insert into sertifikat_kateqoriya set title=:title,description=:description,etiket=:etiket,aciklama2=:aciklama2,resim2=:resim2,lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,aciklama=:aciklama,seo=:seo,tur=:tur,eklenme_tarihi=:eklenme_tarihi");
    $elaveet = $indi->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "adi" => $_POST['adi'], "lan" => $_POST["lan"], "aciklama2" => $_POST["aciklama2"], "resim2" => $resim2, "sira" => $_POST['sira'], "resim" => $resim, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "veziyyeti" => $_POST['veziyyeti'], "eklenme_tarihi" => $tarih));
    if ($elaveet) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['sertifikat-kateqoriya-yenile'])) {

    $seo = seflink($_POST['adi']);

    $tur = "sertifikat_kateqoriya";


    $id = $_POST['id'];
    $klasord = "../../imgupload/";
    // --- BİRİNCİ RESİM GÜNCELLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        // Resim yüklenmediyse mevcut resmi koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM sertifikat_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        $file_type = $_FILES["resim"]["type"];
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            // Eski resmi sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM sertifikat_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['resim'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else {
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM GÜNCELLEME SONU ---

    // --- İKİNCİ RESİM GÜNCELLEME BAŞLANGICI (resim2) ---
    if (empty($_FILES['resim2']['tmp_name'])) {
        // Resim yüklenmediyse mevcut resmi koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM sertifikat_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim2 = $tenzimleme_qeydi['resim2'];
    } else {
        $file_type2 = $_FILES["resim2"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {

            // Eski resmi sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM sertifikat_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim2'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['resim2'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim2']);
            }

            $random2 = rand(0, 9999999);
            $original_file_extension2 = pathinfo($_FILES['resim2']['name'], PATHINFO_EXTENSION);
            $temp_filename2 = $random2 . "-" . $seo . "." . $original_file_extension2;

            if (move_uploaded_file($_FILES['resim2']['tmp_name'], $klasord . "/" . $temp_filename2)) {
                $file_path2 = "../../imgupload/" . $temp_filename2;
                $image2 = null;

                if ($file_type2 == "image/png") {
                    $image2 = imagecreatefrompng($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } elseif ($file_type2 == "image/gif") {
                    $image2 = imagecreatefromgif($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } else {
                    $image2 = imagecreatefromjpeg($file_path2);
                }

                if ($image2) {
                    $output2 = '../../imgupload/' . $random2 . '-' . $seo . '.webp';
                    $resim2 = $random2 . '-' . $seo . '.webp';
                    imagewebp($image2, $output2, 85);
                    imagedestroy($image2);
                    unlink($file_path2);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkinci resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkinci dosya yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKİNCİ RESİM GÜNCELLEME SONU ---

    // --- İKON GÜNCELLEME BAŞLANGICI (icon) ---
    // Eğer 'icon' adında bir dosya yüklemesi varsa işlem yap
    if (empty($_FILES['icon']['tmp_name'])) {
        // İkon yüklenmediyse mevcut ikonu koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM sertifikat_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $icon = $tenzimleme_qeydi['icon'];
    } else {
        $file_type_icon = $_FILES["icon"]["type"];
        if ($file_type_icon == "image/gif" || $file_type_icon == "image/png" || $file_type_icon == "image/jpg" || $file_type_icon == "image/jpeg") {

            // Eski ikonu sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM sertifikat_kateqoriya WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['icon'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['icon'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['icon']);
            }

            $random_icon = rand(0, 9999999);
            $original_file_extension_icon = pathinfo($_FILES['icon']['name'], PATHINFO_EXTENSION);
            $temp_filename_icon = $random_icon . "-" . $seo . "-icon." . $original_file_extension_icon; // İkon için farklı bir adlandırma

            if (move_uploaded_file($_FILES['icon']['tmp_name'], $klasord . "/" . $temp_filename_icon)) {
                $file_path_icon = "../../imgupload/" . $temp_filename_icon;
                $image_icon = null;

                if ($file_type_icon == "image/png") {
                    $image_icon = imagecreatefrompng($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } elseif ($file_type_icon == "image/gif") {
                    $image_icon = imagecreatefromgif($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } else {
                    $image_icon = imagecreatefromjpeg($file_path_icon);
                }

                if ($image_icon) {
                    $output_icon = '../../imgupload/' . $random_icon . '-' . $seo . '-icon.webp'; // WebP formatında kaydet
                    $icon = $random_icon . '-' . $seo . '-icon.webp'; // Veritabanına kaydedilecek isim
                    imagewebp($image_icon, $output_icon, 85);
                    imagedestroy($image_icon);
                    unlink($file_path_icon); // Geçici dosyayı sil
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkon işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkon dosyası yüklenemedi. Klasör icazelerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> İkon için lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKON GÜNCELLEME SONU ---







    $indi1 = $db->prepare("update sertifikat_kateqoriya set title=:title,description=:description,etiket=:etiket,aciklama2=:aciklama2,resim2=:resim2,lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,guncelleme_tarihi=:guncelleme_tarihi where id=:id");
    $elaveet1 = $indi1->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "adi" => $_POST['adi'], "lan" => $_POST["lan"], "resim2" => $resim2, "aciklama2" => $_POST["aciklama2"], "sira" => $_POST['sira'], "resim" => $resim, "kategori" => $_POST['kategori'], "aciklama" => $_POST['aciklama'], "seo" => $seo, "tur" => $tur, "onaciklama" => $onaciklama, "veziyyeti" => $_POST['veziyyeti'], "guncelleme_tarihi" => $tarih, "id" => $id));
    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['smtp-ayar'])) {

    $elaveet = $db->prepare("update mail set gonderen_mail=:gonderen_mail,site_mail=:site_mail,site_mail_sifre=:site_mail_sifre,site_mail_host=:site_mail_host,site_mail_port=:site_mail_port where id=:id");

    $indi = $elaveet->execute(array("gonderen_mail" => $_POST['gonderen_mail'], "site_mail" => $_POST['site_mail'], "site_mail_sifre" => $_POST['site_mail_sifre'], "site_mail_host" => $_POST['site_mail_host'], "site_mail_port" => $_POST['site_mail_port'], "id" => 1));
    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST['sosyal-medya'])) {

    $elaveet = $db->prepare("update sosialmedia set instagram=:instagram,facebook=:facebook,twitter=:twitter,whatsappp=:whatsappp,telegram=:telegram,linkedin=:linkedin,pinterest=:pinterest,youtube=:youtube where id=:id");

    $indi = $elaveet->execute(array("instagram" => $_POST["instagram"], "facebook" => $_POST["facebook"], "twitter" => $_POST["twitter"], "whatsappp" => $_POST["whatsappp"], "telegram" => $_POST["telegram"], "linkedin" => $_POST["linkedin"], "youtube" => $_POST["youtube"], "pinterest" => $_POST["pinterest"], "id" => 1));
    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST['iletisim-bilgileri'])) {

    $indi = $db->prepare("update elaqemelumatlari set wp_renk=:wp_renk,wp_text=:wp_text,whatsapp=:whatsapp,google_maps=:google_maps,telefon1=:telefon1,telefon2=:telefon2,adres1=:adres1,adres2=:adres2,email1=:email1,email2=:email2 where id=:id");
    $hemen = $indi->execute(array("wp_renk" => $_POST["wp_renk"], "wp_text" => $_POST["wp_text"], "whatsapp" => $_POST['whatsapp'], "google_maps" => $_POST['google_maps'], "telefon1" => $_POST['telefon1'], "telefon2" => $_POST['telefon2'], "adres1" => $_POST['adres1'], "adres2" => $_POST['adres2'], "email1" => $_POST['email1'], "email2" => $_POST['email2'], "id" => 1));




    if ($hemen) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST['paytr-ayar'])) {



    $elaveet = $db->prepare("update paytr set merchand_id=:merchand_id,merchand_key=:merchand_key,merchand_salt=:merchand_salt where id=:id");

    $indi = $elaveet->execute(array("merchand_id" => $_POST['merchand_id'], "merchand_key" => $_POST['merchand_key'], "merchand_salt" => $_POST['merchand_salt'], "id" => 1));
    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=gonderildi');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=gonderilmedi');
    }
}

if (isset($_POST['sehife-elavesi'])) {


    $seo = seflink($_POST['adi']);


    $tur = "sehifeler";

    $klasorbanka = "../../imgupload/"; // Resimlerin yükleneceği klasör

    // --- BİRİNCİ RESİM İŞLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        $resim = "no-img";
    } else {
        $file_type = $_FILES["resim"]["type"];
        // Desteklenen formatları kontrol edin
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            // Geçici dosyayı sunucuya taşı
            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasorbanka . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                // Resim tipine göre farklı imagecreatefrom fonksiyonunu kullanın
                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    // PNG için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    // GIF için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else { // JPG veya JPEG ise
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    // WebP dönüştürme kalitesi: 0 (en düşük) - 100 (en yüksek). Genellikle 80-90 arası iyidir.
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path); // Geçici orijinal dosyayı silin
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM İŞLEME SONU ---


    $indi = $db->prepare("insert into sehifeler set title=:title,description=:description,etiket=:etiket,lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,eklenme_tarihi=:eklenme_tarihi");
    $elaveet = $indi->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "adi" => $_POST["adi"], "lan" => $_POST["lan"], "sira" => $_POST["sira"], "resim" => $resim, "kategori" => $kategori, "aciklama" => $_POST["aciklama"], "seo" => $seo, "tur" => $tur, "onaciklama" => $_POST["onaciklama"], "veziyyeti" => $_POST["veziyyeti"], "eklenme_tarihi" => $tarih));



    if ($elaveet) {

        $sonid = $db->query("select * from sehifeler order by id desc")->fetch(PDO::FETCH_ASSOC);

        $yeni = $sonid['id'];
        if (isset($_POST['img'])) {
            foreach ($_POST['img'] as $img) {
                $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?, tur=?");
                $islem = $islem->execute(array($yeni, $img, $tur));
            }
        }


        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}



if (isset($_POST['sehife-yenile'])) {


    $seo = seflink($_POST['adi']);


    $tur = "sehifeler";

    $id = $_POST['id'];

    $klasord = "../../imgupload/";

    // --- BİRİNCİ RESİM GÜNCELLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        // Resim yüklenmediyse mevcut resmi koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM sehifeler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        $file_type = $_FILES["resim"]["type"];
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            // Eski resmi sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM sehifeler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['resim'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else {
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM GÜNCELLEME SONU ---

    $deleteee = $db->exec("DELETE FROM urun_img WHERE urun_id = '$id' ");

    if (isset($_POST['img'])) {
        foreach ($_POST['img'] as $img) {
            $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?,tur=?");
            $islem = $islem->execute(array($id, $img, $tur));
        }
    }




    $indi1 = $db->prepare("update sehifeler set title=:title,etiket=:etiket,description=:description,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,guncelleme_tarihi=:guncelleme_tarihi where id=:id");
    $elaveet1 = $indi1->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "etiket" => $_POST["etiket"], "adi" => $_POST["adi"], "sira" => $_POST["sira"], "resim" => $resim, "kategori" => $_POST["kategori"], "aciklama" => $_POST["aciklama"], "seo" => $seo, "tur" => $tur, "onaciklama" => $_POST["onaciklama"], "veziyyeti" => $_POST["veziyyeti"], "guncelleme_tarihi" => $tarih, "id" => $id));

    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}




if (isset($_POST['beadcrumb-duzenle'])) {
    $seo = seflink($_POST['adi']);
    $tur = "sehifeler";
    $id = $_POST['id'];
    $klasor = "../../imgupload/";

    // resim alanı için
    $resim_tmp = $_FILES['resim']['tmp_name'];

    if (empty($resim_tmp)) {
        // Eğer yeni resim yüklenmediyse, mevcut resim adını veritabanından çek
        $tenzimleme_qeydi = $db->query("SELECT * FROM beadcrumb WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        $file_type = $_FILES["resim"]["type"];
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {
            $tenzimleme_qeydi = $db->query("SELECT * FROM beadcrumb WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
            // Eski resmi silmeden önce var olup olmadığını kontrol et
            if ($tenzimleme_qeydi['resim'] != "no-img" && file_exists($klasor . $tenzimleme_qeydi['resim'])) {
                unlink($klasor . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 999);
            $file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            // Geçici dosya adı oluşturma, $seo değişkenini kullanabiliriz
            $temp_file_name = $random . "-" . $seo . "." . $file_extension;

            // Yüklenen dosyayı geçici olarak kaydet
            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasor . "/" . $temp_file_name)) {
                $source_file = $klasor . "/" . $temp_file_name;

                // Resim tipine göre farklı fonksiyonlar kullanarak resmi yükle
                $image = false; // Başlangıçta false olarak ayarla
                if ($file_type == "image/jpeg" || $file_type == "image/jpg") {
                    $image = imagecreatefromjpeg($source_file);
                } elseif ($file_type == "image/png") {
                    $image = imagecreatefrompng($source_file);
                    // PNG transparanlığını korumak için
                    imagepalettetotruecolor($image);
                    imagealphablending($image, true);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($source_file);
                }

                if ($image) {
                    $output_file = $klasor . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp'; // Veritabanına kaydedilecek dosya adı

                    // Resmi WebP formatına dönüştür ve kaydet
                    imagewebp($image, $output_file, 80); // Kaliteyi 80 olarak ayarladım

                    imagedestroy($image); // Orjinal image objesini temizle

                    // Geçici orijinal dosyayı sil
                    unlink($source_file);
                } else {
                    $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Desteklenmeyen resim formatı veya resim yüklenemedi.
                    </div>';
                    $resim = $tenzimleme_qeydi['resim']; // Hata veziyyetinda eski resmi koru
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya sunucuya taşınamadı.
                    </div>';
                $resim = $tenzimleme_qeydi['resim']; // Hata durumunda eski resmi koru
            }
        } else {
            $bilgi = '<div class="alert alert-error">
            <button class="close" data-dismiss="alert">×</button>
            <strong>Hata !</strong> Lütfen uygun formatta bir resim dosyası seçiniz ( .jpg - .gif - .png ).
            </div>';
            $resim = $tenzimleme_qeydi['resim']; // Hata durumunda eski resmi koru
        }
    }


    // footersekli alanı için
    $resim_tmp2 = $_FILES['footersekli']['tmp_name'];

    if (empty($resim_tmp2)) {
        $tenzimleme_qeydi = $db->query("SELECT * FROM beadcrumb WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
        $footersekli = $tenzimleme_qeydi['footersekli'];
    } else {
        $file_type2 = $_FILES["footersekli"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {
            $tenzimleme_qeydi = $db->query("SELECT * FROM beadcrumb WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['footersekli'] != "no-img" && file_exists($klasor . $tenzimleme_qeydi['footersekli'])) {
                unlink($klasor . $tenzimleme_qeydi['footersekli']);
            }

            $random = rand(0, 999);
            $file_extension2 = pathinfo($_FILES['footersekli']['name'], PATHINFO_EXTENSION);
            $temp_file_name2 = $random . "-" . $seo . "_2." . $file_extension2;

            if (move_uploaded_file($_FILES['footersekli']['tmp_name'], $klasor . "/" . $temp_file_name2)) {
                $source_file2 = $klasor . "/" . $temp_file_name2;

                $image2 = false;
                if ($file_type2 == "image/jpeg" || $file_type2 == "image/jpg") {
                    $image2 = imagecreatefromjpeg($source_file2);
                } elseif ($file_type2 == "image/png") {
                    $image2 = imagecreatefrompng($source_file2);
                    imagepalettetotruecolor($image2);
                    imagealphablending($image2, true);
                    imagesavealpha($image2, true);
                } elseif ($file_type2 == "image/gif") {
                    $image2 = imagecreatefromgif($source_file2);
                }

                if ($image2) {
                    $output_file2 = $klasor . $random . '-' . $seo . '_2.webp';
                    $footersekli = $random . '-' . $seo . '_2.webp';
                    imagewebp($image2, $output_file2, 80);
                    imagedestroy($image2);
                    unlink($source_file2);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Desteklenmeyen resim formatı veya resim yüklenemedi.
                        </div>';
                    $footersekli = $tenzimleme_qeydi['footersekli'];
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya sunucuya taşınamadı.
                    </div>';
                $footersekli = $tenzimleme_qeydi['footersekli'];
            }
        } else {
            $bilgi = '<div class="alert alert-error">
            <button class="close" data-dismiss="alert">×</button>
            <strong>Hata !</strong> Lütfen uygun formatte bir resim dosyası seçiniz ( .jpg - .gif - .png ).
            </div>';
            $footersekli = $tenzimleme_qeydi['footersekli'];
        }
    }


    // reybolmesekli alanı için
    $resim_tmp3 = $_FILES['reybolmesekli']['tmp_name'];

    if (empty($resim_tmp3)) {
        $tenzimleme_qeydi = $db->query("SELECT * FROM beadcrumb WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
        $reybolmesekli = $tenzimleme_qeydi['reybolmesekli'];
    } else {
        $file_type3 = $_FILES["reybolmesekli"]["type"];
        if ($file_type3 == "image/gif" || $file_type3 == "image/png" || $file_type3 == "image/jpg" || $file_type3 == "image/jpeg") {
            $tenzimleme_qeydi = $db->query("SELECT * FROM beadcrumb WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['reybolmesekli'] != "no-img" && file_exists($klasor . $tenzimleme_qeydi['reybolmesekli'])) {
                unlink($klasor . $tenzimleme_qeydi['reybolmesekli']);
            }

            $random = rand(0, 999);
            $file_extension3 = pathinfo($_FILES['reybolmesekli']['name'], PATHINFO_EXTENSION);
            $temp_file_name3 = $random . "-" . $seo . "_3." . $file_extension3;

            if (move_uploaded_file($_FILES['reybolmesekli']['tmp_name'], $klasor . "/" . $temp_file_name3)) {
                $source_file3 = $klasor . "/" . $temp_file_name3;

                $image3 = false;
                if ($file_type3 == "image/jpeg" || $file_type3 == "image/jpg") {
                    $image3 = imagecreatefromjpeg($source_file3);
                } elseif ($file_type3 == "image/png") {
                    $image3 = imagecreatefrompng($source_file3);
                    imagepalettetotruecolor($image3);
                    imagealphablending($image3, true);
                    imagesavealpha($image3, true);
                } elseif ($file_type3 == "image/gif") {
                    $image3 = imagecreatefromgif($source_file3);
                }

                if ($image3) {
                    $output_file3 = $klasor . $random . '-' . $seo . '_3.webp';
                    $reybolmesekli = $random . '-' . $seo . '_3.webp';
                    imagewebp($image3, $output_file3, 80);
                    imagedestroy($image3);
                    unlink($source_file3);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Desteklenmeyen resim formatı veya resim yüklenemedi.
                        </div>';
                    $reybolmesekli = $tenzimleme_qeydi['reybolmesekli'];
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya sunucuya taşınamadı.
                    </div>';
                $reybolmesekli = $tenzimleme_qeydi['reybolmesekli'];
            }
        } else {
            $bilgi = '<div class="alert alert-error">
            <button class="close" data-dismiss="alert">×</button>
            <strong>Hata !</strong> Lütfen uygun formatta bir resim dosyası seçiniz ( .jpg - .gif - .png ).
            </div>';
            $reybolmesekli = $tenzimleme_qeydi['reybolmesekli'];
        }
    }

    // xidmetbolmesekli alanı için
    $resim_tmp4 = $_FILES['xidmetbolmesekli']['tmp_name'];

    if (empty($resim_tmp4)) {
        $tenzimleme_qeydi = $db->query("SELECT * FROM beadcrumb WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
        $xidmetbolmesekli = $tenzimleme_qeydi['xidmetbolmesekli'];
    } else {
        $file_type4 = $_FILES["xidmetbolmesekli"]["type"];
        if ($file_type4 == "image/gif" || $file_type4 == "image/png" || $file_type4 == "image/jpg" || $file_type4 == "image/jpeg") {
            $tenzimleme_qeydi = $db->query("SELECT * FROM beadcrumb WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['xidmetbolmesekli'] != "no-img" && file_exists($klasor . $tenzimleme_qeydi['xidmetbolmesekli'])) {
                unlink($klasor . $tenzimleme_qeydi['xidmetbolmesekli']);
            }

            $random = rand(0, 999);
            $file_extension4 = pathinfo($_FILES['xidmetbolmesekli']['name'], PATHINFO_EXTENSION);
            $temp_file_name4 = $random . "-" . $seo . "_4." . $file_extension4;

            if (move_uploaded_file($_FILES['xidmetbolmesekli']['tmp_name'], $klasor . "/" . $temp_file_name4)) {
                $source_file4 = $klasor . "/" . $temp_file_name4;

                $image4 = false;
                if ($file_type4 == "image/jpeg" || $file_type4 == "image/jpg") {
                    $image4 = imagecreatefromjpeg($source_file4);
                } elseif ($file_type4 == "image/png") {
                    $image4 = imagecreatefrompng($source_file4);
                    imagepalettetotruecolor($image4);
                    imagealphablending($image4, true);
                    imagesavealpha($image4, true);
                } elseif ($file_type4 == "image/gif") {
                    $image4 = imagecreatefromgif($source_file4);
                }

                if ($image4) {
                    $output_file4 = $klasor . $random . '-' . $seo . '_4.webp';
                    $xidmetbolmesekli = $random . '-' . $seo . '_4.webp';
                    imagewebp($image4, $output_file4, 80);
                    imagedestroy($image4);
                    unlink($source_file4);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Desteklenmeyen resim formatı veya resim yüklenemedi.
                        </div>';
                    $xidmetbolmesekli = $tenzimleme_qeydi['xidmetbolmesekli'];
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya sunucuya taşınamadı.
                    </div>';
                $xidmetbolmesekli = $tenzimleme_qeydi['xidmetbolmesekli'];
            }
        } else {
            $bilgi = '<div class="alert alert-error">
            <button class="close" data-dismiss="alert">×</button>
            <strong>Hata !</strong> Lütfen uygun formatta bir resim dosyası seçiniz ( .jpg - .gif - .png ).
            </div>';
            $xidmetbolmesekli = $tenzimleme_qeydi['xidmetbolmesekli'];
        }
    }

    // --- sualcavabbolmesekli alanı için yeni eklenen kod ---
    $resim_tmp5 = $_FILES['sualcavabbolmesekli']['tmp_name'];

    if (empty($resim_tmp5)) {
        $tenzimleme_qeydi = $db->query("SELECT * FROM beadcrumb WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
        $sualcavabbolmesekli = $tenzimleme_qeydi['sualcavabbolmesekli'];
    } else {
        $file_type5 = $_FILES["sualcavabbolmesekli"]["type"];
        if ($file_type5 == "image/gif" || $file_type5 == "image/png" || $file_type5 == "image/jpg" || $file_type5 == "image/jpeg") {
            $tenzimleme_qeydi = $db->query("SELECT * FROM beadcrumb WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['sualcavabbolmesekli'] != "no-img" && file_exists($klasor . $tenzimleme_qeydi['sualcavabbolmesekli'])) {
                unlink($klasor . $tenzimleme_qeydi['sualcavabbolmesekli']);
            }

            $random = rand(0, 999);
            $file_extension5 = pathinfo($_FILES['sualcavabbolmesekli']['name'], PATHINFO_EXTENSION);
            $temp_file_name5 = $random . "-" . $seo . "_5." . $file_extension5;

            if (move_uploaded_file($_FILES['sualcavabbolmesekli']['tmp_name'], $klasor . "/" . $temp_file_name5)) {
                $source_file5 = $klasor . "/" . $temp_file_name5;

                $image5 = false;
                if ($file_type5 == "image/jpeg" || $file_type5 == "image/jpg") {
                    $image5 = imagecreatefromjpeg($source_file5);
                } elseif ($file_type5 == "image/png") {
                    $image5 = imagecreatefrompng($source_file5);
                    imagepalettetotruecolor($image5);
                    imagealphablending($image5, true);
                    imagesavealpha($image5, true);
                } elseif ($file_type5 == "image/gif") {
                    $image5 = imagecreatefromgif($source_file5);
                }

                if ($image5) {
                    $output_file5 = $klasor . $random . '-' . $seo . '_5.webp';
                    $sualcavabbolmesekli = $random . '-' . $seo . '_5.webp';
                    imagewebp($image5, $output_file5, 80);
                    imagedestroy($image5);
                    unlink($source_file5);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Desteklenmeyen resim formatı veya resim yüklenemedi.
                        </div>';
                    $sualcavabbolmesekli = $tenzimleme_qeydi['sualcavabbolmesekli'];
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya sunucuya taşınamadı.
                    </div>';
                $sualcavabbolmesekli = $tenzimleme_qeydi['sualcavabbolmesekli'];
            }
        } else {
            $bilgi = '<div class="alert alert-error">
            <button class="close" data-dismiss="alert">×</button>
            <strong>Hata !</strong> Lütfen uygun formatta bir resim dosyası seçiniz ( .jpg - .gif - .png ).
            </div>';
            $sualcavabbolmesekli = $tenzimleme_qeydi['sualcavabbolmesekli'];
        }
    }
    // --- sualcavabbolmesekli alanı için yeni eklenen kod sonu ---

    // --- statistikabolmesekli alanı için yeni eklenen kod ---
    $resim_tmp6 = $_FILES['statistikabolmesekli']['tmp_name'];

    if (empty($resim_tmp6)) {
        $tenzimleme_qeydi = $db->query("SELECT * FROM beadcrumb WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
        $statistikabolmesekli = $tenzimleme_qeydi['statistikabolmesekli'];
    } else {
        $file_type6 = $_FILES["statistikabolmesekli"]["type"];
        if ($file_type6 == "image/gif" || $file_type6 == "image/png" || $file_type6 == "image/jpg" || $file_type6 == "image/jpeg") {
            $tenzimleme_qeydi = $db->query("SELECT * FROM beadcrumb WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['statistikabolmesekli'] != "no-img" && file_exists($klasor . $tenzimleme_qeydi['statistikabolmesekli'])) {
                unlink($klasor . $tenzimleme_qeydi['statistikabolmesekli']);
            }

            $random = rand(0, 999);
            $file_extension6 = pathinfo($_FILES['statistikabolmesekli']['name'], PATHINFO_EXTENSION);
            $temp_file_name6 = $random . "-" . $seo . "_6." . $file_extension6;

            if (move_uploaded_file($_FILES['statistikabolmesekli']['tmp_name'], $klasor . "/" . $temp_file_name6)) {
                $source_file6 = $klasor . "/" . $temp_file_name6;

                $image6 = false;
                if ($file_type6 == "image/jpeg" || $file_type6 == "image/jpg") {
                    $image6 = imagecreatefromjpeg($source_file6);
                } elseif ($file_type6 == "image/png") {
                    $image6 = imagecreatefrompng($source_file6);
                    imagepalettetotruecolor($image6);
                    imagealphablending($image6, true);
                    imagesavealpha($image6, true);
                } elseif ($file_type6 == "image/gif") {
                    $image6 = imagecreatefromgif($source_file6);
                }

                if ($image6) {
                    $output_file6 = $klasor . $random . '-' . $seo . '_6.webp';
                    $statistikabolmesekli = $random . '-' . $seo . '_6.webp';
                    imagewebp($image6, $output_file6, 80);
                    imagedestroy($image6);
                    unlink($source_file6);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Desteklenmeyen resim formatı veya resim yüklenemedi.
                        </div>';
                    $statistikabolmesekli = $tenzimleme_qeydi['statistikabolmesekli'];
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya sunucuya taşınamadı.
                    </div>';
                $statistikabolmesekli = $tenzimleme_qeydi['statistikabolmesekli'];
            }
        } else {
            $bilgi = '<div class="alert alert-error">
            <button class="close" data-dismiss="alert">×</button>
            <strong>Hata !</strong> Lütfen uygun formatta bir resim dosyası seçiniz ( .jpg - .gif - .png ).
            </div>';
            $statistikabolmesekli = $tenzimleme_qeydi['statistikabolmesekli'];
        }
    }
    // --- statistikabolmesekli alanı için yeni eklenen kod sonu ---


    $indi1 = $db->prepare("update beadcrumb set reybolmesekli=:reybolmesekli,footersekli=:footersekli,xidmetbolmesekli=:xidmetbolmesekli,statistikabolmesekli=:statistikabolmesekli,sualcavabbolmesekli=:sualcavabbolmesekli,adi=:adi,resim=:resim,veziyyeti=:veziyyeti where id=:id");
    $elaveet1 = $indi1->execute(array("adi" => $_POST["adi"], "resim" => $resim, "footersekli" => $footersekli, "reybolmesekli" => $reybolmesekli, "statistikabolmesekli" => $statistikabolmesekli, "xidmetbolmesekli" => $xidmetbolmesekli, "sualcavabbolmesekli" => $sualcavabbolmesekli, "veziyyeti" => $_POST["veziyyeti"], "id" => 1));

    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}



if (isset($_POST['haqqimizda-duzelis'])) {

    $seo = seflink($_POST['adi']);

    $id = $_POST['id'];

    $klasor = "../../imgupload/";

    $resim_tmpc = $_FILES['hresim']['tmp_name'];
    $resim_tmpc2 = $_FILES['hresim2']['tmp_name'];

    // hresim işleme
    if (empty($resim_tmpc)) {
        $tenzimleme_qeydi = $db->query("SELECT * FROM haqqimizda WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        $file_type = $_FILES["hresim"]["type"];
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM haqqimizda WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img" && file_exists($klasor . $tenzimleme_qeydi['resim'])) { // Dosya varlığını kontrol et
                unlink($klasor . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 999);
            $file_extension = pathinfo($_FILES['hresim']['name'], PATHINFO_EXTENSION);
            $temp_file_name = $random . "-" . $seo . "." . $file_extension;

            move_uploaded_file($_FILES['hresim']['tmp_name'], $klasor . "/" . $temp_file_name);

            $source_file = $klasor . "/" . $temp_file_name;

            // Resim tipine göre farklı fonksiyonlar kullanarak resmi yükle
            if ($file_type == "image/jpeg" || $file_type == "image/jpg") {
                $image = imagecreatefromjpeg($source_file);
            } elseif ($file_type == "image/png") {
                $image = imagecreatefrompng($source_file);
                // PNG transparanlığını korumak için
                imagepalettetotruecolor($image);
                imagealphablending($image, true);
                imagesavealpha($image, true);
            } elseif ($file_type == "image/gif") {
                $image = imagecreatefromgif($source_file);
            } else {
                $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Desteklenmeyen resim formatı.
                </div>';
                $image = false;
            }

            if ($image) {
                $output_file = $klasor . $random . '-' . $seo . '.webp';
                $resim = $random . '-' . $seo . '.webp';
                imagewebp($image, $output_file, 80); // Kaliteyi 80 olarak ayarladım
                imagedestroy($image);
                unlink($source_file); // Geçici orijinal dosyayı sil
            }
        } else {
            $bilgi = '<div class="alert alert-error">
            <button class="close" data-dismiss="alert">×</button>
            <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
            </div>';
        }
    }

    // hresim2 işleme
    if (empty($resim_tmpc2)) {
        $tenzimleme_qeydi = $db->query("SELECT * FROM haqqimizda WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
        $resim2 = $tenzimleme_qeydi['resim2'];
    } else {
        $file_type2 = $_FILES["hresim2"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM haqqimizda WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim2'] != "no-img" && file_exists($klasor . $tenzimleme_qeydi['resim2'])) { // Dosya varlığını kontrol et
                unlink($klasor . $tenzimleme_qeydi['resim2']);
            }

            $random2 = rand(0, 999);
            $file_extension2 = pathinfo($_FILES['hresim2']['name'], PATHINFO_EXTENSION);
            $temp_file_name2 = $random2 . "-" . $seo . "_2." . $file_extension2; // _2 ekledim çakışmaması için

            move_uploaded_file($_FILES['hresim2']['tmp_name'], $klasor . "/" . $temp_file_name2);

            $source_file2 = $klasor . "/" . $temp_file_name2;

            if ($file_type2 == "image/jpeg" || $file_type2 == "image/jpg") {
                $image2 = imagecreatefromjpeg($source_file2);
            } elseif ($file_type2 == "image/png") {
                $image2 = imagecreatefrompng($source_file2);
                imagepalettetotruecolor($image2);
                imagealphablending($image2, true);
                imagesavealpha($image2, true);
            } elseif ($file_type2 == "image/gif") {
                $image2 = imagecreatefromgif($source_file2);
            } else {
                $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Desteklenmeyen resim formatı.
                </div>';
                $image2 = false;
            }

            if ($image2) {
                $output_file2 = $klasor . $random2 . '-' . $seo . '_2.webp'; // _2 ekledim çakışmaması için
                $resim2 = $random2 . '-' . $seo . '_2.webp';
                imagewebp($image2, $output_file2, 80);
                imagedestroy($image2);
                unlink($source_file2);
            }
        } else {
            $bilgi = '<div class="alert alert-error">
            <button class="close" data-dismiss="alert">×</button>
            <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
            </div>';
        }
    }

    // Məlumat bazasını yeniləyirik
    $indi1 = $db->prepare("UPDATE haqqimizda SET footer=:footer, video=:video, aciklama=:aciklama, adi=:adi, resim=:resim, resim2=:resim2, veziyyeti=:veziyyeti WHERE id=:id");
    $elaveet1 = $indi1->execute(array(
        "footer" => $_POST["footer"],
        "video" => $_POST["video"],
        "aciklama" => $_POST["aciklama"],
        "adi" => $_POST["adi"],
        "resim" => $resim,
        "resim2" => $resim2,
        "veziyyeti" => $_POST["veziyyeti"],
        "id" => 1
    ));

    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST['modal-duzenle'])) {

    $seo = seflink($_POST['adi']);


    $tur = "sehifeler";

    $id = $_POST['id'];

    $klasor = "../../imgupload/";

    $resim_tmp = $_FILES['resim']['tmp_name'];

    if (empty($resim_tmp)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM modal WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM modal WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img") {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 999);

            $resim1 = $random . "-" . 'modal' . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasor . "/" . $resim1);



            $file = "../../imgupload/" . $resim1;
            $image = imagecreatefromstring(file_get_contents($file));
            ob_start();
            imagejpeg($image, NULL, 100);
            $cont = ob_get_contents();
            ob_end_clean();
            $randomm = rand(0, 965465465465456);
            imagedestroy($image);
            $content = imagecreatefromstring($cont);
            $output = '../../imgupload/' . $random . '-' . 'modal' . '.webp';
            $resim = $random . '-' . 'modal' . '.webp';
            imagewebp($content, $output);
            imagedestroy($content);
            unlink('../../imgupload/' . $resim1);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }








    $indi1 = $db->prepare("update modal set adi=:adi,resim=:resim,veziyyeti=:veziyyeti where id=:id");
    $elaveet1 = $indi1->execute(array("adi" => $_POST["adi"], "resim" => $resim, "veziyyeti" => $_POST["veziyyeti"], "id" => 1));

    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['xeber-elavesi'])) {

    $seo = seflink($_POST['adi']);


    $tur = "xeberler";

    $klasorbanka = "../../imgupload/"; // Resimlerin yükleneceği klasör
    $tarih = date('Y-m-d H:i:s');
    
    $sira_degeri = 1;
    if (isset($_POST['sira']) && $_POST['sira'] !== '') {
        $sira_degeri = intval($_POST['sira']);
    } else {
        // Formdan sıra gelmediyse, veritabanındaki en yüksek değeri bul
        $son_sira_sorgu = $db->query("SELECT MAX(sira) AS max_sira FROM mehsullar");
        $sonuc = $son_sira_sorgu->fetch(PDO::FETCH_ASSOC);
        if ($sonuc && isset($sonuc['max_sira'])) {
            $sira_degeri = $sonuc['max_sira'] + 1;
        }
    }

    // --- BİRİNCİ RESİM İŞLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        $resim = "no-img";
    } else {
        $file_type = $_FILES["resim"]["type"];
        // Desteklenen formatları kontrol edin
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            // Geçici dosyayı sunucuya taşı
            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasorbanka . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                // Resim tipine göre farklı imagecreatefrom fonksiyonunu kullanın
                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    // PNG için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    // GIF için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else { // JPG veya JPEG ise
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    // WebP dönüştürme kalitesi: 0 (en düşük) - 100 (en yüksek). Genellikle 80-90 arası iyidir.
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path); // Geçici orijinal dosyayı silin
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM İŞLEME SONU ---

    // --- İKİNCİ RESİM İŞLEME BAŞLANGICI (resim2) ---
    if (empty($_FILES['sehifesekli']['tmp_name'])) {
        $sehifesekli = "no-img";
    } else {
        $file_type2 = $_FILES["sehifesekli"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {

            $random2 = rand(0, 9999999);
            $original_file_extension2 = pathinfo($_FILES['sehifesekli']['name'], PATHINFO_EXTENSION);
            $temp_filename2 = $random2 . "-" . $seo . "." . $original_file_extension2;

            if (move_uploaded_file($_FILES['sehifesekli']['tmp_name'], $klasorbanka . "/" . $temp_filename2)) {
                $file_path2 = "../../imgupload/" . $temp_filename2;
                $image2 = null;

                if ($file_type2 == "image/png") {
                    $image2 = imagecreatefrompng($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } elseif ($file_type2 == "image/gif") {
                    $image2 = imagecreatefromgif($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } else {
                    $image2 = imagecreatefromjpeg($file_path2);
                }

                if ($image2) {
                    $output2 = '../../imgupload/' . $random2 . '-' . $seo . '.webp';
                    $sehifesekli = $random2 . '-' . $seo . '.webp';
                    imagewebp($image2, $output2, 85);
                    imagedestroy($image2);
                    unlink($file_path2);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkinci resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkinci dosya yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }

    // --- İKON İŞLEME BAŞLANGICI (icon) ---
    // İkon yükleme alanı boşsa "no-img" ata
    if (empty($_FILES['icon']['tmp_name'])) {
        $icon = "no-img";
    } else {
        $file_type_icon = $_FILES["icon"]["type"];
        if ($file_type_icon == "image/gif" || $file_type_icon == "image/png" || $file_type_icon == "image/jpg" || $file_type_icon == "image/jpeg") {

            $random_icon = rand(0, 9999999);
            $original_file_extension_icon = pathinfo($_FILES['icon']['name'], PATHINFO_EXTENSION);
            $temp_filename_icon = $random_icon . "-" . $seo . "-icon." . $original_file_extension_icon; // İkon için farklı bir adlandırma

            if (move_uploaded_file($_FILES['icon']['tmp_name'], $klasorbanka . "/" . $temp_filename_icon)) {
                $file_path_icon = "../../imgupload/" . $temp_filename_icon;
                $image_icon = null;

                if ($file_type_icon == "image/png") {
                    $image_icon = imagecreatefrompng($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } elseif ($file_type_icon == "image/gif") {
                    $image_icon = imagecreatefromgif($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } else {
                    $image_icon = imagecreatefromjpeg($file_path_icon);
                }

                if ($image_icon) {
                    $output_icon = '../../imgupload/' . $random_icon . '-' . $seo . '-icon.webp'; // WebP formatında kaydet
                    $icon = $random_icon . '-' . $seo . '-icon.webp'; // Veritabanına kaydedilecek isim
                    imagewebp($image_icon, $output_icon, 85);
                    imagedestroy($image_icon);
                    unlink($file_path_icon); // Geçici dosyayı sil
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkon işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkon dosyası yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> İkon için lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKON İŞLEME SONU ---

    $indi = $db->prepare("insert into xeberler set title=:title,sehifesekli=:sehifesekli,description=:description,etiket=:etiket,meta_title=:meta_title,meta_des=:meta_des,meta_key=:meta_key,lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,linki=:linki,seo=:seo,tur=:tur,eklenme_tarihi=:eklenme_tarihi");
    $elaveet = $indi->execute(array("title" => $_POST["title"], "description" => $_POST["description"], "lan" => $_POST["lan"], "adi" => $_POST["adi"], "etiket" => $_POST["etiket"], "meta_title" => $_POST["meta_title"], "meta_des" => $_POST["meta_des"], "meta_key" => $_POST["meta_key"], "sira" => $sira_degeri, "linki" => $_POST["linki"], "resim" => $resim, "sehifesekli" => $sehifesekli, "kategori" => $kategori, "aciklama" => $_POST["aciklama"], "seo" => $seo, "tur" => $tur, "onaciklama" => $_POST["onaciklama"], "veziyyeti" => $_POST["veziyyeti"], "eklenme_tarihi" => $tarih));



    if ($elaveet) {

        $sonid = $db->query("select * from xeberler order by id desc")->fetch(PDO::FETCH_ASSOC);

        $yeni = $sonid['id'];
        if (isset($_POST['img'])) {
            foreach ($_POST['img'] as $img) {
                $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?, tur=?");
                $islem = $islem->execute(array($yeni, $img, $tur));
            }
        }


        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}



if (isset($_POST['xeber-yenille'])) {

    // seflink fonksiyonu, kod tekrarını önlemek için genellikle bu bloğun dışında veya ayrı bir dosyada tanımlanır.
    // Ancak, sizden tam kodu istediğiniz için burada tekrar veriyorum.
    // Daha iyi bir yapı için bu fonksiyonu dosyanın başında bir kez tanımlamanızı şiddetle tavsiye ederim.


    $seo = seflink($_POST['adi']); // Resim adı ve SEO için kullanılacak değişken
    $tur = "xeberler"; // Kategori veya tür bilgisi
    $id = $_POST['id']; // Güncellenecek haberin ID'si
    $klasord = "../../imgupload/";

    // --- BİRİNCİ RESİM GÜNCELLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        // Resim yüklenmediyse mevcut resmi koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM xeberler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        $file_type = $_FILES["resim"]["type"];
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            // Eski resmi sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM xeberler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['resim'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else {
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM GÜNCELLEME SONU ---

    // --- İKİNCİ RESİM GÜNCELLEME BAŞLANGICI (resim2) ---
    if (empty($_FILES['sehifesekli']['tmp_name'])) {
        // Resim yüklenmediyse mevcut resmi koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM xeberler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $sehifesekli = $tenzimleme_qeydi['sehifesekli'];
    } else {
        $file_type2 = $_FILES["sehifesekli"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {

            // Eski resmi sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM xeberler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['sehifesekli'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['sehifesekli'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['sehifesekli']);
            }

            $random2 = rand(0, 9999999);
            $original_file_extension2 = pathinfo($_FILES['sehifesekli']['name'], PATHINFO_EXTENSION);
            $temp_filename2 = $random2 . "-" . $seo . "." . $original_file_extension2;

            if (move_uploaded_file($_FILES['sehifesekli']['tmp_name'], $klasord . "/" . $temp_filename2)) {
                $file_path2 = "../../imgupload/" . $temp_filename2;
                $image2 = null;

                if ($file_type2 == "image/png") {
                    $image2 = imagecreatefrompng($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } elseif ($file_type2 == "image/gif") {
                    $image2 = imagecreatefromgif($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } else {
                    $image2 = imagecreatefromjpeg($file_path2);
                }

                if ($image2) {
                    $output2 = '../../imgupload/' . $random2 . '-' . $seo . '.webp';
                    $sehifesekli = $random2 . '-' . $seo . '.webp';
                    imagewebp($image2, $output2, 85);
                    imagedestroy($image2);
                    unlink($file_path2);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkinci resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkinci dosya yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKİNCİ RESİM GÜNCELLEME SONU ---

    // --- İKON GÜNCELLEME BAŞLANGICI (icon) ---
    // Eğer 'icon' adında bir dosya yüklemesi varsa işlem yap
    if (empty($_FILES['icon']['tmp_name'])) {
        // İkon yüklenmediyse mevcut ikonu koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM xeberler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $icon = $tenzimleme_qeydi['icon'];
    } else {
        $file_type_icon = $_FILES["icon"]["type"];
        if ($file_type_icon == "image/gif" || $file_type_icon == "image/png" || $file_type_icon == "image/jpg" || $file_type_icon == "image/jpeg") {

            // Eski ikonu sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM xeberler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['icon'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['icon'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['icon']);
            }

            $random_icon = rand(0, 9999999);
            $original_file_extension_icon = pathinfo($_FILES['icon']['name'], PATHINFO_EXTENSION);
            $temp_filename_icon = $random_icon . "-" . $seo . "-icon." . $original_file_extension_icon; // İkon için farklı bir adlandırma

            if (move_uploaded_file($_FILES['icon']['tmp_name'], $klasord . "/" . $temp_filename_icon)) {
                $file_path_icon = "../../imgupload/" . $temp_filename_icon;
                $image_icon = null;

                if ($file_type_icon == "image/png") {
                    $image_icon = imagecreatefrompng($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } elseif ($file_type_icon == "image/gif") {
                    $image_icon = imagecreatefromgif($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } else {
                    $image_icon = imagecreatefromjpeg($file_path_icon);
                }

                if ($image_icon) {
                    $output_icon = '../../imgupload/' . $random_icon . '-' . $seo . '-icon.webp'; // WebP formatında kaydet
                    $icon = $random_icon . '-' . $seo . '-icon.webp'; // Veritabanına kaydedilecek isim
                    imagewebp($image_icon, $output_icon, 85);
                    imagedestroy($image_icon);
                    unlink($file_path_icon); // Geçici dosyayı sil
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkon işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkon dosyası yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> İkon için lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKON GÜNCELLEME SONU ---


    $deleteee = $db->exec("DELETE FROM urun_img WHERE urun_id = '$id' ");

    if (isset($_POST['img'])) {
        foreach ($_POST['img'] as $img) {
            $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?,tur=?");
            $islem = $islem->execute(array($id, $img, $tur));
        }
    }

    // Ana haber bilgilerini güncelle
    $indi1 = $db->prepare("UPDATE xeberler SET
        title=:title,
        description=:description,
        etiket=:etiket,
        meta_title=:meta_title,
        meta_des=:meta_des,
        meta_key=:meta_key,
        lan=:lan,
        adi=:adi,
        sira=:sira,
        linki=:linki,
        resim=:resim,
        sehifesekli=:sehifesekli,
        kategori=:kategori,
        veziyyeti=:veziyyeti,
        onaciklama=:onaciklama,
        aciklama=:aciklama,
        seo=:seo,
        tur=:tur,
        guncelleme_tarihi=:guncelleme_tarihi
        WHERE id=:id");

    $elaveet1 = $indi1->execute(array(
        "title" => $_POST["title"],
        "description" => $_POST["description"],
        "adi" => $_POST["adi"],
        "etiket" => $_POST["etiket"],
        "meta_title" => $_POST["meta_title"],
        "meta_des" => $_POST["meta_des"],
        "meta_key" => $_POST["meta_key"],
        "lan" => $_POST["lan"],
        "sira" => $_POST["sira"],
        "linki" => $_POST["linki"],
        "resim" => $resim,
        "sehifesekli" => $sehifesekli, // Güncellenen resim adı
        "kategori" => $_POST["kategori"],
        "aciklama" => $_POST["aciklama"],
        "seo" => $seo,
        "tur" => $tur,
        "onaciklama" => $_POST["onaciklama"],
        "veziyyeti" => $_POST["veziyyeti"],
        "guncelleme_tarihi" => $tarih,
        "id" => $id
    ));

    // Güncelleme başarılıysa yönlendir, değilse hata mesajı ile yönlendir
    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
        exit(); // Yönlendirme sonrası betiğin çalışmasını durdur
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
        exit(); // Yönlendirme sonrası betiğin çalışmasını durdur
    }
}


if (isset($_POST['xidmet-elavesi'])) {

    $seo = seflink($_POST['adi']);


    $tur = "xidmetler";

    $klasorbanka = "../../imgupload/"; // Resimlerin yükleneceği klasör
    $tarih = date('Y-m-d H:i:s');
    
    $sira_degeri = 1;
    if (isset($_POST['sira']) && $_POST['sira'] !== '') {
        $sira_degeri = intval($_POST['sira']);
    } else {
        // Formdan sıra gelmediyse, veritabanındaki en yüksek değeri bul
        $son_sira_sorgu = $db->query("SELECT MAX(sira) AS max_sira FROM mehsullar");
        $sonuc = $son_sira_sorgu->fetch(PDO::FETCH_ASSOC);
        if ($sonuc && isset($sonuc['max_sira'])) {
            $sira_degeri = $sonuc['max_sira'] + 1;
        }
    }

    // --- BİRİNCİ RESİM İŞLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        $resim = "no-img";
    } else {
        $file_type = $_FILES["resim"]["type"];
        // Desteklenen formatları kontrol edin
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            // Geçici dosyayı sunucuya taşı
            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasorbanka . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                // Resim tipine göre farklı imagecreatefrom fonksiyonunu kullanın
                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    // PNG için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    // GIF için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else { // JPG veya JPEG ise
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    // WebP dönüştürme kalitesi: 0 (en düşük) - 100 (en yüksek). Genellikle 80-90 arası iyidir.
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path); // Geçici orijinal dosyayı silin
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM İŞLEME SONU ---

    // --- İKİNCİ RESİM İŞLEME BAŞLANGICI (resim2) ---
    if (empty($_FILES['sehifesekli']['tmp_name'])) {
        $sehifesekli = "no-img";
    } else {
        $file_type2 = $_FILES["sehifesekli"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {

            $random2 = rand(0, 9999999);
            $original_file_extension2 = pathinfo($_FILES['sehifesekli']['name'], PATHINFO_EXTENSION);
            $temp_filename2 = $random2 . "-" . $seo . "." . $original_file_extension2;

            if (move_uploaded_file($_FILES['sehifesekli']['tmp_name'], $klasorbanka . "/" . $temp_filename2)) {
                $file_path2 = "../../imgupload/" . $temp_filename2;
                $image2 = null;

                if ($file_type2 == "image/png") {
                    $image2 = imagecreatefrompng($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } elseif ($file_type2 == "image/gif") {
                    $image2 = imagecreatefromgif($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } else {
                    $image2 = imagecreatefromjpeg($file_path2);
                }

                if ($image2) {
                    $output2 = '../../imgupload/' . $random2 . '-' . $seo . '.webp';
                    $sehifesekli = $random2 . '-' . $seo . '.webp';
                    imagewebp($image2, $output2, 85);
                    imagedestroy($image2);
                    unlink($file_path2);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkinci resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkinci dosya yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }

    // --- İKON İŞLEME BAŞLANGICI (icon) ---
    // İkon yükleme alanı boşsa "no-img" ata
    if (empty($_FILES['icon']['tmp_name'])) {
        $icon = "no-img";
    } else {
        $file_type_icon = $_FILES["icon"]["type"];
        if ($file_type_icon == "image/gif" || $file_type_icon == "image/png" || $file_type_icon == "image/jpg" || $file_type_icon == "image/jpeg") {

            $random_icon = rand(0, 9999999);
            $original_file_extension_icon = pathinfo($_FILES['icon']['name'], PATHINFO_EXTENSION);
            $temp_filename_icon = $random_icon . "-" . $seo . "-icon." . $original_file_extension_icon; // İkon için farklı bir adlandırma

            if (move_uploaded_file($_FILES['icon']['tmp_name'], $klasorbanka . "/" . $temp_filename_icon)) {
                $file_path_icon = "../../imgupload/" . $temp_filename_icon;
                $image_icon = null;

                if ($file_type_icon == "image/png") {
                    $image_icon = imagecreatefrompng($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } elseif ($file_type_icon == "image/gif") {
                    $image_icon = imagecreatefromgif($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } else {
                    $image_icon = imagecreatefromjpeg($file_path_icon);
                }

                if ($image_icon) {
                    $output_icon = '../../imgupload/' . $random_icon . '-' . $seo . '-icon.webp'; // WebP formatında kaydet
                    $icon = $random_icon . '-' . $seo . '-icon.webp'; // Veritabanına kaydedilecek isim
                    imagewebp($image_icon, $output_icon, 85);
                    imagedestroy($image_icon);
                    unlink($file_path_icon); // Geçici dosyayı sil
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkon işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkon dosyası yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> İkon için lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKON İŞLEME SONU ---



    $indi = $db->prepare("insert into xidmetler set title=:title,description=:description,icon=:icon,etiket=:etiket,meta_title=:meta_title,meta_des=:meta_des,meta_key=:meta_key,lan=:lan,adi=:adi,sira=:sira,resim=:resim,sehifesekli=:sehifesekli,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,eklenme_tarihi=:eklenme_tarihi");
    $elaveet = $indi->execute(array("title" => $_POST["title"], "icon" => $icon, "description" => $_POST["description"], "meta_title" => $_POST["meta_title"], "meta_des" => $_POST["meta_des"], "meta_key" => $_POST["meta_key"], "etiket" => $_POST["etiket"], "lan" => $_POST["lan"], "adi" => $_POST["adi"], "sira" => $sira_degeri, "resim" => $resim, "sehifesekli" => $sehifesekli, "kategori" => $kategori, "aciklama" => $_POST["aciklama"], "seo" => $seo, "tur" => $tur, "onaciklama" => $_POST["onaciklama"], "veziyyeti" => $_POST["veziyyeti"], "eklenme_tarihi" => $tarih));



    if ($elaveet) {

        $sonid = $db->query("select * from xidmetler order by id desc")->fetch(PDO::FETCH_ASSOC);

        $yeni = $sonid['id'];
        if (isset($_POST['img'])) {
            foreach ($_POST['img'] as $img) {
                $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?, tur=?");
                $islem = $islem->execute(array($yeni, $img, $tur));
            }
        }


        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}



if (isset($_POST['xidmet-yenille'])) {

    // seflink fonksiyonu, kod tekrarını önlemek için genellikle bu bloğun dışında veya ayrı bir dosyada tanımlanır.
    // Ancak, sizden tam kodu istediğiniz için burada tekrar veriyorum.
    // Daha iyi bir yapı için bu fonksiyonu dosyanın başında bir kez tanımlamanızı şiddetle tavsiye ederim.

    $seo = seflink($_POST['adi']); // Resim ve ikon adı için kullanılacak SEO dostu isim
    $tur = "xidmetler"; // Kategori veya tür bilgisi
    $id = $_POST['id']; // Güncellenecek hizmetin ID'si
    $klasord = "../../imgupload/";

    // --- BİRİNCİ RESİM GÜNCELLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        // Resim yüklenmediyse mevcut resmi koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM xidmetler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        $file_type = $_FILES["resim"]["type"];
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            // Eski resmi sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM xidmetler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['resim'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else {
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM GÜNCELLEME SONU ---

    // --- İKİNCİ RESİM GÜNCELLEME BAŞLANGICI (resim2) ---
    if (empty($_FILES['sehifesekli']['tmp_name'])) {
        // Resim yüklenmediyse mevcut resmi koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM xidmetler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $sehifesekli = $tenzimleme_qeydi['sehifesekli'];
    } else {
        $file_type2 = $_FILES["sehifesekli"]["type"];
        if ($file_type2 == "image/gif" || $file_type2 == "image/png" || $file_type2 == "image/jpg" || $file_type2 == "image/jpeg") {

            // Eski resmi sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM xidmetler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['sehifesekli'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['sehifesekli'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['sehifesekli']);
            }

            $random2 = rand(0, 9999999);
            $original_file_extension2 = pathinfo($_FILES['sehifesekli']['name'], PATHINFO_EXTENSION);
            $temp_filename2 = $random2 . "-" . $seo . "." . $original_file_extension2;

            if (move_uploaded_file($_FILES['sehifesekli']['tmp_name'], $klasord . "/" . $temp_filename2)) {
                $file_path2 = "../../imgupload/" . $temp_filename2;
                $image2 = null;

                if ($file_type2 == "image/png") {
                    $image2 = imagecreatefrompng($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } elseif ($file_type2 == "image/gif") {
                    $image2 = imagecreatefromgif($file_path2);
                    imagealphablending($image2, false);
                    imagesavealpha($image2, true);
                } else {
                    $image2 = imagecreatefromjpeg($file_path2);
                }

                if ($image2) {
                    $output2 = '../../imgupload/' . $random2 . '-' . $seo . '.webp';
                    $sehifesekli = $random2 . '-' . $seo . '.webp';
                    imagewebp($image2, $output2, 85);
                    imagedestroy($image2);
                    unlink($file_path2);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkinci resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkinci dosya yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKİNCİ RESİM GÜNCELLEME SONU ---

    // --- İKON GÜNCELLEME BAŞLANGICI (icon) ---
    // Eğer 'icon' adında bir dosya yüklemesi varsa işlem yap
    if (empty($_FILES['icon']['tmp_name'])) {
        // İkon yüklenmediyse mevcut ikonu koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM xidmetler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $icon = $tenzimleme_qeydi['icon'];
    } else {
        $file_type_icon = $_FILES["icon"]["type"];
        if ($file_type_icon == "image/gif" || $file_type_icon == "image/png" || $file_type_icon == "image/jpg" || $file_type_icon == "image/jpeg") {

            // Eski ikonu sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM xidmetler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['icon'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['icon'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['icon']);
            }

            $random_icon = rand(0, 9999999);
            $original_file_extension_icon = pathinfo($_FILES['icon']['name'], PATHINFO_EXTENSION);
            $temp_filename_icon = $random_icon . "-" . $seo . "-icon." . $original_file_extension_icon; // İkon için farklı bir adlandırma

            if (move_uploaded_file($_FILES['icon']['tmp_name'], $klasord . "/" . $temp_filename_icon)) {
                $file_path_icon = "../../imgupload/" . $temp_filename_icon;
                $image_icon = null;

                if ($file_type_icon == "image/png") {
                    $image_icon = imagecreatefrompng($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } elseif ($file_type_icon == "image/gif") {
                    $image_icon = imagecreatefromgif($file_path_icon);
                    imagealphablending($image_icon, false);
                    imagesavealpha($image_icon, true);
                } else {
                    $image_icon = imagecreatefromjpeg($file_path_icon);
                }

                if ($image_icon) {
                    $output_icon = '../../imgupload/' . $random_icon . '-' . $seo . '-icon.webp'; // WebP formatında kaydet
                    $icon = $random_icon . '-' . $seo . '-icon.webp'; // Veritabanına kaydedilecek isim
                    imagewebp($image_icon, $output_icon, 85);
                    imagedestroy($image_icon);
                    unlink($file_path_icon); // Geçici dosyayı sil
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> İkon işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> İkon dosyası yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> İkon için lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- İKON GÜNCELLEME SONU ---




    $deleteee = $db->exec("DELETE FROM urun_img WHERE urun_id = '$id' ");

    if (isset($_POST['img'])) {
        foreach ($_POST['img'] as $img) {
            $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?,tur=?");
            $islem = $islem->execute(array($id, $img, $tur));
        }
    }

    // Ana hizmet bilgilerini güncelle
    $indi1 = $db->prepare("UPDATE xidmetler SET
        title=:title,
        description=:description,
        etiket=:etiket,
        meta_title=:meta_title,
        meta_des=:meta_des,
        meta_key=:meta_key,
        icon=:icon,
        adi=:adi,
        sira=:sira,
        resim=:resim,
        sehifesekli=:sehifesekli,
        kategori=:kategori,
        veziyyeti=:veziyyeti,
        onaciklama=:onaciklama,
        aciklama=:aciklama,
        seo=:seo,
        tur=:tur,
        guncelleme_tarihi=:guncelleme_tarihi
        WHERE id=:id");

    $elaveet1 = $indi1->execute(array(
        "icon" => $icon, // Güncellenen ikon adı
        "title" => $_POST["title"],
        "description" => $_POST["description"],
        "etiket" => $_POST["etiket"],
        "meta_title" => $_POST["meta_title"],
        "meta_des" => $_POST["meta_des"],
        "meta_key" => $_POST["meta_key"],
        "adi" => $_POST["adi"],
        "sira" => $_POST["sira"],
        "resim" => $resim,
        "sehifesekli" => $sehifesekli, // Güncellenen resim adı
        "kategori" => $_POST["kategori"], // `$_POST['kategori']` kullanıldığı varsayılıyor, ekleme kısmında `$kategori` değişkeni kullanılmıştı. Tutarlılık önemli.
        "aciklama" => $_POST["aciklama"],
        "seo" => $seo,
        "tur" => $tur,
        "onaciklama" => $_POST["onaciklama"],
        "veziyyeti" => $_POST["veziyyeti"],
        "guncelleme_tarihi" => $tarih,
        "id" => $id
    ));

    // Güncelleme başarılıysa yönlendir, değilse hata mesajı ile yönlendir
    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
        exit(); // Yönlendirme sonrası betiğin çalışmasını durdur
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
        exit(); // Yönlendirme sonrası betiğin çalışmasını durdur
    }
}




if (isset($_POST['referans-elavesi'])) {

    $seo = seflink($_POST['adi']);

    $tur = "referanslar";

    $klasorbanka = "../../imgupload/"; // Resimlerin yükleneceği klasör
    $tarih = date('Y-m-d H:i:s');
    
    $sira_degeri = 1;
    if (isset($_POST['sira']) && $_POST['sira'] !== '') {
        $sira_degeri = intval($_POST['sira']);
    } else {
        // Formdan sıra gelmediyse, veritabanındaki en yüksek değeri bul
        $son_sira_sorgu = $db->query("SELECT MAX(sira) AS max_sira FROM mehsullar");
        $sonuc = $son_sira_sorgu->fetch(PDO::FETCH_ASSOC);
        if ($sonuc && isset($sonuc['max_sira'])) {
            $sira_degeri = $sonuc['max_sira'] + 1;
        }
    }


    // --- BİRİNCİ RESİM İŞLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        $resim = "no-img";
    } else {
        $file_type = $_FILES["resim"]["type"];
        // Desteklenen formatları kontrol edin
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            // Geçici dosyayı sunucuya taşı
            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasorbanka . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                // Resim tipine göre farklı imagecreatefrom fonksiyonunu kullanın
                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    // PNG için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    // GIF için şeffaflığı korumak adına
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else { // JPG veya JPEG ise
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    // WebP dönüştürme kalitesi: 0 (en düşük) - 100 (en yüksek). Genellikle 80-90 arası iyidir.
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path); // Geçici orijinal dosyayı silin
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }





    $indi = $db->prepare("insert into referanslar set lan=:lan,adi=:adi,sira=:sira,resim=:resim,veziyyeti=:veziyyeti,linki=:linki,aciklama=:aciklama");
    $elaveet = $indi->execute(array("adi" => $_POST["adi"], "lan" => $_POST["lan"], "sira" => $sira_degeri, "resim" => $resim, "aciklama" => $_POST["aciklama"], "linki" => $_POST["linki"], "veziyyeti" => $_POST["veziyyeti"]));



    if ($elaveet) {




        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}



if (isset($_POST['referans-yenille'])) {


    $seo = seflink($_POST['adi']);


    $tur = "referanslar";

    $id = $_POST['id'];

    $klasord = "../../imgupload/";

    // --- BİRİNCİ RESİM GÜNCELLEME BAŞLANGICI (resim) ---
    if (empty($_FILES['resim']['tmp_name'])) {
        // Resim yüklenmediyse mevcut resmi koru
        $tenzimleme_qeydi = $db->query("SELECT * FROM referanslar WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        $file_type = $_FILES["resim"]["type"];
        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            // Eski resmi sil
            $tenzimleme_qeydi = $db->query("SELECT * FROM referanslar WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img" && file_exists("../../imgupload/" . $tenzimleme_qeydi['resim'])) {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 9999999);
            $original_file_extension = pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION);
            $temp_filename = $random . "-" . $seo . "." . $original_file_extension;

            if (move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $temp_filename)) {
                $file_path = "../../imgupload/" . $temp_filename;
                $image = null;

                if ($file_type == "image/png") {
                    $image = imagecreatefrompng($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } elseif ($file_type == "image/gif") {
                    $image = imagecreatefromgif($file_path);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                } else {
                    $image = imagecreatefromjpeg($file_path);
                }

                if ($image) {
                    $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
                    $resim = $random . '-' . $seo . '.webp';
                    imagewebp($image, $output, 85);
                    imagedestroy($image);
                    unlink($file_path);
                } else {
                    $bilgi = '<div class="alert alert-error">
                        <button class="close" data-dismiss="alert">×</button>
                        <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                        </div>';
                }
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Dosya yüklenemedi. Klasör izinlerini kontrol edin.
                    </div>';
            }
        } else {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
                </div>';
        }
    }
    // --- BİRİNCİ RESİM GÜNCELLEME SONU ---

    $deleteee = $db->exec("DELETE FROM urun_img WHERE urun_id = '$id' ");

    if (isset($_POST['img'])) {
        foreach ($_POST['img'] as $img) {
            $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?,tur=?");
            $islem = $islem->execute(array($id, $img, $tur));
        }
    }







    $indi1 = $db->prepare("update referanslar set adi=:adi,sira=:sira,resim=:resim,veziyyeti=:veziyyeti,linki=:linki,aciklama=:aciklama where id=:id");
    $elaveet1 = $indi1->execute(array("adi" => $_POST["adi"], "sira" => $_POST["sira"], "resim" => $resim, "aciklama" => $_POST["aciklama"], "linki" => $_POST["linki"], "veziyyeti" => $_POST["veziyyeti"], "id" => $id));

    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['dil-elavesi'])) {


    $seo = seflink($_POST['adi']);




    $klasord = "../../imgupload/";
    $resim_tmpd = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpd)) {
        $resim = "no-img";
    } else {

        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {
            $random = rand(0, 999);

            $resim = $random . "-" . $seo . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $resim);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }

    $resim_tmpd1 = $_FILES['resim1']['tmp_name'];
    if (empty($resim_tmpd1)) {
        $resim1 = "no-img";
    } else {

        if ($_FILES["resim1"]["type"] == "image/gif" || $_FILES["resim1"]["type"] == "image/png" || $_FILES["resim1"]["type"] == "image/jpg" || $_FILES["resim1"]["type"] == "image/jpeg") {
            $random = rand(0, 999);

            $resim1 = $random . "-" . $seo . "." . substr($_FILES['resim1']['name'], -3);

            move_uploaded_file($_FILES['resim1']['tmp_name'], $klasord . "/" . $resim1);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }

    $resim_tmpd11 = $_FILES['resim2']['tmp_name'];
    if (empty($resim_tmpd11)) {
        $resim2 = "no-img";
    } else {

        if ($_FILES["resim2"]["type"] == "image/gif" || $_FILES["resim2"]["type"] == "image/png" || $_FILES["resim2"]["type"] == "image/jpg" || $_FILES["resim2"]["type"] == "image/jpeg") {
            $random = rand(0, 999);

            $resim2 = $random . "-" . $seo . "." . substr($_FILES['resim2']['name'], -3);

            move_uploaded_file($_FILES['resim2']['tmp_name'], $klasord . "/" . $resim2);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }





    $indi = $db->prepare("insert into lan set sira=:sira,anadil=:anadil,adi=:adi,aciklama=:aciklama,resim=:resim,kod=:kod,veziyyeti=:veziyyeti ");
    $elaveet = $indi->execute(array(
        "sira" => $_POST["sira"],
        "adi" => $_POST["adi"],
        "anadil" => $_POST["anadil"],
        "aciklama" => $_POST["aciklama"],
        "kod" => $_POST["kod"],
        "veziyyeti" => $_POST["veziyyeti"],
        "resim" => $resim


    ));



    if ($elaveet) {




        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}



if (isset($_POST['dil-yenille'])) {


    $seo = seflink($_POST['adi']);


    $tur = "lan";

    $id = $_POST['id'];

    $klasor = "../../imgupload/";

    $resim_tmp = $_FILES['resim']['tmp_name'];

    if (empty($resim_tmp)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM lan WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM lan WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img") {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 999);

            $resim = $random . "-" . $adii . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasor . "/" . $resim);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }

    $resim_tmp1 = $_FILES['resim1']['tmp_name'];

    if (empty($resim_tmp1)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM lan WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim1 = $tenzimleme_qeydi['resim1'];
    } else {
        if ($_FILES["resim1"]["type"] == "image/gif" || $_FILES["resim1"]["type"] == "image/png" || $_FILES["resim1"]["type"] == "image/jpg" || $_FILES["resim1"]["type"] == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM lan WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim1'] != "no-img") {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim1']);
            }

            $random = rand(0, 999);

            $resim1 = $random . "-" . $adii . "." . substr($_FILES['resim1']['name'], -3);

            move_uploaded_file($_FILES['resim1']['tmp_name'], $klasor . "/" . $resim1);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }

    $resim_tmp11 = $_FILES['resim2']['tmp_name'];

    if (empty($resim_tmp11)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM lan WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim2 = $tenzimleme_qeydi['resim2'];
    } else {
        if ($_FILES["resim2"]["type"] == "image/gif" || $_FILES["resim2"]["type"] == "image/png" || $_FILES["resim2"]["type"] == "image/jpg" || $_FILES["resim2"]["type"] == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM lan WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim2'] != "no-img") {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim2']);
            }

            $random = rand(0, 999);

            $resim2 = $random . "-" . $adii . "." . substr($_FILES['resim2']['name'], -3);

            move_uploaded_file($_FILES['resim2']['tmp_name'], $klasor . "/" . $resim2);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }








    $indi1 = $db->prepare("update lan set veziyyeti=:veziyyeti,adi=:adi,anadil=:anadil,sira=:sira,aciklama=:aciklama,kod=:kod,resim=:resim where id=:id");
    $elaveet1 = $indi1->execute(array("adi" => $_POST["adi"], "veziyyeti" => $_POST["veziyyeti"], "anadil" => $_POST["anadil"], "sira" => $_POST["sira"], "aciklama" => $_POST["aciklama"], "kod" => $_POST["kod"], "id" => $id, "resim" => $resim));

    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['dilin-elavesi'])) {


    $seo = seflink($_POST['adi']);


    $klasord = "../../imgupload/";
    $resim_tmpd = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpd)) {
        $resim = "no-img";
    } else {

        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {
            $random = rand(0, 999);

            $resim = $random . "-" . $seo . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $resim);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }

    $resim_tmpd1 = $_FILES['resim1']['tmp_name'];
    if (empty($resim_tmpd1)) {
        $resim1 = "no-img";
    } else {

        if ($_FILES["resim1"]["type"] == "image/gif" || $_FILES["resim1"]["type"] == "image/png" || $_FILES["resim1"]["type"] == "image/jpg" || $_FILES["resim1"]["type"] == "image/jpeg") {
            $random = rand(0, 999);

            $resim1 = $random . "-" . $seo . "." . substr($_FILES['resim1']['name'], -3);

            move_uploaded_file($_FILES['resim1']['tmp_name'], $klasord . "/" . $resim1);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }

    $resim_tmpd11 = $_FILES['resim2']['tmp_name'];
    if (empty($resim_tmpd11)) {
        $resim2 = "no-img";
    } else {

        if ($_FILES["resim2"]["type"] == "image/gif" || $_FILES["resim2"]["type"] == "image/png" || $_FILES["resim2"]["type"] == "image/jpg" || $_FILES["resim2"]["type"] == "image/jpeg") {
            $random = rand(0, 999);

            $resim2 = $random . "-" . $seo . "." . substr($_FILES['resim2']['name'], -3);

            move_uploaded_file($_FILES['resim2']['tmp_name'], $klasord . "/" . $resim2);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }





    $indi = $db->prepare("insert into lan set resim2=:resim2,resim1=:resim1,mehsullar=:mehsullar,xidmetbuton=:xidmetbuton,xeberbuton=:xeberbuton,mehsulbuton=:mehsulbuton,layihebuton=:layihebuton,a_madde=:a_madde,b_madde=:b_madde,c_madde=:c_madde,d_madde=:d_madde,v_link=:v_link,v_baslik=:v_baslik,digerhizmetler=:digerhizmetler,adres=:adres,neden=:neden,haqqimizdaadi=:haqqimizdaadi,abone_a=:abone_a,ozgecmis=:ozgecmis,fiyatteklif=:fiyatteklif,hizliteklif=:hizliteklif,aboneol=:aboneol,ekipmanlar=:ekipmanlar,haqqimizdametin=:haqqimizdametin,onyazi=:onyazi,muhasebe=:muhasebe,satis=:satis,pazarlama=:pazarlama,operasyon=:operasyon,departman=:departman,calismak=:calismak,kariyer=:kariyer,filallar=:filallar,yorumatabilirsiniz=:yorumatabilirsiniz,blogyorumlari=:blogyorumlari,digerbloglar=:digerbloglar,etiketler=:etiketler,anadil=:anadil,alan=:alan,adsoyad=:adsoyad,telefon=:telefon,konu=:konu,mesaj=:mesaj,email=:email,elaqemelumatlari=:elaqemelumatlari,sosialmedia=:sosialmedia,anasayfa=:anasayfa,hizliiletisim=:hizliiletisim,kurumsal=:kurumsal,galeri=:galeri,video=:video,adi=:adi,sira=:sira,resim=:resim,veziyyeti=:veziyyeti,linki=:linki,aciklama=:aciklama,inceleyin=:inceleyin,etrafli=:etrafli,elaqe=:elaqe,footermetin=:footermetin,elaqeforum=:elaqeforum,hamsinioxu=:hamsinioxu,hamisinabax=:hamisinabax,xidemtleraltmetin=:xidemtleraltmetin,komandamizaltmetin=:komandamizaltmetin,xidmetler=:xidmetler,komandamiz=:komandamiz,
	 layiheler=:layiheler,layiheleraltmetin=:layiheleraltmetin,hamisi=:hamisi,sualcavab=:sualcavab,istatikler=:istatikler,gonder=:gonder,kod=:kod,blogaltmetin=:blogaltmetin,blog=:blog,reyleraltmetin=:reyleraltmetin,reyler=:reyler,banner=:banner,bizimle=:bizimle,medya=:medya,urunbilgileri=:urunbilgileri,satinal=:satinal,sepeteekle=:sepeteekle,
	 sepetim=:sepetim,urunresmi=:urunresmi,urunadi=:urunadi,urunadet=:urunadet,urunfiyat=:urunfiyat,islem=:islem,siparisbilgileri=:siparisbilgileri,siparisitamamla=:siparisitamamla,bankahesaplari=:bankahesaplari,referanslar=:referanslar,kataloglar=:kataloglar
	 
	 ");
    $elaveet = $indi->execute(array(
        "resim2" => $resim2,
        "resim1" => $resim1,
        "mehsullar" => $_POST["mehsullar"],
        "a_madde" => $_POST["a_madde"],
        "b_madde" => $_POST["b_madde"],
        "c_madde" => $_POST["c_madde"],
        "d_madde" => $_POST["d_madde"],
        "v_link" => $_POST["v_link"],
        "v_baslik" => $_POST["v_baslik"],
        "digerhizmetler" => $_POST["digerhizmetler"],
        "adres" => $_POST["adres"],
        "neden" => $_POST["neden"],
        "abone_a" => $_POST["abone_a"],
        "haqqimizdaadi" => $_POST["haqqimizdaadi"],
        "ozgecmis" => $_POST["ozgecmis"],
        "hizliteklif" => $_POST["hizliteklif"],
        "fiyatteklif" => $_POST["fiyatteklif"],
        "haqqimizdametin" => $_POST["haqqimizdametin"],
        "ekipmanlar" => $_POST["ekipmanlar"],
        "aboneol" => $_POST["aboneol"],
        "operasyon" => $_POST["operasyon"],
        "onyazi" => $_POST["onyazi"],
        "muhasebe" => $_POST["muhasebe"],
        "satis" => $_POST["satis"],
        "pazarlama" => $_POST["pazarlama"],
        "filallar" => $_POST["filallar"],
        "departman" => $_POST["departman"],
        "calismak" => $_POST["calismak"],
        "kariyer" => $_POST["kariyer"],
        "blogyorumlari" => $_POST["blogyorumlari"],
        "yorumatabilirsiniz" => $_POST["yorumatabilirsiniz"],
        "digerbloglar" => $_POST["digerbloglar"],
        "etiketler" => $_POST["etiketler"],
        "anadil" => $_POST["anadil"],
        "alan" => $_POST["alan"],
        "adsoyad" => $_POST["adsoyad"],
        "telefon" => $_POST["telefon"],
        "konu" => $_POST["konu"],
        "mesaj" => $_POST["mesaj"],
        "email" => $_POST["email"],
        "elaqemelumatlari" => $_POST["elaqemelumatlari"],
        "sosialmedia" => $_POST["sosialmedia"],
        "anasayfa" => $_POST["anasayfa"],
        "hizliiletisim" => $_POST["hizliiletisim"],
        "kurumsal" => $_POST["kurumsal"],
        "video" => $_POST["video"],
        "xidmetbuton" => $_POST["xidmetbuton"],
        "xeberbuton" => $_POST["xeberbuton"],
        "mehsulbuton" => $_POST["mehsulbuton"],
        "layihebuton" => $_POST["layihebuton"],
        "galeri" => $_POST["galeri"],
        "adi" => $_POST["adi"],
        "sira" => $_POST["sira"],
        "resim" => $resim,
        "aciklama" => $_POST["aciklama"],
        "kod" => $_POST["kod"],
        "linki" => $_POST["linki"],
        "veziyyeti" => $_POST["veziyyeti"],
        "etrafli" => $_POST["etrafli"],
        "inceleyin" => $_POST["inceleyin"],
        "elaqe" => $_POST["elaqe"],
        "elaqeforum" => $_POST["elaqeforum"],
        "hamsinioxu" => $_POST["hamsinioxu"],
        "hamisinabax" => $_POST["hamisinabax"],
        "xidmetler" => $_POST["xidmetler"],
        "komandamiz" => $_POST["komandamiz"],
        "komandamizaltmetin" => $_POST["komandamizaltmetin"],
        "footermetin" => $_POST["footermetin"],
        "xidemtleraltmetin" => $_POST["xidemtleraltmetin"],
        "layiheleraltmetin" => $_POST["layiheleraltmetin"],
        "layiheler" => $_POST["layiheler"],
        "hamisi" => $_POST["hamisi"],
        "sualcavab" => $_POST["sualcavab"],
        "istatikler" => $_POST["istatikler"],
        "gonder" => $_POST["gonder"],
        "blogaltmetin" => $_POST["blogaltmetin"],
        "blog" => $_POST["blog"],
        "reyler" => $_POST["reyler"],
        "reyleraltmetin" => $_POST["reyleraltmetin"],
        "banner" => $_POST["banner"],
        "bizimle" => $_POST["bizimle"],
        "medya" => $_POST["medya"],
        "urunbilgileri" => $_POST["urunbilgileri"],
        "satinal" => $_POST["satinal"],
        "sepeteekle" => $_POST["sepeteekle"],
        "sepetim" => $_POST["sepetim"],
        "urunresmi" => $_POST["urunresmi"],
        "urunadi" => $_POST["urunadi"],
        "urunadet" => $_POST["urunadet"],
        "urunfiyat" => $_POST["urunfiyat"],
        "islem" => $_POST["islem"],
        "siparisbilgileri" => $_POST["siparisbilgileri"],
        "siparisitamamla" => $_POST["siparisitamamla"],
        "bankahesaplari" => $_POST["bankahesaplari"],
        "referanslar" => $_POST["referanslar"],
        "kataloglar" => $_POST["kataloglar"]


    ));



    if ($elaveet) {




        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}



if (isset($_POST['dili-yenile'])) {


    $seo = seflink($_POST['adi']);


    $tur = "lan";

    $id = $_POST['id'];

    $klasor = "../../imgupload/";

    $resim_tmp = $_FILES['resim']['tmp_name'];

    if (empty($resim_tmp)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM lan WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM lan WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img") {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 999);

            $resim = $random . "-" . $adii . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasor . "/" . $resim);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }

    $resim_tmp1 = $_FILES['resim1']['tmp_name'];

    if (empty($resim_tmp1)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM lan WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim1 = $tenzimleme_qeydi['resim1'];
    } else {
        if ($_FILES["resim1"]["type"] == "image/gif" || $_FILES["resim1"]["type"] == "image/png" || $_FILES["resim1"]["type"] == "image/jpg" || $_FILES["resim1"]["type"] == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM lan WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim1'] != "no-img") {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim1']);
            }

            $random = rand(0, 999);

            $resim1 = $random . "-" . $adii . "." . substr($_FILES['resim1']['name'], -3);

            move_uploaded_file($_FILES['resim1']['tmp_name'], $klasor . "/" . $resim1);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }

    $resim_tmp11 = $_FILES['resim2']['tmp_name'];

    if (empty($resim_tmp11)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM lan WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim2 = $tenzimleme_qeydi['resim2'];
    } else {
        if ($_FILES["resim2"]["type"] == "image/gif" || $_FILES["resim2"]["type"] == "image/png" || $_FILES["resim2"]["type"] == "image/jpg" || $_FILES["resim2"]["type"] == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM lan WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim2'] != "no-img") {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim2']);
            }

            $random = rand(0, 999);

            $resim2 = $random . "-" . $adii . "." . substr($_FILES['resim2']['name'], -3);

            move_uploaded_file($_FILES['resim2']['tmp_name'], $klasor . "/" . $resim2);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }








    $indi1 = $db->prepare("update lan set resim1=:resim1,resim2=:resim2,mehsullar=:mehsullar,xidmetbuton=:xidmetbuton,xeberbuton=:xeberbuton,mehsulbuton=:mehsulbuton,layihebuton=:layihebuton,a_madde=:a_madde,b_madde=:b_madde,c_madde=:c_madde,d_madde=:d_madde,v_link=:v_link,v_baslik=:v_baslik,digerhizmetler=:digerhizmetler,adres=:adres,neden=:neden,haqqimizdaadi=:haqqimizdaadi,abone_a=:abone_a,ozgecmis=:ozgecmis,fiyatteklif=:fiyatteklif,hizliteklif=:hizliteklif,ekipmanlar=:ekipmanlar,aboneol=:aboneol,haqqimizdametin=:haqqimizdametin,onyazi=:onyazi,muhasebe=:muhasebe,satis=:satis,pazarlama=:pazarlama,operasyon=:operasyon,departman=:departman,calismak=:calismak,kariyer=:kariyer,filallar=:filallar,digerbloglar=:digerbloglar,etiketler=:etiketler,anadil=:anadil,alan=:alan,adsoyad=:adsoyad,telefon=:telefon,konu=:konu,mesaj=:mesaj,email=:email,elaqemelumatlari=:elaqemelumatlari,sosialmedia=:sosialmedia,anasayfa=:anasayfa,hizliiletisim=:hizliiletisim,kurumsal=:kurumsal,galeri=:galeri,video=:video,adi=:adi,sira=:sira,resim=:resim,veziyyeti=:veziyyeti,linki=:linki,aciklama=:aciklama,etrafli=:etrafli,inceleyin=:inceleyin,elaqe=:elaqe,elaqeforum=:elaqeforum,hamsinioxu=:hamsinioxu,hamisinabax=:hamisinabax,xidmetler=:xidmetler,footermetin=:footermetin,xidemtleraltmetin=:xidemtleraltmetin,komandamizaltmetin=:komandamizaltmetin,komandamiz=:komandamiz,
	 layiheler=:layiheler,layiheleraltmetin=:layiheleraltmetin,hamisi=:hamisi,sualcavab=:sualcavab,istatikler=:istatikler,gonder=:gonder,blog=:blog,blogaltmetin=:blogaltmetin,reyleraltmetin=:reyleraltmetin,reyler=:reyler,banner=:banner,bizimle=:bizimle,medya=:medya,urunbilgileri=:urunbilgileri,satinal=:satinal,sepeteekle=:sepeteekle,
	 sepetim=:sepetim,urunresmi=:urunresmi,urunadi=:urunadi,urunadet=:urunadet,urunfiyat=:urunfiyat,islem=:islem,kod=:kod,siparisbilgileri=:siparisbilgileri,siparisitamamla=:siparisitamamla,bankahesaplari=:bankahesaplari,referanslar=:referanslar,kataloglar=:kataloglar where id=:id");
    $elaveet1 = $indi1->execute(array(
        "resim1" => $resim1,
        "resim2" => $resim2,
        "mehsullar" => $_POST["mehsullar"],
        "a_madde" => $_POST["a_madde"],
        "b_madde" => $_POST["b_madde"],
        "c_madde" => $_POST["c_madde"],
        "d_madde" => $_POST["d_madde"],
        "v_link" => $_POST["v_link"],
        "v_baslik" => $_POST["v_baslik"],
        "adres" => $_POST["adres"],
        "digerhizmetler" => $_POST["digerhizmetler"],
        "neden" => $_POST["neden"],
        "abone_a" => $_POST["abone_a"],
        "haqqimizdaadi" => $_POST["haqqimizdaadi"],
        "ozgecmis" => $_POST["ozgecmis"],
        "hizliteklif" => $_POST["hizliteklif"],
        "fiyatteklif" => $_POST["fiyatteklif"],
        "ekipmanlar" => $_POST["ekipmanlar"],
        "aboneol" => $_POST["aboneol"],
        "operasyon" => $_POST["operasyon"],
        "onyazi" => $_POST["onyazi"],
        "muhasebe" => $_POST["muhasebe"],
        "satis" => $_POST["satis"],
        "footermetin" => $_POST["footermetin"],
        "pazarlama" => $_POST["pazarlama"],
        "filallar" => $_POST["filallar"],
        "departman" => $_POST["departman"],
        "calismak" => $_POST["calismak"],
        "kariyer" => $_POST["kariyer"],
        "digerbloglar" => $_POST["digerbloglar"],
        "etiketler" => $_POST["etiketler"],
        "anadil" => $_POST["anadil"],
        "alan" => $_POST["alan"],
        "adsoyad" => $_POST["adsoyad"],
        "telefon" => $_POST["telefon"],
        "konu" => $_POST["konu"],
        "mesaj" => $_POST["mesaj"],
        "email" => $_POST["email"],
        "elaqemelumatlari" => $_POST["elaqemelumatlari"],
        "sosialmedia" => $_POST["sosialmedia"],
        "anasayfa" => $_POST["anasayfa"],
        "hizliiletisim" => $_POST["hizliiletisim"],
        "kurumsal" => $_POST["kurumsal"],
        "video" => $_POST["video"],
        "galeri" => $_POST["galeri"],
        "adi" => $_POST["adi"],
        "sira" => $_POST["sira"],
        "resim" => $resim,
        "aciklama" => $_POST["aciklama"],
        "xidmetbuton" => $_POST["xidmetbuton"],
        "xeberbuton" => $_POST["xeberbuton"],
        "mehsulbuton" => $_POST["mehsulbuton"],
        "layihebuton" => $_POST["layihebuton"],
        "linki" => $_POST["linki"],
        "veziyyeti" => $_POST["veziyyeti"],
        "etrafli" => $_POST["etrafli"],
        "inceleyin" => $_POST["inceleyin"],
        "elaqe" => $_POST["elaqe"],
        "elaqeforum" => $_POST["elaqeforum"],
        "hamsinioxu" => $_POST["hamsinioxu"],
        "hamisinabax" => $_POST["hamisinabax"],
        "xidmetler" => $_POST["xidmetler"],
        "xidemtleraltmetin" => $_POST["xidemtleraltmetin"],
        "komandamiz" => $_POST["komandamiz"],
        "komandamizaltmetin" => $_POST["komandamizaltmetin"],
        "haqqimizdametin" => $_POST["haqqimizdametin"],
        "layiheler" => $_POST["layiheler"],
        "layiheleraltmetin" => $_POST["layiheleraltmetin"],
        "hamisi" => $_POST["hamisi"],
        "sualcavab" => $_POST["sualcavab"],
        "istatikler" => $_POST["istatikler"],
        "gonder" => $_POST["gonder"],
        "blog" => $_POST["blog"],
        "blogaltmetin" => $_POST["blogaltmetin"],
        "reyler" => $_POST["reyler"],
        "reyleraltmetin" => $_POST["reyleraltmetin"],
        "banner" => $_POST["banner"],
        "bizimle" => $_POST["bizimle"],
        "medya" => $_POST["medya"],
        "urunbilgileri" => $_POST["urunbilgileri"],
        "satinal" => $_POST["satinal"],
        "sepeteekle" => $_POST["sepeteekle"],
        "sepetim" => $_POST["sepetim"],
        "urunresmi" => $_POST["urunresmi"],
        "urunadi" => $_POST["urunadi"],
        "urunadet" => $_POST["urunadet"],
        "urunfiyat" => $_POST["urunfiyat"],
        "kod" => $_POST["kod"],
        "islem" => $_POST["islem"],
        "siparisbilgileri" => $_POST["siparisbilgileri"],
        "siparisitamamla" => $_POST["siparisitamamla"],
        "bankahesaplari" => $_POST["bankahesaplari"],
        "referanslar" => $_POST["referanslar"],
        "kataloglar" => $_POST["kataloglar"],
        "id" => $id
    ));

    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['katalog-ekle'])) {


    $seo = seflink($_POST['adi']);

    $klasord = "../../imgupload/";
    $resim_tmpd = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpd)) {
        $resim = "no-img";
    } else {


        $random = rand(0, 999);

        $resim = $random . "-" . $seo . "." . substr($_FILES['resim']['name'], -3);

        move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $resim);
    }

    $resim_tmpd2 = $_FILES['pdf']['tmp_name'];
    if (empty($resim_tmpd2)) {
        $pdf = "no-img";
    } else {


        $random = rand(0, 999);

        $pdf = $random . "-" . $seo . "." . substr($_FILES['pdf']['name'], -3);

        move_uploaded_file($_FILES['pdf']['tmp_name'], $klasord . "/" . $pdf);
    }





    $indi = $db->prepare("insert into katalog set lan=:lan,pdf=:pdf,adi=:adi,sira=:sira,resim=:resim,veziyyeti=:veziyyeti,linki=:linki,aciklama=:aciklama");
    $elaveet = $indi->execute(array("adi" => $_POST["adi"], "lan" => $_POST["lan"], "pdf" => $_POST["pdf"], "sira" => $_POST["sira"], "resim" => $resim, "aciklama" => $_POST["aciklama"], "linki" => $_POST["linki"], "veziyyeti" => $_POST["veziyyeti"]));



    if ($elaveet) {




        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}



if (isset($_POST['katalog-yenille'])) {


    $seo = seflink($_POST['adi']);


    $tur = "katalog";

    $id = $_POST['id'];

    $klasor = "../../imgupload/";

    $resim_tmp = $_FILES['resim']['tmp_name'];

    if (empty($resim_tmp)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM katalog WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {

        $tenzimleme_qeydi = $db->query("SELECT * FROM katalog WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        if ($tenzimleme_qeydi['resim'] != "no-img") {
            unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
        }

        $random = rand(0, 999);

        $resim = $random . "-" . $seo . "." . substr($_FILES['resim']['name'], -3);

        move_uploaded_file($_FILES['resim']['tmp_name'], $klasor . "/" . $resim);
    }
    $resim_tmp2 = $_FILES['pdf']['tmp_name'];

    if (empty($resim_tmp2)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM katalog WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $pdf = $tenzimleme_qeydi['pdf'];
    } else {

        $tenzimleme_qeydi = $db->query("SELECT * FROM katalog WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        if ($tenzimleme_qeydi['pdf'] != "no-img") {
            unlink("../../imgupload/" . $tenzimleme_qeydi['pdf']);
        }

        $random = rand(0, 999);

        $pdf = $random . "-" . $seo . "." . substr($_FILES['pdf']['name'], -3);

        move_uploaded_file($_FILES['pdf']['tmp_name'], $klasor . "/" . $pdf);
    }







    $indi1 = $db->prepare("update katalog set lan=:lan,pdf=:pdf,adi=:adi,sira=:sira,resim=:resim,veziyyeti=:veziyyeti,linki=:linki,aciklama=:aciklama where id=:id");
    $elaveet1 = $indi1->execute(array("adi" => $_POST["adi"], "lan" => $_POST["lan"], "pdf" => $pdf, "sira" => $_POST["sira"], "resim" => $resim, "aciklama" => $_POST["aciklama"], "linki" => $_POST["linki"], "veziyyeti" => $_POST["veziyyeti"], "id" => $id));

    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}




if (isset($_POST['banka-ekle'])) {


    $seo = seflink($_POST['adi']);


    $klasord = "../../imgupload/";
    $resim_tmpd = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpd)) {
        $resim = "no-img";
    } else {

        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {
            $random = rand(0, 999);

            $resim = $random . "-" . $seo . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $resim);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }





    $indi = $db->prepare("insert into banka set lan=:lan,adi=:adi,sira=:sira,resim=:resim,veziyyeti=:veziyyeti,linki=:linki,aciklama=:aciklama");
    $elaveet = $indi->execute(array("adi" => $_POST["adi"], "lan" => $_POST["lan"], "sira" => $_POST["sira"], "resim" => $resim, "aciklama" => $_POST["aciklama"], "linki" => $_POST["linki"], "veziyyeti" => $_POST["veziyyeti"]));



    if ($elaveet) {




        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}



if (isset($_POST['banka-yenille'])) {


    $seo = seflink($_POST['adi']);


    $tur = "banka";

    $id = $_POST['id'];

    $klasor = "../../imgupload/";

    $resim_tmp = $_FILES['resim']['tmp_name'];

    if (empty($resim_tmp)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM banka WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM banka WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img") {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 999);

            $resim = $random . "-" . $adii . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasor . "/" . $resim);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }







    $indi1 = $db->prepare("update banka set lan=:lan,adi=:adi,sira=:sira,resim=:resim,veziyyeti=:veziyyeti,linki=:linki,aciklama=:aciklama where id=:id");
    $elaveet1 = $indi1->execute(array("adi" => $_POST["adi"], "lan" => $_POST["lan"], "sira" => $_POST["sira"], "resim" => $resim, "aciklama" => $_POST["aciklama"], "linki" => $_POST["linki"], "veziyyeti" => $_POST["veziyyeti"], "id" => $id));

    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}




if (isset($_POST['statistika-elavesi'])) {


    $seo = seflink($_POST['adi']);


    $klasord = "../../imgupload/";
    $resim_tmpd = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpd)) {
        $resim = "no-img";
    } else {

        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {
            $random = rand(0, 999);

            $resim = $random . "-" . $seo . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $resim);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }





    $indi = $db->prepare("insert into istatik set lan=:lan,adi=:adi,sira=:sira,resim=:resim,veziyyeti=:veziyyeti,linki=:linki,aciklama=:aciklama");
    $elaveet = $indi->execute(array("adi" => $_POST["adi"], "lan" => $_POST["lan"], "sira" => $_POST["sira"], "resim" => $resim, "aciklama" => $_POST["aciklama"], "linki" => $_POST["linki"], "veziyyeti" => $_POST["veziyyeti"]));



    if ($elaveet) {




        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}



if (isset($_POST['istatik-yenille'])) {


    $seo = seflink($_POST['adi']);


    $tur = "istatik";

    $id = $_POST['id'];

    $klasor = "../../imgupload/";

    $resim_tmp = $_FILES['resim']['tmp_name'];

    if (empty($resim_tmp)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM istatik WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM istatik WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img") {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 999);

            $resim = $random . "-" . $adii . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasor . "/" . $resim);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }







    $indi1 = $db->prepare("update istatik set lan=:lan,adi=:adi,sira=:sira,resim=:resim,veziyyeti=:veziyyeti,linki=:linki,aciklama=:aciklama where id=:id");
    $elaveet1 = $indi1->execute(array("adi" => $_POST["adi"], "lan" => $_POST["lan"], "sira" => $_POST["sira"], "resim" => $resim, "aciklama" => $_POST["aciklama"], "linki" => $_POST["linki"], "veziyyeti" => $_POST["veziyyeti"], "id" => $id));

    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST['addim-elavesi'])) {


    $seo = seflink($_POST['adi']);


    $klasord = "../../imgupload/";
    $resim_tmpd = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpd)) {
        $resim = "no-img";
    } else {

        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {
            $random = rand(0, 999);

            $resim = $random . "-" . $seo . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $resim);
        } else {
            $bilgi = '<div class="alert alert-error">
        <button class="close" data-dismiss="alert">×</button>
        <strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
        </div>';
        }
    }





    $indi = $db->prepare("insert into addim set lan=:lan,adi=:adi,sira=:sira,resim=:resim,veziyyeti=:veziyyeti,linki=:linki,aciklama=:aciklama");
    $elaveet = $indi->execute(array("adi" => $_POST["adi"], "lan" => $_POST["lan"], "sira" => $_POST["sira"], "resim" => $resim, "aciklama" => $_POST["aciklama"], "linki" => $_POST["linki"], "veziyyeti" => $_POST["veziyyeti"]));



    if ($elaveet) {




        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}



if (isset($_POST['addim-yenille'])) {


    $seo = seflink($_POST['adi']);


    $tur = "addim";

    $id = $_POST['id'];

    $klasor = "../../imgupload/";

    $resim_tmp = $_FILES['resim']['tmp_name'];

    if (empty($resim_tmp)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM addim WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM addim WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img") {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 999);

            $resim = $random . "-" . $adii . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasor . "/" . $resim);
        } else {
            $bilgi = '<div class="alert alert-error">
        <button class="close" data-dismiss="alert">×</button>
        <strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
        </div>';
        }
    }







    $indi1 = $db->prepare("update addim set lan=:lan,adi=:adi,sira=:sira,resim=:resim,veziyyeti=:veziyyeti,linki=:linki,aciklama=:aciklama where id=:id");
    $elaveet1 = $indi1->execute(array("adi" => $_POST["adi"], "lan" => $_POST["lan"], "sira" => $_POST["sira"], "resim" => $resim, "aciklama" => $_POST["aciklama"], "linki" => $_POST["linki"], "veziyyeti" => $_POST["veziyyeti"], "id" => $id));

    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}



if (isset($_POST['slider-elavesi'])) {


    $seo = seflink($_POST['adi']);
    $tur = "slider";
    $klasord = "../../imgupload/"; // Resimlerin yükleneceği klasör
    $tarih = date('Y-m-d H:i:s');
    
    $sira_degeri = 1;
    if (isset($_POST['sira']) && $_POST['sira'] !== '') {
        $sira_degeri = intval($_POST['sira']);
    } else {
        // Formdan sıra gelmediyse, veritabanındaki en yüksek değeri bul
        $son_sira_sorgu = $db->query("SELECT MAX(sira) AS max_sira FROM mehsullar");
        $sonuc = $son_sira_sorgu->fetch(PDO::FETCH_ASSOC);
        if ($sonuc && isset($sonuc['max_sira'])) {
            $sira_degeri = $sonuc['max_sira'] + 1;
        }
    }


    // --- Resim işleme fonksiyonunu tanımla (bu fonksiyon her iki kısımda da kullanılabilir) ---
    function handleImageUpload($file_data, $seo_name, $upload_folder, $is_icon = false)
    {
        global $bilgi; // $bilgi değişkenine erişim için global olarak tanımlıyoruz

        if (empty($file_data['tmp_name'])) {
            return "no-img";
        }

        $file_type = $file_data["type"];
        $allowed_types = array("image/gif", "image/png", "image/jpg", "image/jpeg");

        if (!in_array($file_type, $allowed_types)) {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen uygun formatta bir resim dosyası seçiniz ( .jpg - .gif - .png ).
                </div>';
            return false; // Hata veziyyetiunda false döndür
        }

        $random = rand(0, 9999999);
        $original_file_extension = pathinfo($file_data['name'], PATHINFO_EXTENSION);
        $temp_filename = $random . "-" . $seo_name . "." . $original_file_extension;
        $temp_filepath = $upload_folder . $temp_filename;

        if (!move_uploaded_file($file_data['tmp_name'], $temp_filepath)) {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Dosya yüklenemedi. Klasör izinlerini kontrol edin.
                </div>';
            return false; // Hata durumunda false döndür
        }

        // Eğer ikon değilse WebP'ye dönüştür
        if (!$is_icon) {
            $image = null;
            if ($file_type == "image/png") {
                $image = imagecreatefrompng($temp_filepath);
                imagealphablending($image, false);
                imagesavealpha($image, true);
            } elseif ($file_type == "image/gif") {
                $image = imagecreatefromgif($temp_filepath);
                imagealphablending($image, false);
                imagesavealpha($image, true);
            } else { // JPG veya JPEG ise
                $image = imagecreatefromjpeg($temp_filepath);
            }

            if ($image) {
                $output_filename = $random . '-' . $seo_name . '.webp';
                $output_filepath = $upload_folder . $output_filename;
                imagewebp($image, $output_filepath, 85); // Kalite 85 olarak ayarlandı
                imagedestroy($image);
                unlink($temp_filepath); // Geçici orijinal dosyayı sil
                return $output_filename;
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                    </div>';
                unlink($temp_filepath); // İşlem başarısız olursa geçici dosyayı yine de sil
                return false;
            }
        } else {
            // Eğer ikon ise orijinal haliyle kaydet (WebP'ye dönüştürme)
            return $temp_filename;
        }
    }
    // --- Resim işleme fonksiyonu tanımı sonu ---


    // Birinci resim (resim) işleme
    $resim = handleImageUpload($_FILES['resim'], $seo, $klasord);
    if ($resim === false) {
        // Hata oluştuysa yönlendir ve işlemi durdur
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
        exit();
    }

    // İkinci resim (resim2) işleme
    $resim2 = handleImageUpload($_FILES['resim2'], $seo, $klasord);
    if ($resim2 === false) {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
        exit();
    }

    // İkon işleme (WebP'ye dönüştürülmüyor, direkt yükleniyor)
    $icon = handleImageUpload($_FILES['icon'], $seo, $klasord, true); // true, ikon olduğunu belirtir
    if ($icon === false) {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
        exit();
    }


    // Məlumat bazasına əlavə edirik
    $indi = $db->prepare("INSERT INTO slider SET icon=:icon, lan=:lan, adi=:adi, sira=:sira, resim=:resim, resim2=:resim2, veziyyeti=:veziyyeti, aciklama=:aciklama, onaciklama=:onaciklama, linki=:linki");
    $elaveet = $indi->execute(array(
        "adi" => $_POST["adi"],
        "icon" => $icon,
        "linki" => $_POST["linki"],
        "lan" => $_POST["lan"],
        "sira" => $sira_degeri,
        "resim" => $resim,
        "resim2" => $resim2,
        "aciklama" => $_POST["aciklama"],
        "onaciklama" => $_POST["onaciklama"],
        "veziyyeti" => $_POST["veziyyeti"]
    ));

    if ($elaveet) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST['slider-yenille'])) {

    $id = $_POST['id'];


    $seo = seflink($_POST['adi']);
    $id = $_POST['id'];
    $klasor = "../../imgupload/";

    // --- Resim işleme fonksiyonunu tanımla (bu fonksiyon her iki kısımda da kullanılabilir) ---
    // (Bu fonksiyon zaten yukarıda tanımlanmışsa, bu bloğu kaldırabilirsiniz,
    // ancak dosyanızda tek bir 'seflink' fonksiyonu gibi tek bir 'handleImageUpload' olmalı)
    function handleImageUpdate($file_data, $seo_name, $upload_folder, $record_id, $column_name, $is_icon = false)
    {
        global $db, $bilgi; // $db ve $bilgi değişkenlerine erişim için global olarak tanımlıyoruz

        $tenzimleme_qeydi = $db->query("SELECT * FROM slider WHERE id = '$record_id'")->fetch(PDO::FETCH_ASSOC);

        if (empty($file_data['tmp_name'])) {
            // Yeni resim yüklenmediyse mevcut resmi koru
            return $tenzimleme_qeydi[$column_name];
        }

        $file_type = $file_data["type"];
        $allowed_types = array("image/gif", "image/png", "image/jpg", "image/jpeg");

        if (!in_array($file_type, $allowed_types)) {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Lütfen uygun formatta bir resim dosyası seçiniz ( .jpg - .gif - .png ).
                </div>';
            return $tenzimleme_qeydi[$column_name]; // Hata veziyyetiunda mevcut resmi döndür
        }

        // Eski resmi sil
        if (!empty($tenzimleme_qeydi[$column_name]) && $tenzimleme_qeydi[$column_name] != "no-img" && file_exists($upload_folder . $tenzimleme_qeydi[$column_name])) {
            @unlink($upload_folder . $tenzimleme_qeydi[$column_name]);
        }

        $random = rand(0, 9999999);
        $original_file_extension = pathinfo($file_data['name'], PATHINFO_EXTENSION);
        $temp_filename = $random . "-" . $seo_name . "." . $original_file_extension;
        $temp_filepath = $upload_folder . $temp_filename;

        if (!move_uploaded_file($file_data['tmp_name'], $temp_filepath)) {
            $bilgi = '<div class="alert alert-error">
                <button class="close" data-dismiss="alert">×</button>
                <strong>Hata !</strong> Dosya yüklenemedi. Klasör izinlerini kontrol edin.
                </div>';
            return $tenzimleme_qeydi[$column_name]; // Hata durumunda mevcut resmi döndür
        }

        // Eğer ikon değilse WebP'ye dönüştür
        if (!$is_icon) {
            $image = null;
            if ($file_type == "image/png") {
                $image = imagecreatefrompng($temp_filepath);
                imagealphablending($image, false);
                imagesavealpha($image, true);
            } elseif ($file_type == "image/gif") {
                $image = imagecreatefromgif($temp_filepath);
                imagealphablending($image, false);
                imagesavealpha($image, true);
            } else { // JPG veya JPEG ise
                $image = imagecreatefromjpeg($temp_filepath);
            }

            if ($image) {
                $output_filename = $random . '-' . $seo_name . '.webp';
                $output_filepath = $upload_folder . $output_filename;
                imagewebp($image, $output_filepath, 85); // Kalite 85 olarak ayarlandı
                imagedestroy($image);
                unlink($temp_filepath); // Geçici orijinal dosyayı sil
                return $output_filename;
            } else {
                $bilgi = '<div class="alert alert-error">
                    <button class="close" data-dismiss="alert">×</button>
                    <strong>Hata !</strong> Resim işleme sırasında bir sorun oluştu.
                    </div>';
                unlink($temp_filepath); // İşlem başarısız olursa geçici dosyayı yine de sil
                return $tenzimleme_qeydi[$column_name]; // Hata durumunda mevcut resmi döndür
            }
        } else {
            // Eğer ikon ise orijinal haliyle kaydet (WebP'ye dönüştürme yok)
            return $temp_filename;
        }
    }
    // --- Resim işleme fonksiyonu tanımı sonu ---


    // Ana resim (resim)
    $resim = handleImageUpdate($_FILES['resim'], $seo, $klasor, $id, 'resim');
    if ($resim === false) { // Hata durumunda önceki resim adını kullanacak veya "no-img" olacak
        // handleImageUpdate zaten hata mesajını ayarlıyor, burada sadece yönlendirme yapabiliriz
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
        exit();
    }


    // İkinci resim (resim2)
    $resim2 = handleImageUpdate($_FILES['resim2'], $seo, $klasor, $id, 'resim2');
    if ($resim2 === false) {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
        exit();
    }

    // İkon (icon)
    $icon = handleImageUpdate($_FILES['icon'], $seo, $klasor, $id, 'icon', true); // true, ikon olduğunu belirtir
    if ($icon === false) {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
        exit();
    }


    // VERİTABANI GÜNCELLEMESİ
    $indi1 = $db->prepare("UPDATE slider SET icon=:icon, linki=:linki, lan=:lan, adi=:adi, sira=:sira, resim=:resim, resim2=:resim2, onaciklama=:onaciklama, veziyyeti=:veziyyeti, aciklama=:aciklama WHERE id=:id");
    $elaveet1 = $indi1->execute(array(
        "adi" => $_POST["adi"],
        "icon" => $icon,
        "linki" => $_POST["linki"],
        "lan" => $_POST["lan"],
        "sira" => $_POST["sira"],
        "resim" => $resim,
        "resim2" => $resim2,
        "aciklama" => $_POST["aciklama"],
        "onaciklama" => $_POST["onaciklama"],
        "veziyyeti" => $_POST["veziyyeti"],
        "id" => $id
    ));

    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}




if (isset($_POST['qalareya-elavesi'])) {

    $seo = seflink($_POST['adi']);

    $klasord = "../../imgupload/";

    /**
     * Yüklenen bir resmi WEBP formatına dönüştürür ve belirtilen klasöre kaydeder.
     *
     * @param array $file_data $_FILES dizisinden ilgili dosya bilgisi (örn. $_FILES['resim']).
     * @param string $destination_folder Resmin kaydedileceği klasör yolu.
     * @param string $seo_name SEO dostu dosya adı için kullanılacak kök isim.
     * @return string Kaydedilen WEBP dosyasının adı veya "no-img" hata durumunda.
     */
    function convertToWebp($file_data, $destination_folder, $seo_name)
    {
        if (empty($file_data['tmp_name'])) {
            return "no-img";
        }

        $file_type = $file_data['type'];

        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {
            $random = rand(1000, 99999); // Daha geniş random aralığı
            $temp_filename = $random . "-" . uniqid() . "." . pathinfo($file_data['name'], PATHINFO_EXTENSION);
            $temp_filepath = $destination_folder . $temp_filename;

            if (!move_uploaded_file($file_data['tmp_name'], $temp_filepath)) {
                // Dosya yüklenirken hata oluştu
                error_log("Dosya yüklenemedi: " . $file_data['name']);
                return "no-img";
            }

            $image = null;
            switch ($file_type) {
                case 'image/jpeg':
                case 'image/jpg':
                    $image = imagecreatefromjpeg($temp_filepath);
                    break;
                case 'image/png':
                    $image = imagecreatefrompng($temp_filepath);
                    // PNG'ler için şeffaflığı korumak önemlidir
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                    break;
                case 'image/gif':
                    $image = imagecreatefromgif($temp_filepath);
                    break;
                default:
                    // Desteklenmeyen resim tipi, ancak yukarıda kontrol edildiği için buraya gelmemeli
                    break;
            }

            if ($image) {
                $output_filename = $random . "-" . $seo_name . '.webp';
                $output_filepath = $destination_folder . $output_filename;

                // WEBP dönüşümünü yap
                if (imagewebp($image, $output_filepath, 85)) { // Kaliteyi %85 olarak ayarladım
                    imagedestroy($image);
                    unlink($temp_filepath); // Geçici orijinal dosyayı sil
                    return $output_filename;
                } else {
                    error_log("WEBP dönüştürme başarısız: " . $file_data['name']);
                    imagedestroy($image);
                    unlink($temp_filepath); // Dönüşüm başarısız olsa da geçici dosyayı sil
                    return "no-img";
                }
            } else {
                error_log("Resim oluşturulamadı (GD hatası): " . $file_data['name']);
                unlink($temp_filepath); // Oluşturma başarısız olursa geçici dosyayı sil
                return "no-img";
            }
        } else {
            // Desteklenmeyen dosya tipi
            error_log("Desteklenmeyen dosya tipi: " . $file_type . " for " . $file_data['name']);
            return "no-img";
        }
    }


    // resim alanı (ana resim)
    $resim = convertToWebp($_FILES['resim'], $klasord, $seo);

    // xidmetsekli alanı (hizmet resmi)
    $xidmetsekli = convertToWebp($_FILES['xidmetsekli'], $klasord, $seo);

    // xebersekli alanı (haber resmi)
    $xebersekli = convertToWebp($_FILES['xebersekli'], $klasord, $seo);

    // layihesekli alanı (layihe resmi)
    $layihesekli = convertToWebp($_FILES['layihesekli'], $klasord, $seo);

    // mehsusekli alanı (ürün resmi)
    $mehsusekli = convertToWebp($_FILES['mehsusekli'], $klasord, $seo);


    // INSERT sorgusu güncellendi
    $indi = $db->prepare("INSERT INTO galeri SET
        lan = :lan,
        adi = :adi,
        sira = :sira,
        resim = :resim,
        xidmetsekli = :xidmetsekli,
        xebersekli = :xebersekli,
        layihesekli = :layihesekli,
        mehsusekli = :mehsusekli,
        veziyyeti = :veziyyeti,
        aciklama = :aciklama,
        kategori = :kategori,
        xidmet_kateqoriya = :xidmet_kateqoriya,
        xeber_kateqoriya = :xeber_kateqoriya,
        mehsul_kateqoriya = :mehsul_kateqoriya,
        layihe_kateqoriya = :layihe_kateqoriya");

    $elaveet = $indi->execute(array(
        "lan" => $_POST["lan"],
        "adi" => $_POST["adi"],
        "sira" => $_POST["sira"],
        "resim" => $resim,
        "xidmetsekli" => $xidmetsekli,
        "xebersekli" => $xebersekli,
        "layihesekli" => $layihesekli,
        "mehsusekli" => $mehsusekli,
        "aciklama" => $_POST["aciklama"],
        "veziyyeti" => $_POST["veziyyeti"],
        "kategori" => isset($_POST["kategori"]) ? $_POST["kategori"] : 0,
        "xidmet_kateqoriya" => isset($_POST["xidmet_kateqoriya"]) ? $_POST["xidmet_kateqoriya"] : 0,
        "xeber_kateqoriya" => isset($_POST["xeber_kateqoriya"]) ? $_POST["xeber_kateqoriya"] : 0,
        "mehsul_kateqoriya" => isset($_POST["mehsul_kateqoriya"]) ? $_POST["mehsul_kateqoriya"] : 0,
        "layihe_kateqoriya" => isset($_POST["layihe_kateqoriya"]) ? $_POST["layihe_kateqoriya"] : 0
    ));


    if ($elaveet) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST['galeri-yenille'])) {

    $seo = seflink($_POST['adi']);

    $id = $_POST['id'];

    $klasor = "../../imgupload/";

    /**
     * Yüklenen bir resmi WEBP formatına dönüştürür, belirtilen klasöre kaydeder ve eski resmi siler.
     *
     * @param array $file_data $_FILES dizisinden ilgili dosya bilgisi (örn. $_FILES['resim']).
     * @param string $destination_folder Resmin kaydedileceği klasör yolu.
     * @param string $seo_name SEO dostu dosya adı için kullanılacak kök isim.
     * @param string $old_image_name Eski resmin adı (veritabanından çekilen).
     * @return string Kaydedilen WEBP dosyasının adı veya eski resmin adı hata durumunda.
     */
    function updateAndConvert($file_data, $destination_folder, $seo_name, $old_image_name)
    {
        if (empty($file_data['tmp_name'])) {
            return $old_image_name; // Yeni dosya yüklenmediyse eski ismi döndür
        }

        $file_type = $file_data['type'];

        if ($file_type == "image/gif" || $file_type == "image/png" || $file_type == "image/jpg" || $file_type == "image/jpeg") {

            // Eski resmi sil
            if ($old_image_name != "no-img" && file_exists($destination_folder . $old_image_name)) {
                unlink($destination_folder . $old_image_name);
            }

            $random = rand(1000, 99999); // Daha geniş random aralığı
            $temp_filename = $random . "-" . uniqid() . "." . pathinfo($file_data['name'], PATHINFO_EXTENSION);
            $temp_filepath = $destination_folder . $temp_filename;

            if (!move_uploaded_file($file_data['tmp_name'], $temp_filepath)) {
                error_log("Dosya yüklenemedi (Güncelleme): " . $file_data['name']);
                return $old_image_name; // Yükleme hatasında eski resmi koru
            }

            $image = null;
            switch ($file_type) {
                case 'image/jpeg':
                case 'image/jpg':
                    $image = imagecreatefromjpeg($temp_filepath);
                    break;
                case 'image/png':
                    $image = imagecreatefrompng($temp_filepath);
                    imagealphablending($image, false);
                    imagesavealpha($image, true);
                    break;
                case 'image/gif':
                    $image = imagecreatefromgif($temp_filepath);
                    break;
                default:
                    break;
            }

            if ($image) {
                $output_filename = $random . "-" . $seo_name . '.webp';
                $output_filepath = $destination_folder . $output_filename;

                if (imagewebp($image, $output_filepath, 85)) { // Kaliteyi %85 olarak ayarladım
                    imagedestroy($image);
                    unlink($temp_filepath); // Geçici orijinal dosyayı sil
                    return $output_filename;
                } else {
                    error_log("WEBP dönüştürme başarısız (Güncelleme): " . $file_data['name']);
                    imagedestroy($image);
                    unlink($temp_filepath); // Dönüşüm başarısız olsa da geçici dosyayı sil
                    return $old_image_name; // Dönüşüm başarısız olursa eski resmi tut
                }
            } else {
                error_log("Resim oluşturulamadı (GD hatası - Güncelleme): " . $file_data['name']);
                unlink($temp_filepath); // Oluşturma başarısız olursa geçici dosyayı sil
                return $old_image_name; // Resim oluşturulamazsa eski resmi tut
            }
        } else {
            error_log("Desteklenmeyen dosya tipi (Güncelleme): " . $file_type . " for " . $file_data['name']);
            return $old_image_name; // Desteklenmeyen dosya tipi olursa eski resmi tut
        }
    }


    // Mevcut resim adlarını veritabanından çek
    // Bu kısım, her bir updateAndConvert çağrısı içinde yapılıyor, ancak dışarıda bir kez çekmek daha verimli olur.
    // PDO bağlantısını fonksiyona parametre olarak geçirmemiz gerektiği için bu şekilde bıraktım.
    // Eğer $db global ise, her fonksiyon içinde global $db; diyerek de erişilebilir.
    $current_images_query = $db->prepare("SELECT resim, xidmetsekli, xebersekli, layihesekli, mehsusekli FROM galeri WHERE id = :id");
    $current_images_query->execute([':id' => $id]);
    $current_images = $current_images_query->fetch(PDO::FETCH_ASSOC);


    // resim alanı (ana resim)
    $resim = updateAndConvert($_FILES['resim'], $klasor, $seo, $current_images['resim']);

    // xidmetsekli alanı (hizmet resmi)
    $xidmetsekli = updateAndConvert($_FILES['xidmetsekli'], $klasor, $seo, $current_images['xidmetsekli']);

    // xebersekli alanı (haber resmi)
    $xebersekli = updateAndConvert($_FILES['xebersekli'], $klasor, $seo, $current_images['xebersekli']);

    // layihesekli alanı (layihe resmi)
    $layihesekli = updateAndConvert($_FILES['layihesekli'], $klasor, $seo, $current_images['layihesekli']);

    // mehsusekli alanı (ürün resmi)
    $mehsusekli = updateAndConvert($_FILES['mehsusekli'], $klasor, $seo, $current_images['mehsusekli']);


    // UPDATE sorgusu güncellendi
    $indi1 = $db->prepare("UPDATE galeri SET
        lan = :lan,
        adi = :adi,
        sira = :sira,
        resim = :resim,
        xidmetsekli = :xidmetsekli,
        xebersekli = :xebersekli,
        layihesekli = :layihesekli,
        mehsusekli = :mehsusekli,
        veziyyeti = :veziyyeti,
        aciklama = :aciklama,
        kategori = :kategori,
        xidmet_kateqoriya = :xidmet_kateqoriya,
        xeber_kateqoriya = :xeber_kateqoriya,
        mehsul_kateqoriya = :mehsul_kateqoriya,
        layihe_kateqoriya = :layihe_kateqoriya
        WHERE id = :id");

    $elaveet1 = $indi1->execute(array(
        "lan" => $_POST["lan"],
        "adi" => $_POST["adi"],
        "sira" => $_POST["sira"],
        "resim" => $resim,
        "xidmetsekli" => $xidmetsekli,
        "xebersekli" => $xebersekli,
        "layihesekli" => $layihesekli,
        "mehsusekli" => $mehsusekli,
        "aciklama" => $_POST["aciklama"],
        "veziyyeti" => $_POST["veziyyeti"],
        "kategori" => isset($_POST["kategori"]) ? $_POST["kategori"] : 0,
        "xidmet_kateqoriya" => isset($_POST["xidmet_kateqoriya"]) ? $_POST["xidmet_kateqoriya"] : 0,
        "xeber_kateqoriya" => isset($_POST["xeber_kateqoriya"]) ? $_POST["xeber_kateqoriya"] : 0,
        "mehsul_kateqoriya" => isset($_POST["mehsul_kateqoriya"]) ? $_POST["mehsul_kateqoriya"] : 0,
        "layihe_kateqoriya" => isset($_POST["layihe_kateqoriya"]) ? $_POST["layihe_kateqoriya"] : 0,
        "id" => $id
    ));

    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}




if (isset($_POST['hesabim-yenille'])) {
    $email = guvenliGiris($_POST["email"]);
    $telefon = guvenliGiris($_POST["telefon"]);
    $adsoyad = guvenliGiris($_POST["adsoyad"]);
    $uye = (int)$_POST["uye"];

    if (!empty($_POST["sifre"])) {
        $sifre = password_hash($_POST["sifre"], PASSWORD_DEFAULT);
        $elaveet = guvenliSorgu(
            $db,
            "UPDATE uyeler SET email = :email, telefon = :telefon, adsoyad = :adsoyad, sifre = :sifre WHERE id = :id",
            ["email" => $email, "telefon" => $telefon, "adsoyad" => $adsoyad, "sifre" => $sifre, "id" => $uye]
        );
    } else {
        $elaveet = guvenliSorgu(
            $db,
            "UPDATE uyeler SET email = :email, telefon = :telefon, adsoyad = :adsoyad WHERE id = :id",
            ["email" => $email, "telefon" => $telefon, "adsoyad" => $adsoyad, "id" => $uye]
        );
    }

    if ($elaveet) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
        exit;
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
        exit;
    }
}

if (isset($_POST['admin-elavesi'])) {
    $ad_soyad = guvenliGiris($_POST["ad_soyad"]);
    $eposta = guvenliGiris($_POST["eposta"]);
    $sifre = password_hash($_POST["sifre"], PASSWORD_DEFAULT);

    $elaveet = guvenliSorgu($db, "INSERT INTO admin SET ...", [
        "INSERT INTO admin SET 
        ad_soyad = :ad_soyad,
        eposta = :eposta,
        sifre = :sifre,
        modul = :modul,
        ilk_giris = :ilk_giris,
        ref = :ref,
        xidmet = :xidmet,
        statistika = :statistika,
        addim = :addim,
        sualcavab = :sualcavab,
        sifaris = :sifaris,
        foto = :foto,
        video = :video,
        teklif = :teklif,
        elaqe = :elaqe,
        layihe = :layihe,
        sertifikat = :sertifikat,
        paket = :paket,
        rey = :rey,
        sehife = :sehife,
        kom = :kom,
        slider = :slider,
        menyu = :menyu,
        lan = :lan,
        admin = :admin,
        blog = :blog,
        sayt = :sayt,
        mehsul = :mehsul",
        [
            "ad_soyad" => $ad_soyad,
            "eposta" => $eposta,
            "sifre" => $sifre,
            "modul" => $_POST["modul"],
            "ilk_giris" => $tarih,
            "ref" => $_POST["ref"],
            "xidmet" => $_POST["xidmet"],
            "statistika" => $_POST["statistika"],
            "addim" => $_POST["addim"],
            "sualcavab" => $_POST["sualcavab"],
            "sifaris" => $_POST["sifaris"],
            "foto" => $_POST["foto"],
            "video" => $_POST["video"],
            "teklif" => $_POST["teklif"],
            "elaqe" => $_POST["elaqe"],
            "layihe" => $_POST["layihe"],
            "sertifikat" => $_POST["sertifikat"],
            "paket" => $_POST["paket"],
            "rey" => $_POST["rey"],
            "sehife" => $_POST["sehife"],
            "kom" => $_POST["kom"],
            "slider" => $_POST["slider"],
            "menyu" => $_POST["menyu"],
            "lan" => $_POST["lan"],
            "admin" => $_POST["admin"],
            "blog" => $_POST["blog"],
            "sayt" => $_POST["sayt"],
            "mehsul" => $_POST["mehsul"]
        ]
    ]);

    if ($elaveet) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
        exit;
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
        exit;
    }
}

if (isset($_POST['admin-yenille'])) {
    // Şifre alanı doluysa hash'le, boşsa mevcut şifreyi koru
    if (!empty($_POST["sifre"])) {
        $sifre = password_hash($_POST["sifre"], PASSWORD_DEFAULT);
        $sifreGuncelle = ", sifre = :sifre";
    } else {
        // Mevcut şifreyi al
        $mevcutSifre = $db->query("SELECT sifre FROM admin WHERE id = {$_POST['id']}")->fetchColumn();
        $sifre = $mevcutSifre;
        $sifreGuncelle = "";
    }

    $sql = "UPDATE admin SET 
                mehsul = :mehsul,
                ad_soyad = :ad_soyad,
                eposta = :eposta,
                modul = :modul,
                admin = :admin,
                sualcavab = :sualcavab,
                statistika = :statistika,
                addim = :addim,
                teklif = :teklif,
                sifaris = :sifaris,
                foto = :foto,
                video = :video,
                ref = :ref,
                blog = :blog,
                xidmet = :xidmet,
                elaqe = :elaqe,
                layihe = :layihe,
                sertifikat = :sertifikat,
                paket = :paket,
                rey = :rey,
                sehife = :sehife,
                kom = :kom,
                slider = :slider,
                sayt = :sayt,
                menyu = :menyu,
                lan = :lan
                {$sifreGuncelle}
            WHERE id = :id";

    $elaveet = $db->prepare($sql);

    $params = [
        "mehsul" => $_POST["mehsul"],
        "ad_soyad" => $_POST["ad_soyad"],
        "eposta" => $_POST["eposta"],
        "modul" => $_POST["modul"],
        "admin" => $_POST["admin"],
        "sualcavab" => $_POST["sualcavab"],
        "statistika" => $_POST["statistika"],
        "addim" => $_POST["addim"],
        "teklif" => $_POST["teklif"],
        "sifaris" => $_POST["sifaris"],
        "foto" => $_POST["foto"],
        "video" => $_POST["video"],
        "ref" => $_POST["ref"],
        "blog" => $_POST["blog"],
        "xidmet" => $_POST["xidmet"],
        "elaqe" => $_POST["elaqe"],
        "layihe" => $_POST["layihe"],
        "sertifikat" => $_POST["sertifikat"],
        "paket" => $_POST["paket"],
        "rey" => $_POST["rey"],
        "sehife" => $_POST["sehife"],
        "kom" => $_POST["kom"],
        "slider" => $_POST["slider"],
        "sayt" => $_POST["sayt"],
        "menyu" => $_POST["menyu"],
        "lan" => $_POST["lan"],
        "id" => $_POST["id"]
    ];

    // Şifre güncellenecekse parametreye ekle
    if (!empty($_POST["sifre"])) {
        $params["sifre"] = $sifre;
    }

    $indi = $elaveet->execute($params);

    if ($indi) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
        exit;
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
        exit;
    }
}

if (isset($_POST['video-elavesi'])) {


    $seo = seflink($_POST['adi']);


    $tur = "slider";

    $klasord = "../../imgupload/";
    $resim_tmpd = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpd)) {
        $resim = "no-img";
    } else {

        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {
            $random = rand(0, 999);

            $resim1 = $random . "-" . $seo . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $resim1);

            $file = "../../imgupload/" . $resim1;
            $image = imagecreatefromstring(file_get_contents($file));
            ob_start();
            imagejpeg($image, NULL, 100);
            $cont = ob_get_contents();
            ob_end_clean();
            $randomm = rand(0, 965465465465456);
            imagedestroy($image);
            $content = imagecreatefromstring($cont);
            $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
            $resim = $random . '-' . $seo . '.webp';
            imagewebp($content, $output);
            imagedestroy($content);
            unlink('../../imgupload/' . $resim1);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }





    $indi = $db->prepare("insert into video set linki=:linki,lan=:lan,adi=:adi,sira=:sira,resim=:resim,veziyyeti=:veziyyeti,aciklama=:aciklama");
    $elaveet = $indi->execute(array("linki" => $_POST["linki"], "adi" => $_POST["adi"], "lan" => $_POST["lan"], "sira" => $_POST["sira"], "resim" => $resim, "aciklama" => $_POST["aciklama"], "veziyyeti" => $_POST["veziyyeti"]));



    if ($elaveet) {



        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}



if (isset($_POST['video-yenille'])) {

    $seo = seflink($_POST['adi']);


    $tur = "slider";

    $id = $_POST['id'];

    $klasor = "../../imgupload/";

    $resim_tmp = $_FILES['resim']['tmp_name'];

    if (empty($resim_tmp)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM video WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM video WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img") {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 999);

            $resim1 = $random . "-" . $adii . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasor . "/" . $resim1);



            $file = "../../imgupload/" . $resim1;
            $image = imagecreatefromstring(file_get_contents($file));
            ob_start();
            imagejpeg($image, NULL, 100);
            $cont = ob_get_contents();
            ob_end_clean();
            $randomm = rand(0, 965465465465456);
            imagedestroy($image);
            $content = imagecreatefromstring($cont);
            $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
            $resim = $random . '-' . $seo . '.webp';
            imagewebp($content, $output);
            imagedestroy($content);
            unlink('../../imgupload/' . $resim1);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }







    $indi1 = $db->prepare("update video set linki=:linki,lan=:lan,adi=:adi,sira=:sira,resim=:resim,veziyyeti=:veziyyeti,aciklama=:aciklama where id=:id");
    $elaveet1 = $indi1->execute(array("linki" => $_POST["linki"], "adi" => $_POST["adi"], "lan" => $_POST["lan"], "sira" => $_POST["sira"], "resim" => $resim, "aciklama" => $_POST["aciklama"], "veziyyeti" => $_POST["veziyyeti"], "id" => $id));

    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}


if (isset($_POST['komanda-elavesi'])) {

    $seo = seflink($_POST['adi']);


    $tur = "komandamiz";

    $klasord = "../../imgupload/";
    $tarih = date('Y-m-d H:i:s');
    
    $sira_degeri = 1;
    if (isset($_POST['sira']) && $_POST['sira'] !== '') {
        $sira_degeri = intval($_POST['sira']);
    } else {
        // Formdan sıra gelmediyse, veritabanındaki en yüksek değeri bul
        $son_sira_sorgu = $db->query("SELECT MAX(sira) AS max_sira FROM mehsullar");
        $sonuc = $son_sira_sorgu->fetch(PDO::FETCH_ASSOC);
        if ($sonuc && isset($sonuc['max_sira'])) {
            $sira_degeri = $sonuc['max_sira'] + 1;
        }
    }
    
    $resim_tmpd = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpd)) {
        $resim = "no-img";
    } else {

        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {
            $random = rand(0, 999);

            $resim = $random . "-" . $seo . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $resim);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }





    $indi = $db->prepare("insert into komandamiz set lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,eklenme_tarihi=:eklenme_tarihi");
    $elaveet = $indi->execute(array("adi" => $_POST["adi"], "lan" => $_POST["lan"], "sira" => $sira_degeri, "resim" => $resim, "kategori" => $kategori, "aciklama" => $_POST["aciklama"], "seo" => $seo, "tur" => $tur, "onaciklama" => $_POST["onaciklama"], "veziyyeti" => $_POST["veziyyeti"], "eklenme_tarihi" => $tarih));



    if ($elaveet) {

        $sonid = $db->query("select * from komandamiz order by id desc")->fetch(PDO::FETCH_ASSOC);

        $yeni = $sonid['id'];
        if (isset($_POST['img'])) {
            foreach ($_POST['img'] as $img) {
                $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?, tur=?");
                $islem = $islem->execute(array($yeni, $img, $tur));
            }
        }


        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}



if (isset($_POST['ekibimiz-yenille'])) {


    $seo = seflink($_POST['adi']);


    $tur = "komandamiz";

    $id = $_POST['id'];

    $klasor = "../../imgupload/";

    $resim_tmp = $_FILES['resim']['tmp_name'];

    if (empty($resim_tmp)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM komandamiz WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM komandamiz WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img") {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 999);

            $resim = $random . "-" . $adii . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasor . "/" . $resim);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }



    $deleteee = $db->exec("DELETE FROM urun_img WHERE urun_id = '$id' and tur='komandamiz' ");

    if (isset($_POST['img'])) {
        foreach ($_POST['img'] as $img) {


            $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?,tur=?");
            $islem = $islem->execute(array($id, $img, $tur));
        }
    }




    $indi1 = $db->prepare("update komandamiz set lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,guncelleme_tarihi=:guncelleme_tarihi where id=:id");
    $elaveet1 = $indi1->execute(array("adi" => $_POST["adi"], "lan" => $_POST["lan"], "sira" => $_POST["sira"], "resim" => $resim, "kategori" => $_POST["kategori"], "aciklama" => $_POST["aciklama"], "seo" => $seo, "tur" => $tur, "onaciklama" => $_POST["onaciklama"], "veziyyeti" => $_POST["veziyyeti"], "guncelleme_tarihi" => $tarih, "id" => $id));

    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}




if (isset($_POST['rey-elavesi'])) {


    $seo = seflink($_POST['adi']);


    $tur = "reyler";

    $klasord = "../../imgupload/";
    $tarih = date('Y-m-d H:i:s');
    
    $sira_degeri = 1;
    if (isset($_POST['sira']) && $_POST['sira'] !== '') {
        $sira_degeri = intval($_POST['sira']);
    } else {
        // Formdan sıra gelmediyse, veritabanındaki en yüksek değeri bul
        $son_sira_sorgu = $db->query("SELECT MAX(sira) AS max_sira FROM mehsullar");
        $sonuc = $son_sira_sorgu->fetch(PDO::FETCH_ASSOC);
        if ($sonuc && isset($sonuc['max_sira'])) {
            $sira_degeri = $sonuc['max_sira'] + 1;
        }
    }

    $resim_tmpd = $_FILES['resim']['tmp_name'];
    if (empty($resim_tmpd)) {
        $resim = "no-img";
    } else {

        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {
            $random = rand(0, 999);

            $resim1 = $random . "-" . $seo . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasord . "/" . $resim1);

            $file = "../../imgupload/" . $resim1;
            $image = imagecreatefromstring(file_get_contents($file));
            ob_start();
            imagejpeg($image, NULL, 100);
            $cont = ob_get_contents();
            ob_end_clean();
            $randomm = rand(0, 965465465465456);
            imagedestroy($image);
            $content = imagecreatefromstring($cont);
            $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
            $resim = $random . '-' . $seo . '.webp';
            imagewebp($content, $output);
            imagedestroy($content);
            unlink('../../imgupload/' . $resim1);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }





    $indi = $db->prepare("insert into reyler set lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,eklenme_tarihi=:eklenme_tarihi");
    $elaveet = $indi->execute(array("adi" => $_POST["adi"], "lan" => $_POST["lan"], "sira" => $sira_degeri, "resim" => $resim, "kategori" => $kategori, "aciklama" => $_POST["aciklama"], "seo" => $seo, "tur" => $tur, "onaciklama" => $_POST["onaciklama"], "veziyyeti" => $_POST["veziyyeti"], "eklenme_tarihi" => $tarih));



    if ($elaveet) {

        $sonid = $db->query("select * from reyler order by id desc")->fetch(PDO::FETCH_ASSOC);

        $yeni = $sonid['id'];
        if (isset($_POST['img'])) {
            foreach ($_POST['img'] as $img) {
                $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?, tur=?");
                $islem = $islem->execute(array($yeni, $img, $tur));
            }
        }


        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}



if (isset($_POST['yorum-yenille'])) {

    $seo = seflink($_POST['adi']);


    $tur = "reyler";

    $id = $_POST['id'];

    $klasor = "../../imgupload/";

    $resim_tmp = $_FILES['resim']['tmp_name'];

    if (empty($resim_tmp)) {
        $duzenlenecek_id = $_GET['id'];
        $tenzimleme_qeydi = $db->query("SELECT * FROM reyler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
        $resim = $tenzimleme_qeydi['resim'];
    } else {
        if ($_FILES["resim"]["type"] == "image/gif" || $_FILES["resim"]["type"] == "image/png" || $_FILES["resim"]["type"] == "image/jpg" || $_FILES["resim"]["type"] == "image/jpeg") {

            $tenzimleme_qeydi = $db->query("SELECT * FROM reyler WHERE id = '$id'")->fetch(PDO::FETCH_ASSOC);
            if ($tenzimleme_qeydi['resim'] != "no-img") {
                unlink("../../imgupload/" . $tenzimleme_qeydi['resim']);
            }

            $random = rand(0, 999);

            $resim1 = $random . "-" . $adii . "." . substr($_FILES['resim']['name'], -3);

            move_uploaded_file($_FILES['resim']['tmp_name'], $klasor . "/" . $resim1);



            $file = "../../imgupload/" . $resim1;
            $image = imagecreatefromstring(file_get_contents($file));
            ob_start();
            imagejpeg($image, NULL, 100);
            $cont = ob_get_contents();
            ob_end_clean();
            $randomm = rand(0, 965465465465456);
            imagedestroy($image);
            $content = imagecreatefromstring($cont);
            $output = '../../imgupload/' . $random . '-' . $seo . '.webp';
            $resim = $random . '-' . $seo . '.webp';
            imagewebp($content, $output);
            imagedestroy($content);
            unlink('../../imgupload/' . $resim1);
        } else {
            $bilgi = '<div class="alert alert-error">
		<button class="close" data-dismiss="alert">×</button>
		<strong>Xeta !</strong> Lütfen  Uygun Formatta Bir Resim Dosyası Seçiniz ( .jpg - .gif - .png ).
		</div>';
        }
    }



    $deleteee = $db->exec("DELETE FROM urun_img WHERE urun_id = '$id' and tur='reyler' ");

    if (isset($_POST['img'])) {
        foreach ($_POST['img'] as $img) {


            $islem = $db->prepare("INSERT INTO urun_img SET urun_id = ?, img = ?,tur=?");
            $islem = $islem->execute(array($id, $img, $tur));
        }
    }




    $indi1 = $db->prepare("update reyler set lan=:lan,adi=:adi,sira=:sira,resim=:resim,kategori=:kategori,veziyyeti=:veziyyeti,onaciklama=:onaciklama,aciklama=:aciklama,seo=:seo,tur=:tur,guncelleme_tarihi=:guncelleme_tarihi where id=:id");
    $elaveet1 = $indi1->execute(array("adi" => $_POST["adi"], "lan" => $_POST["lan"], "sira" => $_POST["sira"], "resim" => $resim, "kategori" => $_POST["kategori"], "aciklama" => $_POST["aciklama"], "seo" => $seo, "tur" => $tur, "onaciklama" => $_POST["onaciklama"], "veziyyeti" => $_POST["veziyyeti"], "guncelleme_tarihi" => $tarih, "id" => $id));

    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

if (isset($_POST['cvs-elavesi'])) {


    $seo = seflink($_POST['adi']);


    $indi = $db->prepare("insert into cvs set kategori=:kategori,lan=:lan,adi=:adi,sira=:sira,veziyyeti=:veziyyeti,aciklama=:aciklama");
    $elaveet = $indi->execute(array("adi" => $_POST["adi"], "kategori" => $_POST["kategori"], "lan" => $_POST["lan"], "sira" => $sira_degeri,"aciklama" => $_POST["aciklama"], "veziyyeti" => $_POST["veziyyeti"]));



    if ($elaveet) {



        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}



if (isset($_POST['sss-yenille'])) {


    $seo = seflink($_POST['adi']);


    $tur = "reyler";

    $id = $_POST['id'];


    $indi1 = $db->prepare("update cvs set kategori=:kategori,lan=:lan,adi=:adi,sira=:sira,veziyyeti=:veziyyeti,aciklama=:aciklama where id=:id");
    $elaveet1 = $indi1->execute(array("lan" => $_POST["lan"], "kategori" => $_POST["kategori"], "adi" => $_POST["adi"], "sira" => $_POST["sira"], "aciklama" => $_POST["aciklama"], "veziyyeti" => $_POST["veziyyeti"], "id" => $id));

    if ($elaveet1) {
        header('location:' . $_POST['link'] . '?veziyyeti=Ugurlu');
    } else {
        header('location:' . $_POST['link'] . '?veziyyeti=Xeta');
    }
}

/*
$idd=$hizmetd_dizi["id"];
$ip=$_SERVER["REMOTE_ADDR"];
$sor=$db->query("select * from ip_adresi where ip='$ip' and urun_id='$idd'")->fetch(PDO::FETCH_ASSOC);
	if($sor==false){
		if($sor["urun_id"]!=$hizmetd_dizi["id"]){
		$urun_id=$hizmetd_dizi["id"];
		$query=$db->prepare("insert into ip_adresi set ip = :ip, urun_id = :urun_id, zaman = :zaman");
		$insert=$query->execute(array("ip" =>$ip, "urun_id" =>$urun_id, "zaman" =>$tarih ));	
		
		$hitsayisi=$hizmetd_dizi["hit"]+1;
		
		
		$artir = $db->prepare("UPDATE xidmetler SET
		hit = :hit
		WHERE id = :id");
		$update = $artir->execute(array(
			 "hit" => $hitsayisi,
			 "id" => $id
		));
		}
	}
*/
