<?php
session_start();

// Session timeout süresi (30 dakika)
$timeout = 1800;

// Son aktivite zamanını kontrol et
if (isset($_SESSION['admin_last_activity']) && (time() - $_SESSION['admin_last_activity'] > $timeout)) {
    // Session'ı sonlandır
    session_unset();
    session_destroy();
    header("Location: ../daxil-ol.php");
    exit();
}

// Oturum kontrolü
if (!isset($_SESSION['admin_id'])) {
    header("Location: ../daxil-ol.php");
    exit();
}

// Son aktivite zamanını güncelle
$_SESSION['admin_last_activity'] = time();

// Session hijacking koruması
if (!isset($_SESSION['admin_ip'])) {
    $_SESSION['admin_ip'] = $_SERVER['REMOTE_ADDR'];
} else if ($_SESSION['admin_ip'] !== $_SERVER['REMOTE_ADDR']) {
    session_unset();
    session_destroy();
    header("Location: ../daxil-ol.php");
    exit();
}

// Session cookie güvenliği
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', 1);
ini_set('session.cookie_samesite', 'Strict');
?> 